/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.cultura;

import com.joseflavio.cultura.DataTransformacao;
import com.joseflavio.cultura.DataTransformacao_en_US;
import com.joseflavio.cultura.DataTransformacao_pt_BR;
import com.joseflavio.cultura.Moeda;
import com.joseflavio.cultura.Moeda_BR;
import com.joseflavio.cultura.Moeda_US;
import com.joseflavio.cultura.NumeroTransformacao;
import com.joseflavio.cultura.Sintaxe;
import com.joseflavio.cultura.Sintaxe_en_US;
import com.joseflavio.cultura.Sintaxe_pt_BR;
import com.joseflavio.util.Calendario;
import java.util.Calendar;
import java.util.Locale;

public final class Cultura {
    private static Cultura culturaPadrao = Cultura.getPadraoMV();
    public static final Cultura BRASILEIRA = new Cultura("pt", "BR", "");
    public static final Cultura NORTE_AMERICANA = new Cultura("en", "US", "");
    private String lingua;
    private String pais;
    private String variante;
    private String toString = null;
    private Sintaxe sintaxe;
    private Moeda moeda;

    public Cultura(String lingua) {
        this(lingua, "", "");
    }

    public Cultura(String lingua, String pais) {
        this(lingua, pais, "");
    }

    public Cultura(String lingua, String pais, String variante) {
        this.lingua = lingua != null ? lingua : "";
        this.pais = pais != null ? pais : "";
        this.variante = variante != null ? variante : "";
    }

    private static final Cultura getPadraoMV() {
        String cultura = System.getProperty("microedition.locale");
        if (cultura == null) {
            String sysv;
            String sysp;
            String sysl = System.getProperty("user.language");
            if (sysl == null) {
                sysl = "";
            }
            if ((sysp = System.getProperty("user.country")) == null) {
                sysp = "";
            }
            if ((sysv = System.getProperty("user.variant")) == null) {
                sysv = "";
            }
            cultura = sysl + '_' + sysp + '_' + sysv + '_';
        } else {
            cultura = cultura + '_';
            cultura = cultura.replace('-', '_');
        }
        int total = 0;
        for (int i = 0; i < cultura.length(); ++i) {
            if (cultura.charAt(i) != '_') continue;
            ++total;
        }
        if (total == 1) {
            cultura = cultura + "__";
        } else if (total == 2) {
            cultura = cultura + '_';
        }
        int begin = 0;
        int end = cultura.indexOf(95, begin);
        String lingua = cultura.substring(begin, end);
        begin = end + 1;
        end = cultura.indexOf(95, begin);
        String pais = cultura.substring(begin, end);
        begin = end + 1;
        end = cultura.indexOf(95, begin);
        String variante = cultura.substring(begin, end);
        return new Cultura(lingua, pais, variante);
    }

    public static Cultura getPadrao() {
        return culturaPadrao;
    }

    public static Cultura getCultura(String nome) {
        if (nome == null) {
            return null;
        }
        if (nome.equals("pt-BR")) {
            return BRASILEIRA;
        }
        if (nome.equals("en-US")) {
            return NORTE_AMERICANA;
        }
        return null;
    }

    public static void setPadrao(Cultura cultura) {
        culturaPadrao = cultura;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cultura)) {
            return false;
        }
        return this.lingua.equals(((Cultura)obj).lingua) && this.pais.equals(((Cultura)obj).pais) && this.variante.equals(((Cultura)obj).variante);
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        boolean l = this.lingua.length() != 0;
        boolean p = this.pais.length() != 0;
        boolean v = this.variante.length() != 0;
        StringBuilder result = new StringBuilder(this.lingua);
        if (p || l && v) {
            result.append('_').append(this.pais);
        }
        if (v && (l || p)) {
            result.append('_').append(this.variante);
        }
        this.toString = result.toString();
        return this.toString;
    }

    public String getPais() {
        return this.pais;
    }

    public String getLingua() {
        return this.lingua;
    }

    public String getVariante() {
        return this.variante;
    }

    public Sintaxe getSintaxe() {
        if (this.sintaxe != null) {
            return this.sintaxe;
        }
        this.sintaxe = this.equals(NORTE_AMERICANA) ? Sintaxe_en_US.instancia : Sintaxe_pt_BR.instancia;
        return this.sintaxe;
    }

    public Moeda getMoeda() {
        if (this.moeda != null) {
            return this.moeda;
        }
        this.moeda = this.equals(NORTE_AMERICANA) ? Moeda_US.instancia : Moeda_BR.instancia;
        return this.moeda;
    }

    public Calendar novoCalendar() {
        return Calendar.getInstance(this.equals(NORTE_AMERICANA) ? Locale.US : new Locale("pt", "BR"));
    }

    public Calendario novoCalendario() {
        return new Calendario(this);
    }

    public NumeroTransformacao novoNumeroTransformacao() {
        return this.novoNumeroTransformacao(true);
    }

    public NumeroTransformacao novoNumeroTransformacao(boolean preferenciaReal) {
        return new NumeroTransformacao(this, preferenciaReal);
    }

    public DataTransformacao novaDataTransformacao(int estilo) {
        if (this.equals(NORTE_AMERICANA)) {
            return new DataTransformacao_en_US(this, estilo);
        }
        return new DataTransformacao_pt_BR(this, estilo);
    }

    public DataTransformacao novaDataTransformacaoResumida() {
        return this.novaDataTransformacao(3);
    }

    public DataTransformacao novaDataTransformacaoExtensa() {
        return this.novaDataTransformacao(1);
    }

    public DataTransformacao novaDataTransformacaoCompleta() {
        return this.novaDataTransformacao(0);
    }

    public DataTransformacao novaDataTransformacaoNormal() {
        return this.novaDataTransformacao(2);
    }

    public DataTransformacao novaDataTransformacaoPadrao() {
        return this.novaDataTransformacao(2);
    }

    public DataTransformacao novaDataTransformacaoNumerica() {
        return this.novaDataTransformacao(4);
    }

    public NumeroTransformacao novaRealTransformacao() {
        return new NumeroTransformacao(this, true);
    }

    public NumeroTransformacao novaInteiroTransformacao() {
        NumeroTransformacao nt = new NumeroTransformacao(this, false);
        nt.setMaximoDigitosNaFracao(0);
        nt.setMinimoDigitosNaFracao(0);
        return nt;
    }

    public NumeroTransformacao novaMoedaTransformacao() {
        NumeroTransformacao nt = new NumeroTransformacao(this, true);
        nt.setMaximoDigitosNaFracao(2);
        nt.setMinimoDigitosNaFracao(2);
        return nt;
    }

    public DataTransformacao novaDataTransformacao() {
        return this.novaDataTransformacao(4);
    }
}

