/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.PoolUtil;
import com.jolbox.bonecp.UsernamePassword;
import java.io.Closeable;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoneCPDataSource
extends BoneCPConfig
implements DataSource,
ObjectFactory,
Closeable {
    private static final long serialVersionUID = -1561804548443209469L;
    private transient PrintWriter logWriter = null;
    private transient FinalWrapper<BoneCP> pool = null;
    private String driverClass;
    private static final Logger logger = LoggerFactory.getLogger(BoneCPDataSource.class);
    private LoadingCache<UsernamePassword, BoneCPDataSource> multiDataSource = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<UsernamePassword, BoneCPDataSource>(){

        public BoneCPDataSource load(UsernamePassword key) throws Exception {
            BoneCPDataSource ds = null;
            ds = new BoneCPDataSource(BoneCPDataSource.this.getConfig());
            ds.setUsername(key.getUsername());
            ds.setPassword(key.getPassword());
            return ds;
        }
    });

    public BoneCPDataSource() {
    }

    public BoneCPDataSource(BoneCPConfig config) {
        Field[] fields;
        for (Field field : fields = BoneCPConfig.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                field.set(this, field.get(config));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        FinalWrapper<BoneCP> wrapper = this.pool;
        if (wrapper == null) {
            BoneCPDataSource boneCPDataSource = this;
            synchronized (boneCPDataSource) {
                if (this.pool == null) {
                    try {
                        if (this.getDriverClass() != null) {
                            this.loadClass(this.getDriverClass());
                        }
                        logger.debug(this.toString());
                        this.pool = new FinalWrapper<BoneCP>(new BoneCP(this));
                    }
                    catch (ClassNotFoundException e) {
                        throw new SQLException(PoolUtil.stringifyException(e));
                    }
                }
                wrapper = this.pool;
            }
        }
        return ((BoneCP)wrapper.value).getConnection();
    }

    @Override
    public void close() {
        if (this.getPool() != null) {
            this.getPool().shutdown();
            logger.debug("Connection pool has been shut down");
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            return ((BoneCPDataSource)this.multiDataSource.get((Object)new UsernamePassword(username, password))).getConnection();
        }
        catch (ExecutionException e) {
            throw PoolUtil.generateSQLException("Unable to obtain connection", e);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("getLoginTimeout is unsupported.");
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException("getParentLogger is unsupported");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException("setLoginTimeout is unsupported.");
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    public Object unwrap(Class arg0) throws SQLException {
        return null;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public int getTotalLeased() {
        return this.getPool().getTotalLeased();
    }

    public BoneCPConfig getConfig() {
        return this;
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> table) throws Exception {
        Reference ref = (Reference)object;
        Enumeration<RefAddr> addrs = ref.getAll();
        Properties props = new Properties();
        while (addrs.hasMoreElements()) {
            RefAddr addr = addrs.nextElement();
            if (addr.getType().equals("driverClassName")) {
                Class.forName((String)addr.getContent());
                continue;
            }
            props.put(addr.getType(), addr.getContent());
        }
        BoneCPConfig config = new BoneCPConfig(props);
        return new BoneCPDataSource(config);
    }

    public BoneCP getPool() {
        return (BoneCP)this.pool.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FinalWrapper<T> {
        public final T value;

        public FinalWrapper(T value) {
            this.value = value;
        }
    }
}

