/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp.spring;

import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.BoneCPDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;

public class DynamicDataSourceProxy
extends DelegatingDataSource {
    private static final Log logger = LogFactory.getLog(LazyConnectionDataSourceProxy.class);

    public DynamicDataSourceProxy(DataSource targetDataSource) {
        this.setTargetDataSource(targetDataSource);
        this.afterPropertiesSet();
    }

    public DynamicDataSourceProxy() {
    }

    public void switchDataSource(BoneCPConfig newConfig) throws SQLException {
        logger.info((Object)("Switch to new datasource requested. New Config: " + newConfig));
        DataSource oldDS = this.getTargetDataSource();
        if (!(oldDS instanceof BoneCPDataSource)) {
            throw new SQLException("Unknown datasource type! Was expecting BoneCPDataSource but received " + oldDS.getClass() + ". Not switching datasource!");
        }
        BoneCPDataSource newDS = new BoneCPDataSource(newConfig);
        newDS.getConnection().close();
        this.setTargetDataSource(newDS);
        logger.info((Object)("Shutting down old datasource slowly. Old Config: " + oldDS));
        ((BoneCPDataSource)oldDS).close();
    }
}

