/*
 * Decompiled with CFR 0.152.
 */
package com.joanzapata.iconify.internal;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.style.ReplacementSpan;
import android.view.animation.LinearInterpolator;
import com.joanzapata.iconify.Icon;

public class CustomTypefaceSpan
extends ReplacementSpan {
    private static final int ROTATION_DURATION = 2000;
    private static final Rect TEXT_BOUNDS = new Rect();
    private static final Paint LOCAL_PAINT = new Paint();
    private final String icon;
    private final Typeface type;
    private final float iconSizePx;
    private final float iconSizeRatio;
    private final int iconColor;
    private final boolean rotate;
    private final ValueAnimator valueAnimator;

    public CustomTypefaceSpan(Icon icon, Typeface type, float iconSizePx, float iconSizeRatio, int iconColor, boolean rotate) {
        this.rotate = rotate;
        this.icon = String.valueOf(icon.character());
        this.type = type;
        this.iconSizePx = iconSizePx;
        this.iconSizeRatio = iconSizeRatio;
        this.iconColor = iconColor;
        if (rotate) {
            this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
            this.valueAnimator.setDuration(2000L);
            this.valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.valueAnimator.setRepeatCount(-1);
            this.valueAnimator.setRepeatMode(1);
            this.valueAnimator.start();
        } else {
            this.valueAnimator = null;
        }
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        LOCAL_PAINT.set(paint);
        this.applyCustomTypeFace(LOCAL_PAINT, this.type);
        LOCAL_PAINT.getTextBounds(this.icon, 0, 1, TEXT_BOUNDS);
        if (fm != null) {
            fm.ascent = CustomTypefaceSpan.TEXT_BOUNDS.top;
            fm.descent = CustomTypefaceSpan.TEXT_BOUNDS.bottom;
            fm.top = fm.ascent;
            fm.bottom = fm.descent;
        }
        return TEXT_BOUNDS.width();
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        this.applyCustomTypeFace(paint, this.type);
        paint.getTextBounds(this.icon, 0, 1, TEXT_BOUNDS);
        canvas.save();
        if (this.rotate) {
            Float rotation = (Float)this.valueAnimator.getAnimatedValue();
            float centerX = x + (float)TEXT_BOUNDS.centerX();
            float centerY = y + TEXT_BOUNDS.centerY();
            canvas.rotate(rotation.floatValue(), centerX, centerY);
        }
        canvas.drawText(this.icon, x, (float)y, paint);
        canvas.restore();
    }

    public boolean isAnimated() {
        return this.rotate;
    }

    private void applyCustomTypeFace(Paint paint, Typeface tf) {
        paint.setFakeBoldText(false);
        paint.setTextSkewX(0.0f);
        paint.setTypeface(tf);
        if (this.rotate) {
            paint.clearShadowLayer();
        }
        if (this.iconSizeRatio > 0.0f) {
            paint.setTextSize(paint.getTextSize() * this.iconSizeRatio);
        } else if (this.iconSizePx > 0.0f) {
            paint.setTextSize(this.iconSizePx);
        }
        if (this.iconColor < Integer.MAX_VALUE) {
            paint.setColor(this.iconColor);
        }
    }
}

