/*
 * Decompiled with CFR 0.152.
 */
package com.joanzapata.iconify.internal;

import android.content.Context;
import android.text.SpannableString;
import android.util.SparseArray;
import com.joanzapata.iconify.Icon;
import com.joanzapata.iconify.internal.IconFontDescriptorWrapper;
import java.util.List;

public final class ParsingUtil {
    private ParsingUtil() {
    }

    public static SpannableString parse(Context context, List<IconFontDescriptorWrapper> iconFontDescriptors, CharSequence text) {
        context = context.getApplicationContext();
        SparseArray accumulator = new SparseArray();
        String result = ParsingUtil.recursivePrepareSpannableIndexes(new StringBuilder(text), iconFontDescriptors, (SparseArray<IconFontDescriptorWrapper>)accumulator, 0);
        SpannableString spannableString = SpannableString.valueOf((CharSequence)result);
        int size = accumulator.size();
        for (int i = 0; i < size; ++i) {
            int index = accumulator.keyAt(i);
            IconFontDescriptorWrapper descriptor = (IconFontDescriptorWrapper)accumulator.valueAt(i);
            spannableString.setSpan((Object)descriptor.getCustomTypefaceSpan(context), index, index + 1, 17);
        }
        return spannableString;
    }

    private static String recursivePrepareSpannableIndexes(StringBuilder text, List<IconFontDescriptorWrapper> iconFontDescriptors, SparseArray<IconFontDescriptorWrapper> accumulator, int start) {
        int startIndex = text.indexOf("{", start);
        if (startIndex == -1) {
            return text.toString();
        }
        int endIndex = text.indexOf("}", startIndex) + 1;
        String key = text.substring(startIndex + 1, endIndex - 1);
        IconFontDescriptorWrapper iconFontDescriptor = null;
        Icon icon = null;
        for (int i = 0; i < iconFontDescriptors.size() && (icon = (iconFontDescriptor = iconFontDescriptors.get(i)).getIcon(key)) == null; ++i) {
        }
        if (icon == null) {
            return ParsingUtil.recursivePrepareSpannableIndexes(text, iconFontDescriptors, accumulator, endIndex);
        }
        text = text.replace(startIndex, endIndex, "" + icon.character());
        accumulator.put(startIndex, (Object)iconFontDescriptor);
        return ParsingUtil.recursivePrepareSpannableIndexes(text, iconFontDescriptors, accumulator, startIndex);
    }
}

