/*
 * Decompiled with CFR 0.152.
 */
package com.jmedeisis.draglinearlayout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.MotionEventCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import com.jmedeisis.draglinearlayout.R;

public class DragLinearLayout
extends LinearLayout {
    private static final String LOG_TAG = DragLinearLayout.class.getSimpleName();
    private static final long NOMINAL_SWITCH_DURATION = 150L;
    private static final long MIN_SWITCH_DURATION = 150L;
    private static final long MAX_SWITCH_DURATION = 300L;
    private static final float NOMINAL_DISTANCE = 20.0f;
    private final float nominalDistanceScaled;
    private OnViewSwapListener swapListener;
    private final SparseArray<DraggableChild> draggableChildren;
    private final DragItem draggedItem;
    private final int slop;
    private static final int INVALID_POINTER_ID = -1;
    private int downY = -1;
    private int activePointerId = -1;
    private final Drawable dragTopShadowDrawable;
    private final Drawable dragBottomShadowDrawable;
    private final int dragShadowHeight;
    private ScrollView containerScrollView;
    private int scrollSensitiveAreaHeight;
    private static final int DEFAULT_SCROLL_SENSITIVE_AREA_HEIGHT_DP = 48;
    private static final int MAX_DRAG_SCROLL_SPEED = 16;
    private Runnable dragUpdater;

    public DragLinearLayout(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DragLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        this.draggableChildren = new SparseArray();
        this.draggedItem = new DragItem();
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.slop = vc.getScaledTouchSlop();
        Resources resources = this.getResources();
        this.dragTopShadowDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ab_solid_shadow_holo_flipped);
        this.dragBottomShadowDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ab_solid_shadow_holo);
        this.dragShadowHeight = resources.getDimensionPixelSize(R.dimen.downwards_drop_shadow_height);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DragLinearLayout, 0, 0);
        try {
            this.scrollSensitiveAreaHeight = a.getDimensionPixelSize(R.styleable.DragLinearLayout_scrollSensitiveHeight, (int)(48.0f * resources.getDisplayMetrics().density + 0.5f));
        }
        finally {
            a.recycle();
        }
        this.nominalDistanceScaled = (int)(20.0f * resources.getDisplayMetrics().density + 0.5f);
    }

    public void setOrientation(int orientation) {
        if (0 == orientation) {
            throw new IllegalArgumentException("DragLinearLayout must be VERTICAL.");
        }
        super.setOrientation(orientation);
    }

    public void addDragView(View child, View dragHandle) {
        this.addView(child);
        this.setViewDraggable(child, dragHandle);
    }

    public void addDragView(View child, View dragHandle, int index) {
        this.addView(child, index);
        int numMappings = this.draggableChildren.size();
        for (int i = numMappings - 1; i >= 0; --i) {
            int key = this.draggableChildren.keyAt(i);
            if (key < index) continue;
            this.draggableChildren.put(key + 1, this.draggableChildren.get(key));
        }
        this.setViewDraggable(child, dragHandle);
    }

    public void setViewDraggable(View child, View dragHandle) {
        if (this == child.getParent()) {
            dragHandle.setOnTouchListener((View.OnTouchListener)new DragHandleOnTouchListener(child));
            this.draggableChildren.put(this.indexOfChild(child), (Object)new DraggableChild());
        } else {
            Log.e((String)LOG_TAG, (String)(child + " is not a child, cannot make draggable."));
        }
    }

    public void removeDragView(View child) {
        if (this == child.getParent()) {
            int index = this.indexOfChild(child);
            this.removeView(child);
            int mappings = this.draggableChildren.size();
            for (int i = 0; i < mappings; ++i) {
                int key = this.draggableChildren.keyAt(i);
                if (key < index) continue;
                DraggableChild next = (DraggableChild)this.draggableChildren.get(key + 1);
                if (null == next) {
                    this.draggableChildren.delete(key);
                    continue;
                }
                this.draggableChildren.put(key, (Object)next);
            }
        }
    }

    public void setContainerScrollView(ScrollView scrollView) {
        this.containerScrollView = scrollView;
    }

    public void setScrollSensitiveHeight(int height) {
        this.scrollSensitiveAreaHeight = height;
    }

    public int getScrollSensitiveHeight() {
        return this.scrollSensitiveAreaHeight;
    }

    public void setOnViewSwapListener(OnViewSwapListener swapListener) {
        this.swapListener = swapListener;
    }

    private long getTranslateAnimationDuration(float distance) {
        return Math.min(300L, Math.max(150L, (long)(150.0f * Math.abs(distance) / this.nominalDistanceScaled)));
    }

    private void startDetectingDrag(View child) {
        if (this.draggedItem.detecting) {
            return;
        }
        int position = this.indexOfChild(child);
        ((DraggableChild)this.draggableChildren.get(position)).endExistingAnimation();
        this.draggedItem.startDetectingOnPossibleDrag(child, position);
    }

    private void startDrag() {
        this.draggedItem.onDragStart();
        this.requestDisallowInterceptTouchEvent(true);
    }

    private void onDragStop() {
        this.draggedItem.settleAnimation = ValueAnimator.ofFloat((float[])new float[]{this.draggedItem.totalDragOffset, this.draggedItem.totalDragOffset - this.draggedItem.targetTopOffset}).setDuration(this.getTranslateAnimationDuration(this.draggedItem.targetTopOffset));
        this.draggedItem.settleAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (!DragLinearLayout.this.draggedItem.detecting) {
                    return;
                }
                DragLinearLayout.this.draggedItem.setTotalOffset(((Float)animation.getAnimatedValue()).intValue());
                int shadowAlpha = (int)((1.0f - animation.getAnimatedFraction()) * 255.0f);
                if (null != DragLinearLayout.this.dragTopShadowDrawable) {
                    DragLinearLayout.this.dragTopShadowDrawable.setAlpha(shadowAlpha);
                }
                DragLinearLayout.this.dragBottomShadowDrawable.setAlpha(shadowAlpha);
                DragLinearLayout.this.invalidate();
            }
        });
        this.draggedItem.settleAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                DragLinearLayout.this.draggedItem.onDragStop();
            }

            public void onAnimationEnd(Animator animation) {
                if (!DragLinearLayout.this.draggedItem.detecting) {
                    return;
                }
                DragLinearLayout.this.draggedItem.settleAnimation = null;
                DragLinearLayout.this.draggedItem.stopDetecting();
                if (null != DragLinearLayout.this.dragTopShadowDrawable) {
                    DragLinearLayout.this.dragTopShadowDrawable.setAlpha(255);
                }
                DragLinearLayout.this.dragBottomShadowDrawable.setAlpha(255);
            }
        });
        this.draggedItem.settleAnimation.start();
    }

    private void onDrag(int offset) {
        boolean isAbove;
        this.draggedItem.setTotalOffset(offset);
        this.invalidate();
        int currentTop = this.draggedItem.startTop + this.draggedItem.totalDragOffset;
        this.handleContainerScroll(currentTop);
        int belowPosition = this.nextDraggablePosition(this.draggedItem.position);
        int abovePosition = this.previousDraggablePosition(this.draggedItem.position);
        View belowView = this.getChildAt(belowPosition);
        View aboveView = this.getChildAt(abovePosition);
        boolean isBelow = belowView != null && currentTop + this.draggedItem.height > belowView.getTop() + belowView.getHeight() / 2;
        boolean bl = isAbove = aboveView != null && currentTop < aboveView.getTop() + aboveView.getHeight() / 2;
        if (isBelow || isAbove) {
            final View switchView = isBelow ? belowView : aboveView;
            final int originalPosition = this.draggedItem.position;
            int switchPosition = isBelow ? belowPosition : abovePosition;
            ((DraggableChild)this.draggableChildren.get(switchPosition)).cancelExistingAnimation();
            final float switchViewStartY = switchView.getY();
            if (null != this.swapListener) {
                this.swapListener.onSwap(this.draggedItem.view, this.draggedItem.position, switchView, switchPosition);
            }
            if (isBelow) {
                this.removeViewAt(originalPosition);
                this.removeViewAt(switchPosition - 1);
                this.addView(belowView, originalPosition);
                this.addView(this.draggedItem.view, switchPosition);
            } else {
                this.removeViewAt(switchPosition);
                this.removeViewAt(originalPosition - 1);
                this.addView(this.draggedItem.view, switchPosition);
                this.addView(aboveView, originalPosition);
            }
            this.draggedItem.position = switchPosition;
            final ViewTreeObserver switchViewObserver = switchView.getViewTreeObserver();
            switchViewObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    switchViewObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    final ObjectAnimator switchAnimator = ObjectAnimator.ofFloat((Object)switchView, (String)"y", (float[])new float[]{switchViewStartY, switchView.getTop()}).setDuration(DragLinearLayout.this.getTranslateAnimationDuration((float)switchView.getTop() - switchViewStartY));
                    switchAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationStart(Animator animation) {
                            ((DraggableChild)DragLinearLayout.this.draggableChildren.get(originalPosition)).swapAnimation = (ValueAnimator)switchAnimator;
                        }

                        public void onAnimationEnd(Animator animation) {
                            ((DraggableChild)DragLinearLayout.this.draggableChildren.get(originalPosition)).swapAnimation = null;
                        }
                    });
                    switchAnimator.start();
                    return true;
                }
            });
            final ViewTreeObserver observer = this.draggedItem.view.getViewTreeObserver();
            observer.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    observer.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    DragLinearLayout.this.draggedItem.updateTargetTop();
                    if (DragLinearLayout.this.draggedItem.settling()) {
                        Log.d((String)LOG_TAG, (String)"Updating settle animation");
                        DragLinearLayout.this.draggedItem.settleAnimation.removeAllListeners();
                        DragLinearLayout.this.draggedItem.settleAnimation.cancel();
                        DragLinearLayout.this.onDragStop();
                    }
                    return true;
                }
            });
        }
    }

    private int previousDraggablePosition(int position) {
        int startIndex = this.draggableChildren.indexOfKey(position);
        if (startIndex < 1 || startIndex > this.draggableChildren.size()) {
            return -1;
        }
        return this.draggableChildren.keyAt(startIndex - 1);
    }

    private int nextDraggablePosition(int position) {
        int startIndex = this.draggableChildren.indexOfKey(position);
        if (startIndex < -1 || startIndex > this.draggableChildren.size() - 2) {
            return -1;
        }
        return this.draggableChildren.keyAt(startIndex + 1);
    }

    private void handleContainerScroll(int currentTop) {
        if (null != this.containerScrollView) {
            final int startScrollY = this.containerScrollView.getScrollY();
            int absTop = this.getTop() - startScrollY + currentTop;
            int height = this.containerScrollView.getHeight();
            final int delta = absTop < this.scrollSensitiveAreaHeight ? (int)(-16.0f * DragLinearLayout.smootherStep(this.scrollSensitiveAreaHeight, 0.0f, absTop)) : (absTop > height - this.scrollSensitiveAreaHeight ? (int)(16.0f * DragLinearLayout.smootherStep(height - this.scrollSensitiveAreaHeight, height, absTop)) : 0);
            this.containerScrollView.removeCallbacks(this.dragUpdater);
            this.containerScrollView.smoothScrollBy(0, delta);
            this.dragUpdater = new Runnable(){

                @Override
                public void run() {
                    if (DragLinearLayout.this.draggedItem.dragging && startScrollY != DragLinearLayout.this.containerScrollView.getScrollY()) {
                        DragLinearLayout.this.onDrag(DragLinearLayout.this.draggedItem.totalDragOffset + delta);
                    }
                }
            };
            this.containerScrollView.post(this.dragUpdater);
        }
    }

    private static float smootherStep(float edge1, float edge2, float val) {
        val = Math.max(0.0f, Math.min((val - edge1) / (edge2 - edge1), 1.0f));
        return val * val * val * (val * (val * 6.0f - 15.0f) + 10.0f);
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.draggedItem.detecting && (this.draggedItem.dragging || this.draggedItem.settling())) {
            canvas.save();
            canvas.translate(0.0f, (float)this.draggedItem.totalDragOffset);
            this.draggedItem.viewDrawable.draw(canvas);
            int left = ((DragItem)this.draggedItem).viewDrawable.getBounds().left;
            int right = ((DragItem)this.draggedItem).viewDrawable.getBounds().right;
            int top = ((DragItem)this.draggedItem).viewDrawable.getBounds().top;
            int bottom = ((DragItem)this.draggedItem).viewDrawable.getBounds().bottom;
            this.dragBottomShadowDrawable.setBounds(left, bottom, right, bottom + this.dragShadowHeight);
            this.dragBottomShadowDrawable.draw(canvas);
            if (null != this.dragTopShadowDrawable) {
                this.dragTopShadowDrawable.setBounds(left, top - this.dragShadowHeight, right, top);
                this.dragTopShadowDrawable.draw(canvas);
            }
            canvas.restore();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        switch (MotionEventCompat.getActionMasked((MotionEvent)event)) {
            case 0: {
                if (this.draggedItem.detecting) {
                    return false;
                }
                this.downY = (int)MotionEventCompat.getY((MotionEvent)event, (int)0);
                this.activePointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)0);
                break;
            }
            case 2: {
                if (!this.draggedItem.detecting) {
                    return false;
                }
                if (-1 == this.activePointerId) break;
                int pointerIndex = event.findPointerIndex(this.activePointerId);
                float y = MotionEventCompat.getY((MotionEvent)event, (int)pointerIndex);
                float dy = y - (float)this.downY;
                if (Math.abs(dy) > (float)this.slop) {
                    this.startDrag();
                    return true;
                }
                return false;
            }
            case 6: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)event);
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)pointerIndex);
                if (pointerId != this.activePointerId) break;
            }
            case 1: 
            case 3: {
                this.onTouchEnd();
                if (!this.draggedItem.detecting) break;
                this.draggedItem.stopDetecting();
            }
        }
        return false;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        switch (MotionEventCompat.getActionMasked((MotionEvent)event)) {
            case 0: {
                if (!this.draggedItem.detecting || this.draggedItem.settling()) {
                    return false;
                }
                this.startDrag();
                return true;
            }
            case 2: {
                if (!this.draggedItem.dragging || -1 == this.activePointerId) break;
                int pointerIndex = event.findPointerIndex(this.activePointerId);
                int lastEventY = (int)MotionEventCompat.getY((MotionEvent)event, (int)pointerIndex);
                int deltaY = lastEventY - this.downY;
                this.onDrag(deltaY);
                return true;
            }
            case 6: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)event);
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)pointerIndex);
                if (pointerId != this.activePointerId) break;
            }
            case 1: 
            case 3: {
                this.onTouchEnd();
                if (this.draggedItem.dragging) {
                    this.onDragStop();
                } else if (this.draggedItem.detecting) {
                    this.draggedItem.stopDetecting();
                }
                return true;
            }
        }
        return false;
    }

    private void onTouchEnd() {
        this.downY = -1;
        this.activePointerId = -1;
    }

    private BitmapDrawable getDragDrawable(View view) {
        int top = view.getTop();
        int left = view.getLeft();
        Bitmap bitmap = DragLinearLayout.getBitmapFromView(view);
        BitmapDrawable drawable2 = new BitmapDrawable(this.getResources(), bitmap);
        drawable2.setBounds(new Rect(left, top, left + view.getWidth(), top + view.getHeight()));
        return drawable2;
    }

    private static Bitmap getBitmapFromView(View view) {
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        view.draw(canvas);
        return bitmap;
    }

    private class DragHandleOnTouchListener
    implements View.OnTouchListener {
        private final View view;

        public DragHandleOnTouchListener(View view) {
            this.view = view;
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (0 == MotionEventCompat.getActionMasked((MotionEvent)event)) {
                DragLinearLayout.this.startDetectingDrag(this.view);
            }
            return false;
        }
    }

    private class DragItem {
        private View view;
        private int startVisibility;
        private BitmapDrawable viewDrawable;
        private int position;
        private int startTop;
        private int height;
        private int totalDragOffset;
        private int targetTopOffset;
        private ValueAnimator settleAnimation;
        private boolean detecting;
        private boolean dragging;

        public DragItem() {
            this.stopDetecting();
        }

        public void startDetectingOnPossibleDrag(View view, int position) {
            this.view = view;
            this.startVisibility = view.getVisibility();
            this.viewDrawable = DragLinearLayout.this.getDragDrawable(view);
            this.position = position;
            this.startTop = view.getTop();
            this.height = view.getHeight();
            this.totalDragOffset = 0;
            this.targetTopOffset = 0;
            this.settleAnimation = null;
            this.detecting = true;
        }

        public void onDragStart() {
            this.view.setVisibility(4);
            this.dragging = true;
        }

        public void setTotalOffset(int offset) {
            this.totalDragOffset = offset;
            this.updateTargetTop();
        }

        public void updateTargetTop() {
            this.targetTopOffset = this.startTop - this.view.getTop() + this.totalDragOffset;
        }

        public void onDragStop() {
            this.dragging = false;
        }

        public boolean settling() {
            return null != this.settleAnimation;
        }

        public void stopDetecting() {
            this.detecting = false;
            if (null != this.view) {
                this.view.setVisibility(this.startVisibility);
            }
            this.view = null;
            this.startVisibility = -1;
            this.viewDrawable = null;
            this.position = -1;
            this.startTop = -1;
            this.height = -1;
            this.totalDragOffset = 0;
            this.targetTopOffset = 0;
            if (null != this.settleAnimation) {
                this.settleAnimation.end();
            }
            this.settleAnimation = null;
        }
    }

    private class DraggableChild {
        private ValueAnimator swapAnimation;

        private DraggableChild() {
        }

        public void endExistingAnimation() {
            if (null != this.swapAnimation) {
                this.swapAnimation.end();
            }
        }

        public void cancelExistingAnimation() {
            if (null != this.swapAnimation) {
                this.swapAnimation.cancel();
            }
        }
    }

    public static interface OnViewSwapListener {
        public void onSwap(View var1, int var2, View var3, int var4);
    }
}

