/*
 * Decompiled with CFR 0.152.
 */
package com.jlubecki.soundcloud.webapi.android.auth.browser;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import com.jlubecki.soundcloud.webapi.android.auth.AuthenticationCallback;
import com.jlubecki.soundcloud.webapi.android.auth.SoundCloudAuthenticator;
import java.util.List;

public class BrowserSoundCloudAuthenticator
extends SoundCloudAuthenticator {
    private final Activity context;
    private final String browserPackageName;
    private final Intent launchIntent;

    public BrowserSoundCloudAuthenticator(String clientId, String redirectUri, Activity context) {
        super(clientId, redirectUri);
        this.context = context;
        this.browserPackageName = this.getBrowserPackageName();
        this.launchIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.loginUrl()));
    }

    @Override
    public boolean prepareAuthenticationFlow(AuthenticationCallback callback) {
        boolean canAuthenticate;
        boolean bl = canAuthenticate = this.context.getPackageManager().queryIntentActivities(this.launchIntent, 0).size() > 0;
        if (canAuthenticate) {
            callback.onReadyToAuthenticate(this);
        }
        return canAuthenticate;
    }

    @Override
    public void launchAuthenticationFlow() {
        if (this.browserPackageName != null) {
            this.launchIntent.setPackage(this.browserPackageName);
        }
        this.addReferrerToIntent(this.launchIntent, this.context.getPackageName());
        this.context.startActivity(this.launchIntent);
    }

    private String getBrowserPackageName() {
        Intent webIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://"));
        List resolveInfoList = this.context.getPackageManager().queryIntentActivities(webIntent, 65536);
        if (resolveInfoList != null && resolveInfoList.size() > 0) {
            for (ResolveInfo info : resolveInfoList) {
                if (info.activityInfo == null || info.activityInfo.packageName == null) continue;
                return info.activityInfo.packageName;
            }
        }
        return null;
    }
}

