/*
 * Decompiled with CFR 0.152.
 */
package com.jlubecki.soundcloud.webapi.android.query;

import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.jlubecki.soundcloud.webapi.android.models.Track;
import com.jlubecki.soundcloud.webapi.android.query.Query;
import java.util.HashMap;

public class TrackQuery
extends Query {
    private String query;
    private String tags;
    private Track.Filter filter;
    private Track.License license;
    private int bpmFrom = -1;
    private int bpmTo = -1;
    private int durationFrom = -1;
    private int durationTo = -1;
    private String createdAtFrom;
    private String createdAtTo;
    private String ids;
    private String genres;
    private String types;

    private TrackQuery(Builder builder) {
        this.query = builder.query;
        this.tags = builder.tags;
        this.filter = builder.filter;
        this.license = builder.license;
        this.bpmFrom = builder.bpmFrom;
        this.bpmTo = builder.bpmTo;
        this.durationFrom = builder.durationFrom;
        this.durationTo = builder.durationTo;
        this.createdAtFrom = builder.createdAtFrom;
        this.createdAtTo = builder.createdAtTo;
        this.ids = builder.ids;
        this.genres = builder.genres;
        this.types = builder.types;
    }

    @Override
    public HashMap<String, String> createMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.query != null) {
            queryMap.put("q", this.query);
        }
        if (this.tags != null) {
            queryMap.put("tags", this.tags);
        }
        if (this.filter != null) {
            queryMap.put("filter", this.filter.toString());
        }
        if (this.license != null) {
            queryMap.put("license", this.license.toString());
        }
        if (this.bpmFrom != -1) {
            queryMap.put("bpm[from]", String.valueOf(this.bpmFrom));
        }
        if (this.bpmTo != -1) {
            queryMap.put("bpm[to]", String.valueOf(this.bpmTo));
        }
        if (this.durationFrom != -1) {
            queryMap.put("duration[from]", String.valueOf(this.durationFrom));
        }
        if (this.durationTo != -1) {
            queryMap.put("duration[to]", String.valueOf(this.durationTo));
        }
        if (this.createdAtFrom != null) {
            queryMap.put("created_at[from]", this.createdAtFrom);
        }
        if (this.createdAtTo != null) {
            queryMap.put("created_at[to]", this.createdAtTo);
        }
        if (this.ids != null) {
            queryMap.put("ids", this.ids);
        }
        if (this.createdAtTo != null) {
            queryMap.put("genres", this.genres);
        }
        if (this.createdAtTo != null) {
            queryMap.put("types", this.types);
        }
        if (queryMap.size() > 0) {
            queryMap.put("limit", String.valueOf(this.limit));
            return queryMap;
        }
        return null;
    }

    public static class Builder {
        private String query;
        private String tags;
        private Track.Filter filter;
        private Track.License license;
        private int bpmFrom = -1;
        private int bpmTo = -1;
        private int durationFrom = -1;
        private int durationTo = -1;
        private String createdAtFrom;
        private String createdAtTo;
        private String ids;
        private String genres;
        private String types;

        public Builder setQuery(String query) {
            this.query = query;
            return this;
        }

        public Builder setTags(String ... tagArray) {
            this.tags = TextUtils.join((CharSequence)", ", (Object[])tagArray);
            return this;
        }

        public Builder setFilter(Track.Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder setLicense(Track.License license) {
            this.license = license;
            return this;
        }

        public Builder setTypes(Track.Type ... types) {
            this.types = TextUtils.join((CharSequence)", ", (Object[])types);
            return this;
        }

        public Builder setBpmLimits(@IntRange(from=0L, to=500L) int from, @IntRange(from=0L, to=500L) int to) {
            this.bpmFrom = from;
            this.bpmTo = to;
            return this;
        }

        public Builder setDurationLimits(@IntRange(from=0L, to=3600L) int from, @IntRange(from=0L, to=3600L) int to) {
            this.durationFrom = from;
            this.durationTo = to;
            return this;
        }

        public Builder setCreationDateLimits(@Nullable String from, @Nullable String to) {
            this.createdAtFrom = from;
            this.createdAtTo = to;
            return this;
        }

        public Builder setIds(String ... ids) {
            this.ids = TextUtils.join((CharSequence)", ", (Object[])ids);
            return this;
        }

        public Builder setGenres(String ... genres) {
            this.genres = TextUtils.join((CharSequence)", ", (Object[])genres);
            return this;
        }

        public TrackQuery build() {
            return new TrackQuery(this);
        }
    }
}

