/*
 * Decompiled with CFR 0.152.
 */
package com.jlubecki.soundcloud.webapi.android.auth.chrometabs;

import android.app.Activity;
import android.content.Context;
import android.content.ServiceConnection;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.customtabs.CustomTabsCallback;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import com.jlubecki.soundcloud.webapi.android.auth.AuthenticationCallback;
import com.jlubecki.soundcloud.webapi.android.auth.SoundCloudAuthenticator;
import com.jlubecki.soundcloud.webapi.android.auth.chrometabs.AuthTabServiceConnection;

public class ChromeTabsSoundCloudAuthenticator
extends SoundCloudAuthenticator {
    private final Activity context;
    private final String browserPackageName;
    private AuthTabServiceConnection serviceConnection;
    private CustomTabsCallback tabsCallback;
    private CustomTabsIntent.Builder tabsIntentBuilder;

    public ChromeTabsSoundCloudAuthenticator(String clientId, String redirectUri, Activity context) {
        super(clientId, redirectUri);
        this.context = context;
        this.browserPackageName = CustomTabsClient.getPackageName((Context)context, null);
    }

    public ChromeTabsSoundCloudAuthenticator(String clientId, String redirectUri, Activity context, CustomTabsCallback callback) {
        super(clientId, redirectUri);
        this.context = context;
        this.browserPackageName = CustomTabsClient.getPackageName((Context)context, null);
        this.tabsCallback = callback;
    }

    @Override
    public boolean prepareAuthenticationFlow(final AuthenticationCallback callback) {
        this.serviceConnection = new AuthTabServiceConnection(new AuthenticationCallback(){

            @Override
            public void onReadyToAuthenticate(SoundCloudAuthenticator authenticator) {
                callback.onReadyToAuthenticate(ChromeTabsSoundCloudAuthenticator.this);
            }
        }, this.tabsCallback);
        this.serviceConnection.setClientAuthUrl(this.loginUrl());
        return this.browserPackageName != null && CustomTabsClient.bindCustomTabsService((Context)this.context, (String)this.browserPackageName, (CustomTabsServiceConnection)this.serviceConnection);
    }

    @Override
    public void launchAuthenticationFlow() {
        if (this.tabsIntentBuilder == null) {
            this.tabsIntentBuilder = this.newTabsIntentBuilder();
        }
        CustomTabsIntent tabsIntent = this.tabsIntentBuilder.build();
        this.addReferrerToIntent(tabsIntent.intent, this.context.getPackageName());
        tabsIntent.intent.setPackage(this.browserPackageName);
        tabsIntent.launchUrl(this.context, Uri.parse((String)this.loginUrl()));
    }

    @Override
    public void release() {
        if (this.serviceConnection != null) {
            this.context.unbindService((ServiceConnection)this.serviceConnection);
        }
    }

    public void setTabsIntentBuilder(@NonNull CustomTabsIntent.Builder newBuilder) {
        this.tabsIntentBuilder = newBuilder;
    }

    public CustomTabsIntent.Builder newTabsIntentBuilder() {
        CustomTabsSession tabsSession = null;
        if (this.serviceConnection != null) {
            tabsSession = this.serviceConnection.getSession();
        }
        return new CustomTabsIntent.Builder(tabsSession);
    }
}

