/*
 * Decompiled with CFR 0.152.
 */
package com.jlubecki.soundcloud.webapi.android.auth;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.support.annotation.NonNull;
import android.util.Log;
import com.jlubecki.soundcloud.webapi.android.auth.AuthenticationCallback;
import com.jlubecki.soundcloud.webapi.android.auth.SoundCloudAuthenticator;
import com.jlubecki.soundcloud.webapi.android.auth.models.AuthenticationResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AuthenticationStrategy {
    private static final String TAG = "AuthenticationStrategy";
    private final List<SoundCloudAuthenticator> authenticators;
    private final Context context;
    private OnNetworkFailureListener onNetworkFailureListener;
    private boolean shouldCheckNetwork = false;
    private SoundCloudAuthenticator authenticator;

    private AuthenticationStrategy(@NonNull Context context, @NonNull List<SoundCloudAuthenticator> authenticators) {
        this.context = context;
        this.authenticators = authenticators;
    }

    public boolean beginAuthentication(AuthenticationCallback callback) {
        if (this.shouldCheckNetwork && !this.networkIsConnected()) {
            return false;
        }
        for (SoundCloudAuthenticator authenticator : this.authenticators) {
            if (!authenticator.prepareAuthenticationFlow(callback)) continue;
            return true;
        }
        return false;
    }

    public boolean canAuthenticate(Intent intent) {
        return this.authenticator != null && this.authenticator.canAuthenticate(intent);
    }

    public void getToken(Intent intent, String clientSecret, final ResponseCallback callback) {
        HashMap<String, String> authMap = this.authenticator.handleResponse(intent, clientSecret);
        if (authMap != null) {
            this.authenticator.getAuthService().authorize(authMap).enqueue((Callback)new Callback<AuthenticationResponse>(){

                public void onResponse(Call<AuthenticationResponse> call, Response<AuthenticationResponse> response) {
                    AuthenticationResponse authResponse = (AuthenticationResponse)response.body();
                    if (authResponse != null) {
                        callback.onAuthenticationResponse(authResponse);
                    } else {
                        String errorReason = "The authentication response was null.";
                        AssertionError error = new AssertionError((Object)errorReason);
                        callback.onAuthenticationFailed((Throwable)((Object)error));
                    }
                }

                public void onFailure(Call<AuthenticationResponse> call, Throwable t) {
                    callback.onAuthenticationFailed(t);
                }
            });
        } else {
            String errorReason = "Authentication parameter map was null.";
            AssertionError error = new AssertionError((Object)errorReason);
            callback.onAuthenticationFailed((Throwable)((Object)error));
        }
    }

    private boolean networkIsConnected() {
        ConnectivityManager manager = (ConnectivityManager)this.context.getSystemService("connectivity");
        boolean isConnected = manager.getActiveNetworkInfo().isConnected();
        if (!isConnected) {
            String errorReason = "Authentication Failed: Network was not connected.";
            if (this.onNetworkFailureListener != null) {
                AssertionError error = new AssertionError((Object)errorReason);
                this.onNetworkFailureListener.onFailure((Throwable)((Object)error));
            } else {
                Log.e((String)TAG, (String)errorReason);
            }
        }
        return isConnected;
    }

    public static interface ResponseCallback {
        public void onAuthenticationResponse(AuthenticationResponse var1);

        public void onAuthenticationFailed(Throwable var1);
    }

    public static interface OnNetworkFailureListener {
        public void onFailure(Throwable var1);
    }

    public static class Builder {
        private final List<SoundCloudAuthenticator> authenticators;
        private final Context context;
        private OnNetworkFailureListener onNetworkFailureListener;
        private boolean shouldCheckNetwork = false;

        public Builder(@NonNull Context context) {
            this.context = context;
            this.authenticators = new ArrayList<SoundCloudAuthenticator>();
        }

        public Builder addAuthenticator(SoundCloudAuthenticator authenticator) {
            this.authenticators.add(authenticator);
            return this;
        }

        public Builder addAuthenticators(List<SoundCloudAuthenticator> authenticators) {
            this.authenticators.addAll(authenticators);
            return this;
        }

        public Builder setCheckNetwork(boolean shouldDoCheck) {
            this.shouldCheckNetwork = shouldDoCheck;
            return this;
        }

        public Builder onFailure(OnNetworkFailureListener listener) {
            this.onNetworkFailureListener = listener;
            return this;
        }

        public AuthenticationStrategy build() {
            AuthenticationStrategy strategy = new AuthenticationStrategy(this.context, this.authenticators);
            strategy.shouldCheckNetwork = this.shouldCheckNetwork;
            strategy.onNetworkFailureListener = this.onNetworkFailureListener;
            return strategy;
        }
    }
}

