/*
 * Decompiled with CFR 0.152.
 */
package com.jlubecki.soundcloud.webapi.android.query;

import android.support.annotation.IntRange;
import com.jlubecki.soundcloud.webapi.android.query.Query;
import java.util.HashMap;

public class Pager {
    public static final String LIMIT = "limit";
    public static final String OFFSET = "offset";
    public static final int LIMIT_DEFAULT = 50;
    public static final int LIMIT_MAX = 200;
    private HashMap<String, String> queryMap;
    private int limit = 50;
    private int offset = 0;

    public Pager(Query query) {
        this.queryMap = query.createMap();
        this.updateLimit(this.limit);
        this.updateOffset(this.offset);
    }

    public Pager(Query query, @IntRange(from=1L, to=200L) int pageSize) {
        this.queryMap = query.createMap();
        this.limit = pageSize;
        this.updateLimit(this.limit);
        this.updateOffset(this.offset);
    }

    public HashMap<String, String> previous() {
        this.updateOffset(this.offset - this.limit);
        return this.queryMap;
    }

    public HashMap<String, String> next() {
        this.updateOffset(this.offset + this.limit);
        return this.queryMap;
    }

    public void setPageSize(int pageSize) {
        this.updateLimit(pageSize);
    }

    public void setOffset(int offset) {
        this.updateOffset(offset);
        if (offset < 0) {
            this.returnToStart();
        }
    }

    public void reset() {
        this.updateOffset(0);
        this.updateLimit(50);
    }

    public void returnToStart() {
        this.updateOffset(0);
    }

    private void updateLimit(@IntRange(from=1L, to=200L) int limit) {
        this.limit = limit;
        this.queryMap.put(LIMIT, String.valueOf(limit));
    }

    private void updateOffset(int offset) {
        this.offset = offset;
        this.queryMap.put(OFFSET, String.valueOf(offset));
    }
}

