/*
 * Decompiled with CFR 0.152.
 */
package com.jlubecki.soundcloud.webapi.android.auth.chrometabs;

import android.content.ComponentName;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.customtabs.CustomTabsCallback;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import com.jlubecki.soundcloud.webapi.android.auth.AuthenticationCallback;
import java.lang.ref.WeakReference;

public class AuthTabServiceConnection
extends CustomTabsServiceConnection {
    private static final String AUTH_BASE_URL = "https://www.soundcloud.com/connect";
    private final WeakReference<AuthenticationCallback> authCallbackReference;
    private final WeakReference<CustomTabsCallback> navCallbackReference;
    private CustomTabsClient tabsClient;
    private CustomTabsSession tabsSession;

    public AuthTabServiceConnection(@NonNull AuthenticationCallback callback) {
        this.authCallbackReference = new WeakReference<AuthenticationCallback>(callback);
        this.navCallbackReference = new WeakReference<Object>(null);
    }

    public AuthTabServiceConnection(@NonNull AuthenticationCallback authenticationCallback, @Nullable CustomTabsCallback navigationCallback) {
        this.authCallbackReference = new WeakReference<AuthenticationCallback>(authenticationCallback);
        this.navCallbackReference = new WeakReference<CustomTabsCallback>(navigationCallback);
    }

    public void onCustomTabsServiceConnected(ComponentName componentName, CustomTabsClient customTabsClient) {
        AuthenticationCallback callback;
        this.tabsClient = customTabsClient;
        this.tabsClient.warmup(0L);
        this.tabsSession = this.tabsClient.newSession((CustomTabsCallback)this.navCallbackReference.get());
        if (this.tabsSession != null) {
            this.tabsSession.mayLaunchUrl(Uri.parse((String)AUTH_BASE_URL), null, null);
        }
        if ((callback = (AuthenticationCallback)this.authCallbackReference.get()) != null) {
            callback.onReadyToAuthenticate();
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        this.tabsClient = null;
        this.tabsSession = null;
        AuthenticationCallback callback = (AuthenticationCallback)this.authCallbackReference.get();
        if (callback != null) {
            callback.onAuthenticationEnded();
        }
    }

    public CustomTabsSession getSession() {
        return this.tabsSession;
    }
}

