/*
 * Decompiled with CFR 0.152.
 */
package com.jlubecki.soundcloud.webapi.android.auth.browser;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.support.customtabs.CustomTabsClient;
import com.jlubecki.soundcloud.webapi.android.auth.SoundCloudAuthenticator;

public class BrowserSoundCloudAuthenticator
extends SoundCloudAuthenticator {
    private final Activity context;

    public BrowserSoundCloudAuthenticator(String clientId, String redirectUri, Activity context) {
        super(clientId, redirectUri);
        this.context = context;
    }

    @Override
    public boolean prepareAuthenticationFlow() {
        return true;
    }

    @Override
    public void launchAuthenticationFlow() {
        Uri authUri = Uri.parse((String)this.loginUrl());
        Intent loginIntent = new Intent("android.intent.action.VIEW");
        loginIntent.setPackage(this.getBrowserPackageName());
        loginIntent.setData(authUri);
        this.context.startActivity(loginIntent);
    }

    private String getBrowserPackageName() {
        String packageName = CustomTabsClient.getPackageName((Context)this.context, null);
        if (packageName == null) {
            Intent webIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.example.com"));
            PackageManager manager = this.context.getPackageManager();
            ResolveInfo info = manager.resolveActivity(webIntent, 0);
            packageName = info != null ? info.activityInfo.packageName : "com.android.browser";
        }
        return packageName;
    }
}

