/*
 * Decompiled with CFR 0.152.
 */
package com.jlubecki.soundcloud.webapi.android.auth;

import android.content.Intent;
import android.net.Uri;
import com.jlubecki.soundcloud.webapi.android.auth.models.AuthenticationResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;

public abstract class SoundCloudAuthenticator {
    private AuthService service;
    private static final String RESPONSE_TYPE = "code";
    private static final String SCOPE = "non-expiring";
    private static final String DISPLAY = "popup";
    private static final String STATE = "asdf";
    private final String clientId;
    private final String redirectUri;

    public SoundCloudAuthenticator(String clientId, String redirectUri) {
        this.clientId = clientId;
        this.redirectUri = redirectUri;
    }

    public abstract boolean prepareAuthenticationFlow();

    public abstract void launchAuthenticationFlow();

    protected final String loginUrl() {
        return "https://www.soundcloud.com/connect?client_id=" + this.clientId + "&redirect_uri=" + this.redirectUri + "&response_type=" + RESPONSE_TYPE + "&scope=" + SCOPE + "&display=" + DISPLAY + "&state=" + STATE;
    }

    public static HashMap<String, String> handleResponse(Intent intent, String redirectUri, String clientId, String clientSecret) {
        String uri = intent.getDataString();
        String code = Uri.parse((String)uri).getQueryParameter(RESPONSE_TYPE);
        if (code != null) {
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            fieldMap.put("client_id", clientId);
            fieldMap.put("client_secret", clientSecret);
            fieldMap.put(RESPONSE_TYPE, code);
            fieldMap.put("grant_type", "authorization_code");
            fieldMap.put("redirect_uri", redirectUri);
            return fieldMap;
        }
        return null;
    }

    public final AuthService getAuthService() {
        if (this.service == null) {
            OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthInterceptor()).build();
            Retrofit adapter = new Retrofit.Builder().client(client).baseUrl("https://api.soundcloud.com/").addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
            this.service = (AuthService)adapter.create(AuthService.class);
        }
        return this.service;
    }

    private class AuthInterceptor
    implements Interceptor {
        private AuthInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            HttpUrl url = request.url().newBuilder().addEncodedQueryParameter("client_id", SoundCloudAuthenticator.this.clientId).build();
            Request newRequest = request.newBuilder().url(url).build();
            return chain.proceed(newRequest);
        }
    }

    public static interface AuthService {
        @FormUrlEncoded
        @POST(value="oauth2/token")
        public Call<AuthenticationResponse> authorize(@FieldMap Map<String, String> var1);
    }

    public class GrantType {
        public static final String AUTH_CODE = "authorization_code";
        public static final String REFRESH_TOKEN = "refresh_token";
        public static final String PASSWORD = "password";
        public static final String CLIENT_CREDENTIALS = "client_credentials";
        public static final String OAUTH1_TOKEN = "oauth1_token";
    }
}

