/*
 * Decompiled with CFR 0.152.
 */
package com.jlubecki.soundcloud.webapi.android.query;

import com.jlubecki.soundcloud.webapi.android.query.Query;
import java.util.HashMap;

public class Pager {
    public static String LIMIT = "limit";
    public static String OFFSET = "offset";
    public static int LIMIT_DEFAULT = 50;
    public static int LIMIT_MAX = 200;
    private HashMap<String, String> queryMap;
    private int limit = LIMIT_DEFAULT;
    private int offset = 0;

    public Pager(Query query) {
        this.queryMap = query.createMap();
        this.updateLimit(this.limit);
        this.updateOffset(this.offset);
    }

    public Pager(Query query, int pageSize) {
        this.queryMap = query.createMap();
        this.limit = pageSize;
        this.updateLimit(this.limit);
        this.updateOffset(this.offset);
    }

    public HashMap<String, String> previous() {
        this.updateOffset(this.offset - this.limit);
        return this.queryMap;
    }

    public HashMap<String, String> next() {
        this.updateOffset(this.offset + this.limit);
        return this.queryMap;
    }

    public void setPageSize(int pageSize) {
        this.updateLimit(pageSize);
    }

    public void setOffset(int offset) {
        this.updateOffset(offset);
        if (offset < 0) {
            this.returnToStart();
        }
    }

    public void reset() {
        this.updateOffset(0);
        this.updateLimit(LIMIT_DEFAULT);
    }

    public void returnToStart() {
        this.updateOffset(0);
    }

    private void updateLimit(int limit) {
        this.limit = limit;
        this.queryMap.put(LIMIT, String.valueOf(limit));
    }

    private void updateOffset(int offset) {
        this.offset = offset;
        this.queryMap.put(OFFSET, String.valueOf(offset));
    }
}

