/*
 * Decompiled with CFR 0.152.
 */
package com.jlubecki.soundcloud.webapi.android.auth.chrometabs;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Build;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import com.jlubecki.soundcloud.webapi.android.auth.AuthenticationCallback;
import com.jlubecki.soundcloud.webapi.android.auth.SoundCloudAuthenticator;
import com.jlubecki.soundcloud.webapi.android.auth.chrometabs.AuthTabServiceConnection;

public class ChromeTabsSoundCloudAuthenticator
extends SoundCloudAuthenticator {
    private final Activity context;
    private final String browserPackageName;
    private final AuthTabServiceConnection serviceConnection;

    public ChromeTabsSoundCloudAuthenticator(String clientId, String redirectUri, Activity context, AuthTabServiceConnection serviceConnection) {
        super(clientId, redirectUri);
        this.context = context;
        this.serviceConnection = serviceConnection;
        this.browserPackageName = CustomTabsClient.getPackageName((Context)context, null);
    }

    public ChromeTabsSoundCloudAuthenticator(String clientId, String redirectUri, Activity context) {
        super(clientId, redirectUri);
        this.context = context;
        this.serviceConnection = new AuthTabServiceConnection(new AuthenticationCallback(){

            @Override
            public void onReadyToAuthenticate() {
                ChromeTabsSoundCloudAuthenticator.this.launchAuthenticationFlow();
            }

            @Override
            public void onAuthenticationEnded() {
            }
        });
        this.browserPackageName = CustomTabsClient.getPackageName((Context)context, null);
    }

    @Override
    public boolean prepareAuthenticationFlow() {
        return CustomTabsClient.bindCustomTabsService((Context)this.context, (String)this.browserPackageName, (CustomTabsServiceConnection)this.serviceConnection);
    }

    @Override
    @SuppressLint(value={""})
    public void launchAuthenticationFlow() {
        CustomTabsSession tabsSession = this.serviceConnection.getSession();
        CustomTabsIntent tabsIntent = new CustomTabsIntent.Builder(tabsSession).build();
        if (Build.VERSION.SDK_INT > 22) {
            String referrer = "2//" + this.context.getPackageName();
            tabsIntent.intent.putExtra("android.intent.extra.REFERRER_NAME", referrer);
        }
        tabsIntent.intent.setPackage(this.browserPackageName);
        tabsIntent.launchUrl(this.context, Uri.parse((String)this.loginUrl()));
    }

    public void unbindService() {
        this.context.unbindService((ServiceConnection)this.serviceConnection);
    }
}

