/*
 * Decompiled with CFR 0.152.
 */
package com.jlubecki.soundcloud.webapi.android;

import com.jlubecki.soundcloud.webapi.android.models.Comment;
import com.jlubecki.soundcloud.webapi.android.models.Connection;
import com.jlubecki.soundcloud.webapi.android.models.Group;
import com.jlubecki.soundcloud.webapi.android.models.Playlist;
import com.jlubecki.soundcloud.webapi.android.models.SecretToken;
import com.jlubecki.soundcloud.webapi.android.models.Track;
import com.jlubecki.soundcloud.webapi.android.models.User;
import com.jlubecki.soundcloud.webapi.android.models.WebProfile;
import java.util.HashMap;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface SoundCloudService {
    @GET(value="tracks")
    public Call<List<Track>> searchTracks(@Query(value="q") String var1);

    @GET(value="tracks")
    public Call<List<Track>> searchTracks(@QueryMap HashMap<String, String> var1);

    @GET(value="tracks/{id}")
    public Call<Track> getTrack(@Path(value="id") String var1);

    @GET(value="tracks/{id}/comments")
    public Call<List<Comment>> getTrackComments(@Path(value="id") String var1);

    @GET(value="tracks/{id}/comments/{comment-id}")
    public Call<Comment> getTrackComment(@Path(value="id") String var1, @Path(value="comment-id") String var2);

    @GET(value="tracks/{id}/favoriters")
    public Call<List<User>> getTrackFavoriters(@Path(value="id") String var1);

    @GET(value="tracks/{id}/favoriters/{user-id")
    public Call<User> getTrackFavoriter(@Path(value="id") String var1, @Path(value="user-id") String var2);

    @GET(value="tracks/{id}/secret-token")
    public Call<SecretToken> getTrackSecret(@Path(value="id") String var1);

    @GET(value="users")
    public Call<List<User>> searchUsers(@Query(value="q") String var1);

    @GET(value="users/{id}")
    public Call<User> getUser(@Path(value="id") String var1);

    @GET(value="users/{id}/tracks")
    public Call<List<Track>> getUserTracks(@Path(value="id") String var1);

    @GET(value="users/{id}/playlists")
    public Call<List<Playlist>> getUserPlaylists(@Path(value="id") String var1);

    @GET(value="users/{id}/followings")
    public Call<List<User>> getUserFollowings(@Path(value="id") String var1);

    @GET(value="users/{id}/followings/{following-id}")
    public Call<User> getUserFollowing(@Path(value="id") String var1, @Path(value="following-id") String var2);

    @GET(value="users/{id}/followers")
    public Call<List<User>> getUserFollowers(@Path(value="id") String var1);

    @GET(value="users/{id}/followers/{follower-id}")
    public Call<User> getUserFollower(@Path(value="id") String var1, @Path(value="follower-id") String var2);

    @GET(value="users/{id}/comments")
    public Call<List<Comment>> getUserComments(@Path(value="id") String var1);

    @GET(value="users/{id}/favorites")
    public Call<List<Track>> getUserFavorites(@Path(value="id") String var1);

    @GET(value="users/{id}/favorites/{favorite-id}")
    public Call<Track> getUserFavorite(@Path(value="id") String var1, @Path(value="favorite-id") String var2);

    @GET(value="users/{id}/groups")
    public Call<List<Group>> getUserGroups(@Path(value="id") String var1);

    @GET(value="users/{id}/web-profiles")
    public Call<List<WebProfile>> getUserWebProfiles(@Path(value="id") String var1);

    @GET(value="playlists")
    public Call<List<Playlist>> getPlaylists(@Query(value="q") String var1);

    @GET(value="playlists")
    public Call<List<Playlist>> getPlaylists(@Query(value="q") String var1, @Query(value="representation") String var2);

    @GET(value="playlists/{id}/secret-token")
    public Call<SecretToken> getPlaylistSecret(@Path(value="id") String var1);

    @GET(value="groups")
    public Call<List<Group>> searchGroups(@Query(value="q") String var1);

    @GET(value="groups/{id}")
    public Call<Group> getGroup(@Path(value="id") String var1);

    @GET(value="groups/{id}/moderators")
    public Call<List<User>> getGroupModerators(@Path(value="id") String var1);

    @GET(value="groups/{id}/members")
    public Call<List<User>> getGroupMembers(@Path(value="id") String var1);

    @GET(value="groups/{id}/contributors")
    public Call<List<User>> getGroupContributors(@Path(value="id") String var1);

    @GET(value="groups/{id}/users")
    public Call<List<User>> getGroupUsers(@Path(value="id") String var1);

    @GET(value="groups/{id}/pending_tracks")
    public Call<List<Track>> getGroupPendingTracks(@Path(value="id") String var1);

    @GET(value="groups/{id}/pending_tracks/{pending-id}")
    public Call<Track> getGroupPendingTrack(@Path(value="id") String var1, @Path(value="pending-id") String var2);

    @GET(value="groups/{id}/contributions")
    public Call<List<Track>> getGroupContributions(@Path(value="id") String var1);

    @GET(value="groups/{id}/pending_tracks/{contribution-id}")
    public Call<Track> getGroupContribution(@Path(value="id") String var1, @Path(value="contribution-id") String var2);

    @GET(value="me")
    public Call<User> getMe();

    @GET(value="me/tracks")
    public Call<List<Track>> getMyTracks();

    @GET(value="me/playlists")
    public Call<List<Playlist>> getMyPlaylists();

    @GET(value="me/followings")
    public Call<List<User>> getMyFollowings();

    @GET(value="me/followings/{following-id}")
    public Call<User> getMyFollowing(@Path(value="following-id") String var1);

    @GET(value="me/followers")
    public Call<List<User>> getMyFollowers();

    @GET(value="me/followers/{follower-id}")
    public Call<User> getMyFollower(@Path(value="follower-id") String var1);

    @GET(value="me/comments")
    public Call<List<Comment>> getMyComments();

    @GET(value="me/favorites")
    public Call<List<Track>> getMyFavorites();

    @GET(value="me/favorites/{favorite-id}")
    public Call<List<Track>> getMyFavorite(@Path(value="favorite-id") String var1);

    @GET(value="me/groups")
    public Call<List<Group>> getMyGroups();

    @GET(value="me/web-profiles")
    public Call<List<WebProfile>> getMyWebProfiles();

    @GET(value="me/connections")
    public Call<List<Connection>> getMyConnections();

    @GET(value="me/connections")
    public Call<Connection> getMyConnection(String var1);
}

