/*
 * Decompiled with CFR 0.152.
 */
package com.jiongbull.jlog.util;

import android.support.annotation.NonNull;
import android.text.format.DateFormat;
import com.jiongbull.jlog.JLog;
import java.util.Calendar;

public final class TimeUtils {
    private TimeUtils() {
    }

    public static Calendar getCalendar(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    public static long getUtcMillis(long millis) {
        Calendar calendar = TimeUtils.getCalendar(millis);
        long offset = calendar.get(15);
        return millis - offset;
    }

    public static long getMillis(long millis) {
        return TimeUtils.getUtcMillis(millis) + JLog.getSettings().getZoneOffset().getValue();
    }

    public static long getCurMillis() {
        return TimeUtils.getMillis(System.currentTimeMillis());
    }

    public static String getCurDate() {
        return TimeUtils.format(TimeUtils.getCurMillis(), "yyyy-MM-dd");
    }

    public static String format(long millis, @NonNull String fmt) {
        return DateFormat.format((CharSequence)fmt, (long)millis).toString();
    }

    public static String getCurTime() {
        return TimeUtils.format(TimeUtils.getCurMillis(), JLog.getSettings().getTimeFormat());
    }

    public static int getCurHour() {
        Calendar calendar = TimeUtils.getCalendar(TimeUtils.getCurMillis());
        return calendar.get(11);
    }
}

