/*
 * Decompiled with CFR 0.152.
 */
package com.jiongbull.jlog;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.jiongbull.jlog.Settings;
import com.jiongbull.jlog.constant.LogLevel;
import com.jiongbull.jlog.printer.DefaultPrinter;
import com.jiongbull.jlog.printer.JsonPrinter;
import com.jiongbull.jlog.printer.Printer;
import com.jiongbull.jlog.util.LogUtils;
import java.io.PrintWriter;
import java.io.StringWriter;

public class JLog {
    private static final String LOG_CLASS_NAME = JLog.class.getName();
    private static final String LOG_PRINT_METHOD_NAME = "printLog";
    private static DefaultPrinter sDefaultPrinter;
    private static JsonPrinter sJsonPrinter;
    private static Settings sSettings;

    public static Settings init(@NonNull Context context) {
        sDefaultPrinter = new DefaultPrinter();
        sJsonPrinter = new JsonPrinter();
        sSettings = new Settings();
        return sSettings.setContext(context);
    }

    public static Settings getSettings() {
        return sSettings;
    }

    public static void setSettings(@NonNull Settings settings) {
        sSettings = settings;
    }

    public static void v(String tag, @NonNull String message) {
        JLog.printLog(LogLevel.VERBOSE, tag, null, message);
    }

    public static void v(@NonNull String message) {
        JLog.printLog(LogLevel.VERBOSE, null, null, message);
    }

    public static void d(String tag, @NonNull String message) {
        JLog.printLog(LogLevel.DEBUG, tag, null, message);
    }

    public static void d(@NonNull String message) {
        JLog.printLog(LogLevel.DEBUG, null, null, message);
    }

    public static void i(String tag, @NonNull String message) {
        JLog.printLog(LogLevel.INFO, tag, null, message);
    }

    public static void i(@NonNull String message) {
        JLog.printLog(LogLevel.INFO, null, null, message);
    }

    public static void w(String tag, @NonNull String message) {
        JLog.printLog(LogLevel.WARN, tag, null, message);
    }

    public static void w(@NonNull String message) {
        JLog.printLog(LogLevel.WARN, null, null, message);
    }

    public static void e(String tag, Throwable t, String message) {
        JLog.printLog(LogLevel.ERROR, tag, t, message);
    }

    public static void e(Throwable t, String message) {
        JLog.printLog(LogLevel.ERROR, null, t, message);
    }

    public static void e(String tag, @NonNull String message) {
        JLog.printLog(LogLevel.ERROR, tag, null, message);
    }

    public static void e(@NonNull String message) {
        JLog.printLog(LogLevel.ERROR, null, null, message);
    }

    public static void e(String tag, @NonNull Throwable t) {
        JLog.printLog(LogLevel.ERROR, tag, t, null);
    }

    public static void e(@NonNull Throwable t) {
        JLog.printLog(LogLevel.ERROR, null, t, null);
    }

    public static void wtf(String tag, Throwable t, String message) {
        JLog.printLog(LogLevel.WTF, tag, t, message);
    }

    public static void wtf(Throwable t, String message) {
        JLog.printLog(LogLevel.WTF, null, t, message);
    }

    public static void wtf(String tag, @NonNull String message) {
        JLog.printLog(LogLevel.WTF, tag, null, message);
    }

    public static void wtf(@NonNull String message) {
        JLog.printLog(LogLevel.WTF, null, null, message);
    }

    public static void wtf(String tag, @NonNull Throwable t) {
        JLog.printLog(LogLevel.WTF, tag, t, null);
    }

    public static void wtf(@NonNull Throwable t) {
        JLog.printLog(LogLevel.WTF, null, t, null);
    }

    public static void json(String tag, @NonNull String json) {
        JLog.printLog(LogLevel.JSON, tag, null, json);
    }

    public static void json(@NonNull String json) {
        JLog.printLog(LogLevel.JSON, null, null, json);
    }

    private static void printLog(@NonNull LogLevel level, String tag, Throwable t, String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            message = null;
        }
        if (message == null) {
            if (t == null) {
                return;
            }
            message = Log.getStackTraceString((Throwable)t);
        } else if (t != null) {
            message = message + Printer.LINE_SEPARATOR + JLog.getStackTraceString(t);
        }
        StackTraceElement[] elements = new Throwable().getStackTrace();
        int index = JLog.getStackIndex(elements);
        if (index == -1) {
            throw new IllegalStateException("set -keep class com.jiongbull.jlog.** { *; } in your proguard config file");
        }
        StackTraceElement element = elements[index];
        if (TextUtils.isEmpty((CharSequence)tag)) {
            tag = JLog.getTag(element);
        }
        Settings settings = JLog.getSettings();
        boolean isOutputToConsole = settings.isDebug();
        boolean isOutputToFile = settings.isWriteToFile() && settings.getLogLevelsForFile().contains((Object)level);
        switch (level) {
            case VERBOSE: 
            case DEBUG: 
            case INFO: 
            case WARN: 
            case ERROR: 
            case WTF: {
                if (isOutputToConsole) {
                    sDefaultPrinter.printConsole(level, tag, message, element);
                }
                if (!isOutputToFile) break;
                sDefaultPrinter.printFile(level, tag, message, element);
                break;
            }
            case JSON: {
                if (isOutputToConsole) {
                    sJsonPrinter.printConsole(level, tag, message, element);
                }
                if (!isOutputToFile) break;
                sJsonPrinter.printFile(level, tag, message, element);
                break;
            }
        }
    }

    private static String getTag(@NonNull StackTraceElement element) {
        return LogUtils.getSimpleClassName(element.getClassName());
    }

    private static int getStackIndex(@NonNull StackTraceElement[] elements) {
        boolean isChecked = false;
        for (int i = 0; i < elements.length; ++i) {
            int index;
            StackTraceElement element = elements[i];
            if (LOG_CLASS_NAME.equals(element.getClassName()) && LOG_PRINT_METHOD_NAME.equals(element.getMethodName())) {
                isChecked = true;
            }
            if (!isChecked || (index = i + 2) >= elements.length) continue;
            return index;
        }
        return -1;
    }

    private static String getStackTraceString(@NonNull Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

