/*
 * Decompiled with CFR 0.152.
 */
package com.jiongbull.jlog.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.jiongbull.jlog.JLog;
import com.jiongbull.jlog.R;

public class SysUtils {
    private SysUtils() {
    }

    public static String getManufacturerInfo() {
        return Build.MANUFACTURER;
    }

    public static String getModelInfo() {
        return Build.MODEL;
    }

    public static String getProductInfo() {
        return Build.PRODUCT;
    }

    public static String getBrandInfo() {
        return Build.BRAND;
    }

    public static int getOsVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    public static String getOsVersionName() {
        return Build.VERSION.RELEASE;
    }

    public static String getOsVersionDisplayName() {
        return Build.DISPLAY;
    }

    public static int getAppVersionCode(Context context) {
        int appVersionCode = 0;
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            appVersionCode = info.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"SysUtils", (String)e.getMessage());
        }
        return appVersionCode;
    }

    public static String getAppVersionName(Context context) {
        String appVersionName = "\u672a\u77e5\u7248\u672c";
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            appVersionName = info.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"SysUtils", (String)e.getMessage());
        }
        return appVersionName;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String genInfo() {
        Context context = JLog.getSettings().getContext();
        String lineSeparator = SysUtils.getLineSeparator();
        String info = "";
        info = info + context.getString(R.string.app_version_name) + ": " + SysUtils.getAppVersionName(context) + lineSeparator;
        info = info + context.getString(R.string.app_version_code) + ": " + SysUtils.getAppVersionCode(context) + lineSeparator;
        info = info + context.getString(R.string.os_version_name) + ": " + SysUtils.getOsVersionName() + lineSeparator;
        info = info + context.getString(R.string.os_version_code) + ": " + SysUtils.getOsVersionCode() + lineSeparator;
        info = info + context.getString(R.string.os_display_name) + ": " + SysUtils.getOsVersionDisplayName() + lineSeparator;
        info = info + context.getString(R.string.brand_info) + ": " + SysUtils.getBrandInfo() + lineSeparator;
        info = info + context.getString(R.string.product_info) + ": " + SysUtils.getProductInfo() + lineSeparator;
        info = info + context.getString(R.string.model_info) + ": " + SysUtils.getModelInfo() + lineSeparator;
        info = info + context.getString(R.string.manufacturer_info) + ": " + SysUtils.getManufacturerInfo() + lineSeparator + lineSeparator + lineSeparator;
        return info;
    }
}

