/*
 * Decompiled with CFR 0.152.
 */
package com.jiongbull.jlog.util;

import com.jiongbull.jlog.constant.LogLevel;
import com.jiongbull.jlog.printer.Printer;
import com.jiongbull.jlog.util.FileUtils;
import com.jiongbull.jlog.util.LogUtils;
import com.jiongbull.jlog.util.SysUtils;
import com.jiongbull.jlog.util.TimeUtils;
import java.io.File;

public class PrinterUtils {
    private static final String PRINT_CONSOLE_FORMAT = "[(%1$s:%2$d)#%3$s]" + Printer.LINE_SEPARATOR + "%4$s";
    private static final String PRINT_FILE_FORMAT = "[%1$s %2$s %3$s:%4$d]" + Printer.LINE_SEPARATOR + "%5$s" + Printer.LINE_SEPARATOR + Printer.LINE_SEPARATOR;

    private PrinterUtils() {
    }

    public static void printConsole(LogLevel level, String tag, String message) {
        LogUtils.log(level, tag, message);
    }

    public static void printFile(String message) {
        String dirPath = LogUtils.genDirPath();
        String fileName = LogUtils.genFileName();
        if (!FileUtils.isExist(dirPath + File.separator + fileName)) {
            message = SysUtils.genInfo() + message;
        }
        FileUtils.write(dirPath, fileName, message, false);
    }

    public static String decorateMsgForConsole(String message, StackTraceElement element) {
        String methodName = element.getMethodName();
        int lineNumber = element.getLineNumber();
        String fileName = element.getFileName();
        return String.format(PRINT_CONSOLE_FORMAT, fileName, lineNumber, methodName, message);
    }

    public static String decorateMsgForFile(LogLevel level, String message, StackTraceElement element) {
        String time = TimeUtils.getCurTime();
        String fileName = element.getFileName();
        int lineNum = element.getLineNumber();
        return String.format(PRINT_FILE_FORMAT, time, level.getValue(), fileName, lineNum, message);
    }
}

