/*
 * Decompiled with CFR 0.152.
 */
package com.jiongbull.jlog.util;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.jiongbull.jlog.JLog;
import com.jiongbull.jlog.constant.LogLevel;
import com.jiongbull.jlog.constant.LogSegment;
import com.jiongbull.jlog.util.TimeUtils;
import java.io.File;

public final class LogUtils {
    private static final int MAX_LOG_LENGTH = 4000;
    private static final String LOG_EXT = ".log";

    private LogUtils() {
    }

    public static void log(LogLevel level, String tag, String message) {
        int subNum = message.length() / 4000;
        if (subNum > 0) {
            int index = 0;
            for (int i = 0; i < subNum; ++i) {
                int lastIndex = index + 4000;
                String sub = message.substring(index, lastIndex);
                LogUtils.logSub(level, tag, sub);
                index = lastIndex;
            }
            LogUtils.logSub(level, tag, message.substring(index, message.length()));
        } else {
            LogUtils.logSub(level, tag, message);
        }
    }

    public static String getSimpleClassName(String className) {
        int lastIndex = className.lastIndexOf(".");
        int index = lastIndex + 1;
        if (lastIndex > 0 && index < className.length()) {
            return className.substring(index);
        }
        return className;
    }

    public static String genDirPath() {
        String dir = JLog.getSettings().getLogDir();
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + dir;
    }

    public static String genFileName() {
        String logPrefix = JLog.getSettings().getLogPrefix();
        logPrefix = TextUtils.isEmpty((CharSequence)logPrefix) ? "" : logPrefix + "_";
        String curDate = TimeUtils.getCurDate();
        String fileName = JLog.getSettings().getLogSegment() == LogSegment.TWENTY_FOUR_HOURS ? logPrefix + TimeUtils.getCurDate() + LOG_EXT : logPrefix + curDate + "_" + LogUtils.getCurSegment() + LOG_EXT;
        return fileName;
    }

    private static String getCurSegment() {
        LogSegment logSegment;
        int segmentValue;
        int hour = TimeUtils.getCurHour();
        int start = hour - hour % (segmentValue = (logSegment = JLog.getSettings().getLogSegment()).getValue());
        int end = start + segmentValue;
        if (end == 24) {
            end = 0;
        }
        return LogUtils.getDoubleNum(start) + LogUtils.getDoubleNum(end);
    }

    private static String getDoubleNum(int num) {
        return num < 10 ? "0" + num : String.valueOf(num);
    }

    private static void logSub(LogLevel level, String tag, String sub) {
        switch (level) {
            case VERBOSE: {
                Log.v((String)tag, (String)sub);
                break;
            }
            case DEBUG: {
                Log.d((String)tag, (String)sub);
                break;
            }
            case INFO: {
                Log.i((String)tag, (String)sub);
                break;
            }
            case WARN: {
                Log.w((String)tag, (String)sub);
                break;
            }
            case ERROR: {
                Log.e((String)tag, (String)sub);
                break;
            }
            case WTF: {
                Log.wtf((String)tag, (String)sub);
                break;
            }
            case JSON: {
                Log.d((String)tag, (String)sub);
            }
        }
    }
}

