/*
 * Decompiled with CFR 0.152.
 */
package com.jiongbull.jlog.util;

import android.util.Log;
import com.jiongbull.jlog.JLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FileUtils {
    private static ExecutorService sExecutorService = Executors.newSingleThreadExecutor();

    private FileUtils() {
    }

    public static boolean isExist(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean createDir(String dirPath) {
        File file = new File(dirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.exists();
    }

    public static void write(final String dirPath, final String fileName, final String content, final boolean isOverride) {
        sExecutorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String filePath = dirPath + File.separator + fileName;
                FileOutputStream fos = null;
                try {
                    if (FileUtils.createDir(dirPath)) {
                        File file;
                        boolean isExist = (file = new File(filePath)).exists();
                        fos = new FileOutputStream(file, isExist && !isOverride);
                        fos.write(content.getBytes(JLog.getSettings().getCharset()));
                    }
                }
                catch (IOException e) {
                    Log.e((String)"FileUtils", (String)e.getMessage());
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            Log.e((String)"FileUtils", (String)e.getMessage());
                        }
                    }
                }
            }
        });
    }
}

