/*
 * Decompiled with CFR 0.152.
 */
package com.jiongbull.jlog.printer;

import com.jiongbull.jlog.constant.LogLevel;
import com.jiongbull.jlog.printer.Printer;
import com.jiongbull.jlog.util.PrinterUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonPrinter
implements Printer {
    private static final int JSON_INDENT = 4;

    @Override
    public void printConsole(LogLevel level, String tag, String message, StackTraceElement element) {
        String json;
        try {
            if (message.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(message);
                json = jsonObject.toString(4);
            } else if (message.startsWith("{")) {
                JSONArray jsonArray = new JSONArray(message);
                json = jsonArray.toString(4);
            } else {
                json = message;
            }
        }
        catch (JSONException e) {
            json = message;
        }
        PrinterUtils.printConsole(level, tag, PrinterUtils.decorateMsgForConsole(json, element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printFile(LogLevel level, String tag, String message, StackTraceElement element) {
        Class<Printer> clazz = Printer.class;
        synchronized (Printer.class) {
            PrinterUtils.printFile(PrinterUtils.decorateMsgForFile(level, message, element));
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }
}

