/*
 * Decompiled with CFR 0.152.
 */
package com.jiongbull.jlog;

import android.content.Context;
import com.jiongbull.jlog.constant.LogLevel;
import com.jiongbull.jlog.constant.LogSegment;
import com.jiongbull.jlog.constant.ZoneOffset;
import java.util.ArrayList;
import java.util.List;

public class Settings {
    private Context mContext;
    private boolean mIsDebug = true;
    private String mCharset = "UTF-8";
    private String mTimeFormat = "yyyy-MM-dd HH:mm:ss";
    private ZoneOffset mZoneOffset = ZoneOffset.P0800;
    private String mLogDir = "jlog";
    private String mLogPrefix = "";
    private LogSegment mLogSegment = LogSegment.TWENTY_FOUR_HOURS;
    private boolean mWriteToFile = false;
    private List<LogLevel> mLogLevelsForFile = new ArrayList<LogLevel>();

    public Settings() {
        this.mLogLevelsForFile.add(LogLevel.ERROR);
        this.mLogLevelsForFile.add(LogLevel.WTF);
    }

    public Context getContext() {
        return this.mContext;
    }

    public Settings setContext(Context context) {
        this.mContext = context;
        return this;
    }

    public String getCharset() {
        return this.mCharset;
    }

    public Settings setCharset(String charset) {
        this.mCharset = charset;
        return this;
    }

    public String getTimeFormat() {
        return this.mTimeFormat;
    }

    public Settings setTimeFormat(String timeFormat) {
        this.mTimeFormat = timeFormat;
        return this;
    }

    public ZoneOffset getZoneOffset() {
        return this.mZoneOffset;
    }

    public Settings setZoneOffset(ZoneOffset zoneOffset) {
        this.mZoneOffset = zoneOffset;
        return this;
    }

    public String getLogDir() {
        return this.mLogDir;
    }

    public Settings setLogDir(String logDir) {
        this.mLogDir = logDir;
        return this;
    }

    public String getLogPrefix() {
        return this.mLogPrefix;
    }

    public Settings setLogPrefix(String logPrefix) {
        this.mLogPrefix = logPrefix;
        return this;
    }

    public LogSegment getLogSegment() {
        return this.mLogSegment;
    }

    public Settings setLogSegment(LogSegment logSegment) {
        this.mLogSegment = logSegment;
        return this;
    }

    public boolean isWriteToFile() {
        return this.mWriteToFile;
    }

    public Settings writeToFile(boolean isWriteToFile) {
        this.mWriteToFile = isWriteToFile;
        return this;
    }

    public List<LogLevel> getLogLevelsForFile() {
        return this.mLogLevelsForFile;
    }

    public Settings setLogLevelsForFile(List<LogLevel> logLevelsForFile) {
        this.mLogLevelsForFile = logLevelsForFile;
        return this;
    }

    public boolean isDebug() {
        return this.mIsDebug;
    }

    public Settings setDebug(boolean isDebug) {
        this.mIsDebug = isDebug;
        return this;
    }
}

