/*
 * Decompiled with CFR 0.152.
 */
package com.jimi.jmsmartftputils;

import android.util.Log;
import com.jimi.jmsmartftputils.JMFtpImp;
import com.jimi.jmsmartftputils.bean.FTPDownInfoBean;
import com.jimi.jmsmartftputils.bean.FileBean;
import com.jimi.jmsmartftputils.bean.FtpProcessBean;
import com.jimi.jmsmartftputils.listener.JMFtpFindAllPathFilesCallBack;
import com.jimi.jmsmartftputils.listener.JMFtpFindFilesCallBack;
import com.jimi.jmsmartftputils.listener.JMFtpListener;
import com.jimi.jmsmartftputils.listener.JMFtpProcessCallBack;
import com.jimi.jmsmartutils.system.JMThread;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class JMFtp
implements JMFtpImp {
    private String TAG = "JMFtp";
    private static final String temp = "tem";
    private FTPClient pClient;
    private String baseUrl;
    private String mode;
    private String account;
    private String password;
    private int port;
    private Map<String, FTPDownInfoBean> tagMap = new HashMap<String, FTPDownInfoBean>();
    private static JMFtp instance;
    private Disposable disposable;
    private volatile int speed;
    private boolean isOpenDisposable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMFtp getInstance() {
        Class<JMFtp> clazz = JMFtp.class;
        synchronized (JMFtp.class) {
            if (instance == null) {
                instance = new JMFtp();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void configFtpSyncFile(String baseUrl, String mode, int port, String account, String password, JMFtpListener jmFtpListener) {
        Log.e((String)this.TAG, (String)("\u914d\u7f6e: baseUrl:" + baseUrl + "\n mode " + mode + "\n port " + port + "\n account " + account + "\n password " + password));
        if (baseUrl == null || mode == null || port < 0 || account == null || password == null) {
            if (jmFtpListener != null) {
                jmFtpListener.onFail(801);
            }
            return;
        }
        if (!"passive".equals(mode) && !"active".equals(mode)) {
            if (jmFtpListener != null) {
                jmFtpListener.onFail(800);
            }
            return;
        }
        if (baseUrl.trim().startsWith("ftp://")) {
            String[] strUrl = baseUrl.split("//");
            baseUrl = strUrl.length == 2 ? strUrl[1] : strUrl[0];
        }
        this.baseUrl = baseUrl;
        this.mode = mode;
        this.port = port;
        this.account = account;
        this.password = password;
        if (jmFtpListener != null) {
            jmFtpListener.onSuccess(null);
        }
    }

    @Override
    public void connectFTP(final JMFtpListener jmFtpListener) {
        JMThread.getCachedPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (JMFtp.this.pClient == null) {
                        JMFtp.this.pClient = new FTPClient();
                    }
                    if (JMFtp.this.mode.equals("passive")) {
                        JMFtp.this.pClient.enterLocalPassiveMode();
                    } else {
                        JMFtp.this.pClient.enterLocalActiveMode();
                    }
                    JMFtp.this.pClient.connect(JMFtp.this.baseUrl, JMFtp.this.port);
                    JMFtp.this.pClient.login(JMFtp.this.account, JMFtp.this.password);
                    JMFtp.this.pClient.setFileType(2);
                    int reply = JMFtp.this.pClient.getReplyCode();
                    if (!FTPReply.isPositiveCompletion((int)reply)) {
                        JMFtp.this.pClient.disconnect();
                        Log.e((String)JMFtp.this.TAG, (String)"FTP\u94fe\u63a5\u5931\u8d25");
                        JMThread.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                jmFtpListener.onFail(809);
                            }
                        });
                    } else {
                        Log.e((String)JMFtp.this.TAG, (String)"FTP\u94fe\u63a5\u6210\u529f");
                        JMThread.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                jmFtpListener.onSuccess(null);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.e((String)JMFtp.this.TAG, (String)"FTP\u94fe\u63a5\u5931\u8d25");
                    JMThread.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            jmFtpListener.onFail(809);
                        }
                    });
                }
            }
        });
    }

    public void resumeConnectFTP(JMFtpListener jmFtpListener) {
        this.closeFTP(jmFtpListener);
        this.connectFTP(jmFtpListener);
    }

    public void findFTPFileList(final List<String> fileBeans, final JMFtpFindAllPathFilesCallBack callBack) {
        if (fileBeans == null || fileBeans.size() == 0) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callBack.onFail(803);
                }
            });
            return;
        }
        if (this.pClient == null || !this.pClient.isConnected()) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callBack.onFail(810);
                }
            });
            Log.e((String)this.TAG, (String)"FTP\u94fe\u63a5\u65ad\u5f00");
            return;
        }
        JMThread.getCachedPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final HashMap<String, List<FileBean>> map = new HashMap<String, List<FileBean>>();
                    for (int i = 0; i < fileBeans.size(); ++i) {
                        FTPFile[] ftpFiles;
                        String filePath = (String)fileBeans.get(i);
                        if (!JMFtp.this.changeDirectory(filePath) || (ftpFiles = JMFtp.this.pClient.listFiles()) == null || ftpFiles.length <= 0) continue;
                        ArrayList<FileBean> fileBeans2 = new ArrayList<FileBean>();
                        for (int index = 0; index < ftpFiles.length; ++index) {
                            try {
                                FTPFile[] childFiles;
                                FileBean fileBean = JMFtp.this.changeFileBean(filePath, ftpFiles[index]);
                                if (JMFtp.this.changeDirectory(fileBean.getFilePath()) && (childFiles = JMFtp.this.pClient.listFiles()) != null && childFiles.length > 0) {
                                    ArrayList<FileBean> childFileBeans = new ArrayList<FileBean>();
                                    for (int j = 0; j < childFiles.length; ++j) {
                                        String childFileName = childFiles[j].getName();
                                        int suffixIndex = childFileName.indexOf(".");
                                        if (!childFiles[j].isFile() || suffixIndex == -1 || childFileName.substring(suffixIndex).contains("jpg") || childFileName.substring(suffixIndex).contains("png") || childFileName.substring(suffixIndex).contains("temp")) continue;
                                        FileBean childFileBean = JMFtp.this.changeFileBean(fileBean.getFilePath(), childFiles[j]);
                                        childFileBeans.add(childFileBean);
                                    }
                                    fileBean.setChildFiles(childFileBeans);
                                }
                                fileBeans2.add(fileBean);
                                if (map.get(fileBean.getFileName()) == null && fileBean.getChildFiles() != null) {
                                    map.put(fileBean.getFileName(), fileBean.getChildFiles());
                                    continue;
                                }
                                if (map.get(fileBean.getFileName()) == null || fileBean.getChildFiles() == null) continue;
                                ((List)map.get(fileBean.getFileName())).addAll(fileBean.getChildFiles());
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    JMThread.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onSuccess(map);
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)JMFtp.this.TAG, (String)"\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
                    JMThread.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onFail(803);
                        }
                    });
                }
            }
        });
    }

    private FileBean changeFileBean(String filePath, FTPFile ftpFile) {
        FileBean fileBean = new FileBean();
        fileBean.setFileName(ftpFile.getName());
        fileBean.setFileSize(ftpFile.getSize());
        fileBean.setFilePath(filePath + File.separator + ftpFile.getName());
        fileBean.setFileType(ftpFile.getType());
        return fileBean;
    }

    @Override
    public void findFTPFlies(final String subPath, final JMFtpFindFilesCallBack callBack) {
        if (subPath == null) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callBack.onFail(803);
                }
            });
            return;
        }
        if (this.pClient == null || !this.pClient.isConnected()) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callBack.onFail(810);
                }
            });
            Log.e((String)this.TAG, (String)"FTP\u94fe\u63a5\u65ad\u5f00");
            return;
        }
        JMThread.getCachedPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!JMFtp.this.changeDirectory(subPath)) {
                        callBack.onFail(803);
                        return;
                    }
                    FTPFile[] ftpFiles = JMFtp.this.pClient.listFiles();
                    if (ftpFiles == null || ftpFiles.length <= 0) {
                        Log.e((String)JMFtp.this.TAG, (String)"findFTPFlies: \u4e3a\u7a7a\u4e86");
                        JMThread.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                callBack.onSuccess(new ArrayList<FileBean>());
                            }
                        });
                        return;
                    }
                    ArrayList<FileBean> fileBeans = new ArrayList<FileBean>();
                    for (int index = 0; index < ftpFiles.length; ++index) {
                        try {
                            FileBean fileBean = new FileBean();
                            fileBean.setFileName(ftpFiles[index].getName());
                            fileBean.setFileSize(ftpFiles[index].getSize());
                            fileBean.setFilePath(subPath + "/" + ftpFiles[index].getName());
                            fileBean.setFileType(ftpFiles[index].getType());
                            fileBeans.add(fileBean);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    final ArrayList<FileBean> list = fileBeans;
                    Log.e((String)JMFtp.this.TAG, (String)("findFTPFlies: \u957f\u5ea6" + fileBeans.size()));
                    JMThread.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onSuccess(list);
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)JMFtp.this.TAG, (String)"\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
                    JMThread.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onFail(803);
                        }
                    });
                }
            }
        });
    }

    private boolean changeDirectory(String directoryName) {
        try {
            boolean isOk = this.pClient.changeWorkingDirectory(directoryName);
            Log.e((String)"MainActivity", (String)("isOk : " + isOk));
            return isOk;
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void downFTPFile(final String url, String locaUrl, final String fileName, final String tag, final JMFtpProcessCallBack downloaCallBack) {
        if (url == null || locaUrl == null || fileName == null) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    downloaCallBack.onFail(804);
                }
            });
            return;
        }
        if (this.pClient == null || !this.pClient.isConnected()) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    downloaCallBack.onFail(810);
                }
            });
            Log.e((String)this.TAG, (String)"FTP\u94fe\u63a5\u65ad\u5f00");
            return;
        }
        final StringBuffer stringBuffer = new StringBuffer();
        if (!locaUrl.endsWith("/")) {
            locaUrl = locaUrl + "/";
        }
        stringBuffer.append(locaUrl);
        JMThread.getCachedPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JMFtp.this.tagMap.put(tag, new FTPDownInfoBean(url, fileName, stringBuffer.toString(), tag, true, 0, downloaCallBack));
                    FTPFile[] files = JMFtp.this.pClient.listFiles(url);
                    if (files == null || files.length <= 0) {
                        JMThread.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                downloaCallBack.onFail(812);
                            }
                        });
                        Log.e((String)JMFtp.this.TAG, (String)"files\u4e3a\u7a7a");
                        return;
                    }
                    File localFile = new File(stringBuffer.toString() + fileName);
                    long localBeginSize = 0L;
                    if (localFile.exists()) {
                        localBeginSize = localFile.length();
                        if (localBeginSize == files[0].getSize()) {
                            Log.e((String)JMFtp.this.TAG, (String)"\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728");
                            final FtpProcessBean processBean = new FtpProcessBean();
                            processBean.setTag(tag);
                            processBean.setPath(localFile.getPath());
                            processBean.setProgress(1.0);
                            JMFtp.this.removeTag(tag);
                            JMThread.runOnUiThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    downloaCallBack.onSuccess(processBean);
                                }
                            });
                            return;
                        }
                        localBeginSize = localFile.length();
                    }
                    JMFtp.this.pClient.setFileType(2);
                    if (JMFtp.this.downloadByUnit(url, fileName, stringBuffer.toString(), localBeginSize, files[0].getSize(), tag, downloaCallBack).booleanValue()) {
                        final FtpProcessBean processBean = new FtpProcessBean();
                        processBean.setTag(tag);
                        processBean.setPath(localFile.getPath());
                        processBean.setProgress(1.0);
                        JMThread.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                downloaCallBack.onSuccess(processBean);
                            }
                        });
                        JMFtp.this.removeTag(tag);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.e((String)JMFtp.this.TAG, (String)"\u6587\u4ef6\u4e0b\u8f7d\u9519\u8bef");
                    JMThread.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            downloaCallBack.onFail(804);
                        }
                    });
                }
            }
        });
    }

    private Boolean downloadByUnit(String url, String fileName, String locaUrl, long beginSize, long endSize, String tag, final JMFtpProcessCallBack callBack) throws Exception {
        int c;
        if (this.pClient == null || !this.pClient.isConnected()) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callBack.onFail(810);
                }
            });
            Log.e((String)this.TAG, (String)"FTP\u94fe\u63a5\u65ad\u5f00");
            return false;
        }
        File dirFile = new File(locaUrl);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        File localFile = new File(locaUrl + fileName);
        long waitSize = endSize - beginSize;
        Log.e((String)this.TAG, (String)("waitSize" + waitSize + "endSize " + endSize + "beginSize" + beginSize));
        this.changeWorkingDirectory(url, callBack);
        FileOutputStream out = new FileOutputStream(localFile, true);
        this.pClient.setRestartOffset(beginSize);
        this.pClient.setBufferSize(0x100000);
        InputStream in = this.pClient.retrieveFileStream(new String(url.getBytes("GBK"), "iso-8859-1"));
        byte[] bytes = new byte[1024];
        double finishSize = 0.0;
        double finishPercent = 0.0;
        long startTime = System.currentTimeMillis();
        if (this.isOpenDisposable) {
            this.disposable = Flowable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).onBackpressureBuffer().doOnNext((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    callBack.onSpeed(JMFtp.this.speed);
                    JMFtp.this.speed = 0;
                }
            }).subscribe();
        }
        while ((c = in.read(bytes)) != -1 && this.tagMap.get((Object)tag).isRun) {
            FtpProcessBean processBean;
            out.write(bytes, 0, c);
            this.speed += c;
            finishSize += (double)c;
            if (finishSize >= (double)waitSize) {
                Log.e((String)this.TAG, (String)("\u4e0b\u8f7d\u5b8c\u6210,\u4e0b\u8f7d\u5927\u5c0fMB\uff1a" + finishSize / 1024.0 / 1024.0));
                Log.e((String)this.TAG, (String)("\u4e0b\u8f7d\u6240\u7528\u65f6\u95f4 \u79d2\uff1a" + (System.currentTimeMillis() - startTime) / 1000L));
                finishPercent = (finishSize + (double)beginSize) / (double)endSize;
                processBean = new FtpProcessBean();
                processBean.setPath(locaUrl + fileName);
                processBean.setProgress(finishPercent);
                processBean.setTag(tag);
                JMThread.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.onProcess(processBean);
                    }
                });
            }
            if (!(finishSize / (double)waitSize - finishPercent > 0.01)) continue;
            finishPercent = (finishSize + (double)beginSize) / (double)endSize;
            processBean = new FtpProcessBean();
            processBean.setPath(locaUrl + fileName);
            processBean.setProgress(finishPercent);
            processBean.setTag(tag);
            processBean.currentNum = this.speed;
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callBack.onProcess(processBean);
                }
            });
        }
        in.close();
        out.close();
        this.stopDisposable();
        Log.e((String)this.TAG, (String)("\u6587\u4ef6\u6700\u540e\u5927\u5c0f" + localFile.length()));
        return this.pClient.completePendingCommand();
    }

    public void setOpenDisposable(boolean openDisposable) {
        this.isOpenDisposable = openDisposable;
    }

    public void stopDisposable() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
        this.disposable = null;
    }

    @Override
    public void uploadFTPFile(final String remoteFolder, String remoteFileName, final String localFilePath, boolean overWrite, final String tag, final JMFtpProcessCallBack callBack) {
        if (remoteFileName == null || remoteFolder == null || localFilePath == null || tag == null) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callBack.onFail(808);
                }
            });
            return;
        }
        if (this.pClient == null || !this.pClient.isConnected()) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callBack.onFail(810);
                }
            });
            Log.e((String)this.TAG, (String)"FTP\u94fe\u63a5\u65ad\u5f00");
            return;
        }
        final FTPDownInfoBean ftpDownInfoBean = new FTPDownInfoBean(remoteFolder, remoteFileName, localFilePath, tag, true, 1, callBack);
        ftpDownInfoBean.overWrite = overWrite;
        ftpDownInfoBean.tempFileName = remoteFileName + temp;
        ftpDownInfoBean.fileName = remoteFileName;
        this.tagMap.put(tag, ftpDownInfoBean);
        JMThread.getCachedPool().execute(new Runnable(){

            @Override
            public void run() {
                JMFtp.this.upload(remoteFolder, localFilePath, ftpDownInfoBean.tempFileName, tag, callBack);
            }
        });
    }

    private void upload(String remoteFolder, String localFilePath, String remoteFileName, String tag, final JMFtpProcessCallBack callBack) {
        try {
            int c;
            FTPDownInfoBean ftpDownInfoBean = this.tagMap.get(tag);
            FTPFile[] files = this.pClient.listFiles(remoteFolder + remoteFileName);
            File localFile = new File(localFilePath);
            long remoteSize = 0L;
            long localSize = localFile.length();
            if (files.length >= 1) {
                remoteSize = files[0].getSize();
                if (remoteSize == localSize) {
                    Log.e((String)this.TAG, (String)"\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728");
                    this.pClient.rename(remoteFolder + remoteFileName, remoteFolder + ftpDownInfoBean.fileName);
                    final FtpProcessBean processBean = new FtpProcessBean();
                    processBean.setPath(remoteFolder + remoteFileName);
                    processBean.setProgress(1.0);
                    processBean.setTag(tag);
                    JMThread.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onSuccess(processBean);
                        }
                    });
                    this.removeTag(tag);
                    return;
                }
                if (remoteSize > localSize) {
                    remoteSize = 0L;
                    this.pClient.dele(remoteFolder + remoteFileName);
                    Log.e((String)this.TAG, (String)"\u6587\u4ef6\u5f02\u5e38");
                }
            } else {
                this.pClient.makeDirectory(remoteFolder);
            }
            this.changeWorkingDirectory(remoteFolder, callBack);
            if (remoteSize < 0L) {
                remoteSize = 0L;
            }
            Log.e((String)this.TAG, (String)("remoteSize" + remoteSize));
            long writeSize = localSize - remoteSize;
            if (writeSize <= 0L) {
                return;
            }
            RandomAccessFile raf = new RandomAccessFile(localFile, "r");
            OutputStream out = this.pClient.appendFileStream(new String(remoteFileName.getBytes("GBK"), "iso-8859-1"));
            this.pClient.setRestartOffset(remoteSize);
            raf.seek(remoteSize);
            byte[] bytes = new byte[1024];
            double finishSize = 0.0;
            double finishPercent = 0.0;
            boolean isOk = false;
            while ((c = raf.read(bytes)) != -1 && this.tagMap.get((Object)tag).isRun) {
                out.write(bytes, 0, c);
                if (!((finishSize += (double)c) / (double)writeSize - finishPercent > 0.01) && finishSize != (double)writeSize) continue;
                finishPercent = finishSize / (double)writeSize;
                Log.e((String)this.TAG, (String)("finshSize" + finishSize + "write" + writeSize));
                Log.e((String)this.TAG, (String)("\u6587\u4ef6\u4e0a\u4f20\u8fdb\u5ea6" + finishPercent));
                final FtpProcessBean processBean = new FtpProcessBean();
                processBean.setPath(remoteFolder + ftpDownInfoBean.fileName);
                processBean.setProgress(finishPercent);
                processBean.setTag(tag);
                JMThread.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.onProcess(processBean);
                    }
                });
                if (!(finishPercent >= 1.0)) continue;
                isOk = true;
                Log.e((String)this.TAG, (String)"\u4e0a\u4f20\u5b8c\u6210");
                out.flush();
                raf.close();
                out.close();
                this.pClient.completePendingCommand();
                this.changeWorkingDirectory(remoteFolder, null);
                if (ftpDownInfoBean.overWrite) {
                    processBean.setPath(ftpDownInfoBean + ftpDownInfoBean.fileName);
                    if (this.pClient.listFiles(remoteFolder + ftpDownInfoBean.fileName).length > 0) {
                        Log.e((String)this.TAG, (String)"\u6587\u4ef6\u5b58\u5728,\u5148\u5220\u9664");
                        this.pClient.dele(remoteFolder + ftpDownInfoBean.fileName);
                    }
                    Log.e((String)this.TAG, (String)"\u91cd\u547d\u540d");
                    this.pClient.rename(remoteFolder + ftpDownInfoBean.tempFileName, remoteFolder + ftpDownInfoBean.fileName);
                } else {
                    String createName = remoteFolder + ftpDownInfoBean.fileName;
                    if (this.pClient.listFiles(remoteFolder + ftpDownInfoBean.fileName).length > 0) {
                        Log.e((String)this.TAG, (String)"\u6587\u4ef6\u5b58\u5728,\u6539\u540d");
                        createName = remoteFolder + System.currentTimeMillis() + ftpDownInfoBean.fileName;
                    }
                    this.pClient.rename(remoteFolder + ftpDownInfoBean.tempFileName, createName);
                    processBean.setPath(remoteFolder + createName);
                }
                JMThread.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.onProcess(processBean);
                        callBack.onSuccess(processBean);
                    }
                });
                this.removeTag(tag);
                Log.e((String)this.TAG, (String)("\u4e0a\u4f20\u5b8c\u62101" + this.pClient.printWorkingDirectory()));
                break;
            }
            if (!isOk) {
                out.flush();
                raf.close();
                out.close();
                this.pClient.completePendingCommand();
            }
            Log.e((String)this.TAG, (String)"\u4e0a\u4f20\u7ed3\u675f");
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)this.TAG, (String)"\u4e0a\u4f20\u5f02\u5e38");
            try {
                this.pClient.completePendingCommand();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void deleteFTPFile(final String remoteFile, final JMFtpListener jmFtpListener) {
        if (!this.isConnectSuccess(jmFtpListener)) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    jmFtpListener.onFail(810);
                }
            });
            return;
        }
        JMThread.getCachedPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (JMFtp.this.pClient.listFiles(remoteFile).length > 0) {
                        JMFtp.this.pClient.deleteFile(remoteFile);
                        JMThread.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                jmFtpListener.onSuccess(remoteFile);
                            }
                        });
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JMThread.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            jmFtpListener.onFail(806);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void moveFTPFile(final String from, final String to, final boolean overWrite, final JMFtpListener jmFtpListener) {
        if (from == null || to == null) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    jmFtpListener.onFail(807);
                }
            });
        }
        if (!this.isConnectSuccess(jmFtpListener)) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    jmFtpListener.onFail(810);
                }
            });
            return;
        }
        JMThread.getCachedPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String parentPath = to;
                    try {
                        parentPath = to.substring(0, to.lastIndexOf("/"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    JMFtp.this.pClient.makeDirectory(parentPath);
                    JMFtp.this.pClient.changeWorkingDirectory(parentPath);
                    if (overWrite) {
                        if (JMFtp.this.pClient.listFiles(to).length > 0) {
                            JMFtp.this.pClient.dele(to + JMFtp.temp);
                            if (JMFtp.this.pClient.rename(to, to + JMFtp.temp)) {
                                if (JMFtp.this.pClient.rename(from, to)) {
                                    Log.e((String)JMFtp.this.TAG, (String)"moveFTPFile: \u79fb\u52a8\u6210\u529f");
                                    JMFtp.this.pClient.dele(to + JMFtp.temp);
                                    JMFtp.this.moveFileSucees(to, jmFtpListener);
                                } else {
                                    Log.e((String)JMFtp.this.TAG, (String)"moveFTPFile: \u79fb\u52a8\u5931\u8d25,\u8fd8\u539f\u5907\u4efd");
                                    JMFtp.this.pClient.rename(to + JMFtp.temp, to);
                                    JMFtp.this.moveFileFail(jmFtpListener);
                                }
                            }
                        } else if (JMFtp.this.pClient.rename(from, to)) {
                            Log.e((String)JMFtp.this.TAG, (String)"moveFTPFile: \u79fb\u52a8\u6210\u529f");
                            JMFtp.this.moveFileSucees(to, jmFtpListener);
                        } else {
                            Log.e((String)JMFtp.this.TAG, (String)"moveFTPFile: \u79fb\u52a8\u5931\u8d25");
                            JMFtp.this.moveFileFail(jmFtpListener);
                        }
                    } else if (JMFtp.this.pClient.listFiles(to).length > 0) {
                        StringBuilder sb = new StringBuilder(to);
                        sb.insert(to.lastIndexOf("/") + 1, System.currentTimeMillis());
                        String path = sb.toString();
                        if (JMFtp.this.pClient.rename(from, path)) {
                            Log.e((String)JMFtp.this.TAG, (String)"moveFTPFile: \u79fb\u52a8\u6210\u529f");
                            JMFtp.this.moveFileSucees(path, jmFtpListener);
                        } else {
                            Log.e((String)JMFtp.this.TAG, (String)"moveFTPFile: \u79fb\u52a8\u5931\u8d25");
                            JMFtp.this.moveFileFail(jmFtpListener);
                        }
                    } else if (JMFtp.this.pClient.rename(from, to)) {
                        Log.e((String)JMFtp.this.TAG, (String)"moveFTPFile: \u79fb\u52a8\u6210\u529f");
                        JMFtp.this.moveFileSucees(to, jmFtpListener);
                    } else {
                        Log.e((String)JMFtp.this.TAG, (String)"moveFTPFile: \u79fb\u52a8\u5931\u8d25");
                        JMFtp.this.moveFileFail(jmFtpListener);
                    }
                    Log.e((String)JMFtp.this.TAG, (String)("moveFTPFile: " + parentPath));
                    Log.e((String)JMFtp.this.TAG, (String)("moveFTPFile: " + JMFtp.this.pClient.printWorkingDirectory()));
                    JMFtp.this.pClient.rename(from, to);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JMFtp.this.moveFileFail(jmFtpListener);
                }
            }
        });
    }

    @Override
    public void ftpPause(String tag, JMFtpListener jmFtpListener) {
        if (!this.isConnect(jmFtpListener)) {
            jmFtpListener.onFail(810);
            return;
        }
        try {
            FTPDownInfoBean ftpDownInfoBean = this.tagMap.get(tag);
            if (ftpDownInfoBean == null) {
                jmFtpListener.onFail(805);
                return;
            }
            ftpDownInfoBean.isRun = false;
            this.tagMap.put(tag, ftpDownInfoBean);
            jmFtpListener.onSuccess(null);
            Log.e((String)this.TAG, (String)("ftp\u6682\u505c\u64cd\u4f5c : tag: " + tag));
        }
        catch (Exception e) {
            jmFtpListener.onFail(805);
            e.printStackTrace();
        }
    }

    public void ftpDownResume(String url, String locaUrl, String fileName, String tag, JMFtpProcessCallBack downloaCallBack, JMFtpListener jmFtpListener) {
        FTPDownInfoBean ftpDownInfoBean = this.tagMap.get(tag);
        if (ftpDownInfoBean == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!locaUrl.endsWith("/")) {
                locaUrl = locaUrl + "/";
            }
            stringBuffer.append(locaUrl);
            ftpDownInfoBean = new FTPDownInfoBean(url, fileName, stringBuffer.toString(), tag, true, 0, downloaCallBack);
            this.tagMap.put(tag, ftpDownInfoBean);
        }
        ftpDownInfoBean.callBack = downloaCallBack;
        this.ftpResume(tag, jmFtpListener);
    }

    @Override
    public void ftpResume(final String tag, final JMFtpListener jmFtpListener) {
        if (!this.isConnect(jmFtpListener)) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (jmFtpListener != null) {
                        jmFtpListener.onFail(810);
                    }
                }
            });
            return;
        }
        try {
            JMThread.getCachedPool().execute(new Runnable(){

                @Override
                public void run() {
                    FTPDownInfoBean ftpDownInfoBean = (FTPDownInfoBean)JMFtp.this.tagMap.get(tag);
                    if (ftpDownInfoBean == null) {
                        JMThread.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (jmFtpListener != null) {
                                    jmFtpListener.onFail(805);
                                }
                            }
                        });
                        return;
                    }
                    ftpDownInfoBean.isRun = true;
                    JMFtp.this.tagMap.put(tag, ftpDownInfoBean);
                    boolean isResult = JMFtp.this.changeWorkingDirectory(ftpDownInfoBean.url, ftpDownInfoBean.callBack);
                    if (!isResult) {
                        JMThread.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                jmFtpListener.onFail(812);
                            }
                        });
                        return;
                    }
                    if (ftpDownInfoBean.type == 0) {
                        JMFtp.this.downFTPFile(ftpDownInfoBean.url, ftpDownInfoBean.locaUrl, ftpDownInfoBean.fileName, ftpDownInfoBean.tag, ftpDownInfoBean.callBack);
                    } else {
                        JMFtp.this.upload(ftpDownInfoBean.url, ftpDownInfoBean.locaUrl, ftpDownInfoBean.tempFileName, tag, ftpDownInfoBean.callBack);
                    }
                    Log.e((String)JMFtp.this.TAG, (String)("ftp\u6062\u590d\u64cd\u4f5c : tag: " + tag));
                }
            });
        }
        catch (Exception e) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (jmFtpListener != null) {
                        jmFtpListener.onFail(805);
                    }
                }
            });
            e.printStackTrace();
        }
    }

    @Override
    public void closeFTP(final JMFtpListener jmFtpListener) {
        JMThread.getCachedPool().execute(new Runnable(){

            @Override
            public void run() {
                if (JMFtp.this.pClient != null) {
                    try {
                        if (JMFtp.this.pClient.logout()) {
                            JMFtp.this.pClient.disconnect();
                            JMFtp.this.pClient = null;
                            JMThread.runOnUiThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (jmFtpListener != null) {
                                        jmFtpListener.onSuccess(null);
                                    }
                                }
                            });
                        } else {
                            JMThread.runOnUiThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (jmFtpListener != null) {
                                        jmFtpListener.onFail(811);
                                    }
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JMThread.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (jmFtpListener != null) {
                                    jmFtpListener.onFail(811);
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void ftpCancel(String tag, JMFtpListener jmFtpListener) {
        if (!this.isConnect(jmFtpListener)) {
            return;
        }
        this.removeTag(tag);
        jmFtpListener.onSuccess(tag);
    }

    private void moveFileSucees(final String toPath, final JMFtpListener jmFtpListener) {
        JMThread.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                jmFtpListener.onSuccess(toPath);
            }
        });
    }

    private void moveFileFail(final JMFtpListener jmFtpListener) {
        JMThread.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                jmFtpListener.onFail(807);
            }
        });
    }

    @Override
    public void destroy() {
        try {
            for (String key : this.tagMap.keySet()) {
                try {
                    FTPDownInfoBean ftpDownInfoBean = this.tagMap.get(key);
                    ftpDownInfoBean.isRun = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.tagMap.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isConnectSuccess(final JMFtpListener jmFtpListener) {
        if (this.pClient == null || !this.pClient.isConnected()) {
            JMThread.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    jmFtpListener.onFail(810);
                }
            });
            Log.e((String)this.TAG, (String)"FTP\u94fe\u63a5\u65ad\u5f00");
            return false;
        }
        return true;
    }

    private boolean isConnect(JMFtpListener jmFtpListener) {
        if (this.pClient == null || !this.pClient.isConnected()) {
            if (jmFtpListener != null) {
                jmFtpListener.onFail(810);
            }
            Log.e((String)this.TAG, (String)"FTP\u94fe\u63a5\u65ad\u5f00");
            return false;
        }
        return true;
    }

    private boolean changeWorkingDirectory(String path, JMFtpProcessCallBack callBack) {
        try {
            if (this.mode.equals("passive")) {
                this.pClient.enterLocalPassiveMode();
            } else {
                this.pClient.enterLocalActiveMode();
            }
            this.pClient.setFileType(2);
            try {
                this.pClient.changeWorkingDirectory(path);
                Log.e((String)this.TAG, (String)("\u7a7a\u95f4\u8def\u5f84\uff1a" + this.pClient.printWorkingDirectory()));
                return true;
            }
            catch (FTPConnectionClosedException closeException) {
                if (callBack != null) {
                    callBack.onFail(813);
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (FTPConnectionClosedException closeException) {
            if (callBack != null) {
                callBack.onFail(813);
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private long getRemoteFileSize(String remote, String fileName) {
        try {
            FTPFile[] ftpFiles = this.pClient.listFiles(remote);
            if (ftpFiles.length > 0) {
                return ftpFiles[0].getSize();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    private void removeTag(String tag) {
        try {
            FTPDownInfoBean ftpDownInfoBean = this.tagMap.get(tag);
            ftpDownInfoBean.isRun = false;
            this.tagMap.remove(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

