/*
 * Decompiled with CFR 0.152.
 */
package com.jimi.jmsmartftputils.udp;

import android.util.Log;
import com.jimi.jmsmartftputils.bean.socket.ErrorToJsBean;
import com.jimi.jmsmartftputils.listener.JMBaseListener;
import com.jimi.jmsmartftputils.udp.JMUDPSocketImp;
import com.jimi.jmsmartutils.system.JMThread;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class JMUDPSocket
implements JMUDPSocketImp {
    private DatagramSocket socket;
    private InetAddress serverAddress = null;
    private int port;
    private boolean isReceive = true;
    private String TAG = "JMRNFTP";
    private String host;
    private int timeout;

    @Override
    public void configUDPSocket(String host, int port, final int timeout, final JMBaseListener jmBaseListener) {
        try {
            if (timeout <= 0) {
                if (jmBaseListener != null) {
                    jmBaseListener.onFail("601", ErrorToJsBean.getInstance().getErrorJson("601", "\u94fe\u63a5\u5931\u8d25,timeout\u53c2\u6570\u8bbe\u7f6e\u4e0d\u6b63\u786e"));
                }
                return;
            }
            if (host == null || port < 0) {
                if (jmBaseListener != null) {
                    jmBaseListener.onFail("601", ErrorToJsBean.getInstance().getErrorJson("601", "host\u6216\u8005port\u53c2\u6570 \u9519\u8bef"));
                }
                return;
            }
            String[] strUrl = host.split("//");
            host = strUrl.length == 2 ? strUrl[1] : strUrl[0];
            this.isReceive = true;
            this.socket = new DatagramSocket();
            this.socket.setBroadcast(true);
            this.serverAddress = InetAddress.getByName(host);
            this.port = port;
            this.host = host;
            this.timeout = timeout;
            if (jmBaseListener != null) {
                jmBaseListener.onSuccess(null);
            }
        }
        catch (SocketException e) {
            if (jmBaseListener != null) {
                jmBaseListener.onFail("601", ErrorToJsBean.getInstance().getErrorJson("601", "\u94fe\u63a5\u5931\u8d25,\u8bbe\u5907\u901a\u4fe1\u6545\u969c"));
            }
            e.printStackTrace();
        }
        catch (Exception e) {
            if (jmBaseListener != null) {
                jmBaseListener.onFail("601", ErrorToJsBean.getInstance().getErrorJson("601", "\u94fe\u63a5\u5931\u8d25,IO\u5f02\u5e38!"));
            }
            e.printStackTrace();
        }
        JMThread.getCachedPool().execute(new Runnable(){

            @Override
            public void run() {
                while (JMUDPSocket.this.isReceive) {
                    try {
                        byte[] b = new byte[1024];
                        DatagramPacket vPacket = new DatagramPacket(b, b.length);
                        JMUDPSocket.this.socket.setSoTimeout(Math.max(timeout, 5000));
                        JMUDPSocket.this.socket.receive(vPacket);
                        String udpDate = new String(vPacket.getData(), 0, vPacket.getLength());
                        if (jmBaseListener != null) {
                            jmBaseListener.realTimeMessage("listeningUDPSocketCellBack", udpDate);
                        }
                        Log.e((String)JMUDPSocket.this.TAG, (String)("run: udp\u6536\u5230\u56de\u590d" + udpDate));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void send(final String data, int tag, final JMBaseListener jmBaseListener) {
        JMThread.getCachedPool().execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        DatagramPacket datagramPacket = new DatagramPacket(data.getBytes(), data.length(), JMUDPSocket.this.serverAddress, JMUDPSocket.this.port);
                        JMUDPSocket.this.socket.send(datagramPacket);
                        Log.e((String)JMUDPSocket.this.TAG, (String)("run: \u53d1\u9001\u6d88\u606f\u6210\u529f" + data));
                        if (jmBaseListener != null) {
                            jmBaseListener.onSuccess(null);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (jmBaseListener == null) break block3;
                        jmBaseListener.onFail("604", ErrorToJsBean.getInstance().getErrorJson("604", "\u53d1\u9001\u5931\u8d25"));
                    }
                }
            }
        });
    }

    public void send(String data, int tag) {
        try {
            if (this.socket == null) {
                return;
            }
            if (!this.socket.isConnected()) {
                this.isReceive = false;
                Log.e((String)this.TAG, (String)"\u65ad\u5f00\u4e86 socket");
                this.socket.disconnect();
                this.socket.close();
                this.socket = null;
                this.configUDPSocket(this.host, this.port, this.timeout, null);
            }
            Log.e((String)this.TAG, (String)("\u68c0\u6d4b\u8fde\u63a5" + data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeSocket(final JMBaseListener jmBaseListener) {
        this.isReceive = false;
        JMThread.getCachedPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (JMUDPSocket.this.socket != null) {
                        JMUDPSocket.this.socket.disconnect();
                        JMUDPSocket.this.socket.close();
                    }
                    JMUDPSocket.this.socket = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (jmBaseListener != null) {
                    jmBaseListener.onSuccess(null);
                }
            }
        });
    }

    @Override
    public void destroy() {
        this.isReceive = false;
    }
}

