/*
 * Decompiled with CFR 0.152.
 */
package com.jimi.jmsmartftputils.udp;

import android.util.Log;
import com.jimi.jmsmartftputils.bean.socket.ErrorToJsBean;
import com.jimi.jmsmartftputils.listener.JMBaseListener;
import com.jimi.jmsmartftputils.udp.JMUDPSocketImp;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class JMUDPSocket
implements JMUDPSocketImp {
    private DatagramSocket socket;
    private InetAddress serverAddress = null;
    private int port;
    private boolean isReceive = true;
    private String TAG = "JMRNFTP";

    @Override
    public void configUDPSocket(String host, int port, final int timeout, final JMBaseListener jmBaseListener) {
        try {
            if (timeout <= 0) {
                jmBaseListener.onFail("601", ErrorToJsBean.getInstance().getErrorJson("601", "\u94fe\u63a5\u5931\u8d25,timeout\u53c2\u6570\u8bbe\u7f6e\u4e0d\u6b63\u786e"));
                return;
            }
            if (host == null || port < 0) {
                jmBaseListener.onFail("601", ErrorToJsBean.getInstance().getErrorJson("601", "host\u6216\u8005port\u53c2\u6570 \u9519\u8bef"));
                return;
            }
            String[] strUrl = host.split("//");
            host = strUrl.length == 2 ? strUrl[1] : strUrl[0];
            this.isReceive = true;
            this.socket = new DatagramSocket();
            this.socket.setBroadcast(true);
            this.serverAddress = InetAddress.getByName(host);
            this.port = port;
            jmBaseListener.onSuccess(null);
        }
        catch (SocketException e) {
            jmBaseListener.onFail("601", ErrorToJsBean.getInstance().getErrorJson("601", "\u94fe\u63a5\u5931\u8d25,\u8bbe\u5907\u901a\u4fe1\u6545\u969c"));
            e.printStackTrace();
        }
        catch (Exception e) {
            jmBaseListener.onFail("601", ErrorToJsBean.getInstance().getErrorJson("601", "\u94fe\u63a5\u5931\u8d25,IO\u5f02\u5e38!"));
            e.printStackTrace();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (JMUDPSocket.this.isReceive) {
                    try {
                        byte[] b = new byte[1024];
                        DatagramPacket vPacket = new DatagramPacket(b, b.length);
                        JMUDPSocket.this.socket.setSoTimeout(Math.max(timeout, 5000));
                        JMUDPSocket.this.socket.receive(vPacket);
                        String udpDate = new String(vPacket.getData(), 0, vPacket.getLength());
                        jmBaseListener.realTimeMessage("listeningUDPSocketCellBack", udpDate);
                        Log.e((String)JMUDPSocket.this.TAG, (String)("run: udp\u6536\u5230\u56de\u590d" + udpDate));
                    }
                    catch (Exception exception) {}
                }
            }
        }).start();
    }

    @Override
    public void send(final String data, int tag, final JMBaseListener jmBaseListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DatagramPacket datagramPacket = new DatagramPacket(data.getBytes(), data.length(), JMUDPSocket.this.serverAddress, JMUDPSocket.this.port);
                    JMUDPSocket.this.socket.send(datagramPacket);
                    Log.e((String)JMUDPSocket.this.TAG, (String)("run: \u53d1\u9001\u6d88\u606f\u6210\u529f" + data));
                    jmBaseListener.onSuccess(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    jmBaseListener.onFail("604", ErrorToJsBean.getInstance().getErrorJson("604", "\u53d1\u9001\u5931\u8d25"));
                }
            }
        }).start();
    }

    @Override
    public void closeSocket(final JMBaseListener jmBaseListener) {
        this.isReceive = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (JMUDPSocket.this.socket != null) {
                        JMUDPSocket.this.socket.disconnect();
                        JMUDPSocket.this.socket.close();
                    }
                    JMUDPSocket.this.socket = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                jmBaseListener.onSuccess(null);
            }
        }).start();
    }

    @Override
    public void destroy() {
        this.isReceive = false;
    }
}

