/*
 * Decompiled with CFR 0.152.
 */
package com.jimi.jmmonitorview;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import com.jimi.jmmonitorview.JMGLSurfaceViewRenderer;

public class JMGLMonitor
extends GLSurfaceView {
    private JMGLSurfaceViewRenderer mGLSurfaceViewRenderer;
    private boolean mIsBackground = false;

    public JMGLMonitor(Context context) {
        this(context, null);
    }

    public JMGLMonitor(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mGLSurfaceViewRenderer = new JMGLSurfaceViewRenderer(context);
        this.setEGLContextClientVersion(2);
        this.setRenderer(this.mGLSurfaceViewRenderer);
        this.setRenderMode(0);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        super.surfaceDestroyed(holder);
        this.mIsBackground = true;
        if (this.mGLSurfaceViewRenderer != null) {
            this.mGLSurfaceViewRenderer.releaseGL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayYUVData(int w, int h, byte[] y, byte[] u, byte[] v) {
        if (!this.mIsBackground && this.mGLSurfaceViewRenderer != null && w > 0 && h > 0 && y.length > 0 && u.length > 0 && v.length > 0) {
            JMGLSurfaceViewRenderer jMGLSurfaceViewRenderer = this.mGLSurfaceViewRenderer;
            synchronized (jMGLSurfaceViewRenderer) {
                this.mGLSurfaceViewRenderer.displayYUVData(w, h, y, u, v);
                this.requestRender();
            }
        }
    }

    public void displayBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            int size = width * height;
            int[] pixels = new int[size];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            this.rgb2YCbCr420(pixels, width, height);
        }
    }

    public Bitmap snapshot() {
        if (this.mGLSurfaceViewRenderer != null) {
            return this.mGLSurfaceViewRenderer.snapshot();
        }
        return null;
    }

    private void rgb2YCbCr420(int[] pixels, int width, int height) {
        int len = width * height;
        byte[] dataY = new byte[len];
        byte[] dataU = new byte[len / 4];
        byte[] dataV = new byte[len / 4];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int rgb = pixels[i * width + j] & 0xFFFFFF;
                int r = rgb & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb >> 16 & 0xFF;
                int y = (66 * r + 129 * g + 25 * b + 128 >> 8) + 16;
                int u = (112 * r - 94 * g - 18 * b + 128 >> 8) + 128;
                int v = (-38 * r - 74 * g + 112 * b + 128 >> 8) + 128;
                int n = y < 16 ? 16 : (y = y > 255 ? 255 : y);
                int n2 = u < 0 ? 0 : (u = u > 255 ? 255 : u);
                v = v < 0 ? 0 : (v > 255 ? 255 : v);
                dataY[i * width + j] = (byte)y;
                dataU[i / 2 * (width / 2) + j / 2] = (byte)u;
                dataV[i / 2 * (width / 2) + j / 2] = (byte)v;
            }
        }
        this.displayYUVData(width, height, dataY, dataU, dataV);
    }

    public void onResume() {
        super.onResume();
    }

    public void onResumeGl() {
        this.mIsBackground = false;
        if (this.mGLSurfaceViewRenderer != null) {
            this.mGLSurfaceViewRenderer.initGL();
        }
    }

    public void onPauseGl() {
        this.mIsBackground = true;
    }
}

