package com.jimi.jmmonitorview;

import android.util.Log;

public class JMMonitorViewJni {
    static {
        try {
            System.loadLibrary("JMMonitorView");
        } catch (UnsatisfiedLinkError ule) {
            Log.d("JMLog", ule.getMessage());
        }
    }

    /*初始化OpenGL库
    * */
    public static native void Init();

    /*释放OpenGL库*/
    public static native void Release();

    /*
    * 加载YUV420数据
    * */
    public static native void LoadYUVData(int width, int height, byte[] y, byte[] u, byte[] v);

    /*
    * 刷新
    * */
    public static native void Render(int width, int height);

    /*
    * 更新视图大小
    * */
    public static native void UpdateSize(int width, int height);

}
