package com.jimi.jmmonitorview;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

import java.nio.ByteBuffer;

public class JMMonitor extends SurfaceView implements SurfaceHolder.Callback{
    private Context mContext;
    private int mMaxFrameBufSize = 1920 * 1920;
    private ByteBuffer dataBuffer = ByteBuffer.wrap(new byte[mMaxFrameBufSize]);
    private Bitmap mLastFrame;
    private int mCurVideoWidth = 0;
    private int mCurVideoHeight = 0;
    private Rect mRectCanvas = new Rect();
    private Rect mRectMonitor = new Rect();
    private boolean mbFitXY = false;
    private Configuration mConfiguration;

    public JMMonitor(Context context, AttributeSet attrs) {
        super(context);

        this.mContext = context;
    }

    @Override
    public void surfaceCreated(SurfaceHolder surfaceHolder) {

    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mRectCanvas.set(0, 0, width, height);
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {

    }

    public void displayRgb24Data(Byte[] rgbData, int width, int height) {
        Bitmap bmp = Bitmap.createBitmap(width, height, Bitmap.Config.RGB_565);
        dataBuffer.rewind();
        bmp.copyPixelsFromBuffer(dataBuffer);

//        synchronized (this) {
//            this.mLastFrame = bmp;
//
//            if ((bmp.getWidth() > 0) && (bmp.getHeight() > 0) && (this.mRectMonitor.right > 0)
//                    && (this.mRectMonitor.bottom > 0)
//                    && ((bmp.getWidth() != this.mCurVideoWidth) || (bmp.getHeight() != this.mCurVideoHeight))) {
//                this.mCurVideoWidth = bmp.getWidth();
//                this.mCurVideoHeight = bmp.getHeight();
//
//                this.mRectCanvas.set(0, 0, this.mRectMonitor.right, this.mRectMonitor.bottom);
//
//                if (!this.mbFitXY) {
//                    if (this.mRectMonitor.bottom - this.mRectMonitor.top < this.mRectMonitor.right
//                            - this.mRectMonitor.left) {
//                        double ratio = (this.mCurVideoWidth * 4) / (this.mCurVideoHeight * 3);
//                        // this.mRectCanvas.right = ((int)
//                        // (this.mRectMonitor.bottom * ratio)) - 100;
//
//                        // if (isFullScreen) {
//                        // this.mRectCanvas.right = getWidth();
//                        // this.mRectCanvas.offset((this.mRectMonitor.right
//                        // - this.mRectCanvas.right) / 2, 0);
//                        // } else {
//                        if (mConfiguration.orientation == Configuration.ORIENTATION_LANDSCAPE) {
//                            this.mRectCanvas.right = getWidth();
//                            this.mRectCanvas.offset((this.mRectMonitor.right - this.mRectCanvas.right) / 2, 0);
//                        } else if (mConfiguration.orientation == Configuration.ORIENTATION_PORTRAIT) {
//                            if (isPlayBack()) {
//                                this.mRectCanvas.bottom = getHeight();
//                            } else {
//                                this.mRectCanvas.bottom = ((int) (this.mRectMonitor.right / ratio));
//                            }
//                            this.mRectCanvas.offset(0, (this.mRectMonitor.bottom - this.mRectCanvas.bottom) / 2);
//                        }
//                        // }
//                    } else {
//                        double ratio = (this.mCurVideoWidth * 4) / (this.mCurVideoHeight * 3);
//                        if (isPlayBack()) {
//                            this.mRectCanvas.bottom = getHeight();
//                        } else {
//                            this.mRectCanvas.bottom = ((int) (this.mRectMonitor.right / ratio));
//                        }
//                        this.mRectCanvas.offset(0, (this.mRectMonitor.bottom - this.mRectCanvas.bottom) / 2);
//                    }
//                }
//
//                this.vLeft = this.mRectCanvas.left;
//                this.vTop = this.mRectCanvas.top;
//                this.vRight = this.mRectCanvas.right;
//                this.vBottom = this.mRectCanvas.bottom;
//
//                if (cfg.orientation == Configuration.ORIENTATION_PORTRAIT) {
//                    int maxWidth = (this.vRight - this.vLeft) * 3;// 2160
//                    int maxHeight = (this.vBottom - this.vTop) * 3;// 1080
//
//                    int scaledWidth = (int) ((this.vRight - this.vLeft) * this.mCurrentScale);// 1224
//                    int scaledHeight = (int) ((this.vBottom - this.vTop) * this.mCurrentScale);// 612
//                    int origWidth = this.vRight - this.vLeft;// 720
//                    int origHeight = this.vBottom - this.vTop;// 360
//
//                    int l = (int) (this.mRectMonitor.width() / 2
//                            - (this.mRectMonitor.width() / 2 - this.mRectCanvas.left) * mCurrentScale);// -252
//                    int t = (int) (this.mRectMonitor.height() / 2
//                            - (this.mRectMonitor.height() / 2 - this.mRectCanvas.top) * mCurrentScale);// -16
//                    int r = l + scaledWidth;// 972
//                    int b = t + scaledHeight;// 596
//
//                    if ((scaledWidth <= origWidth) || (scaledHeight <= origHeight)) {
//                        l = this.vLeft;
//                        t = this.vTop;
//                        r = this.vRight;
//                        b = this.vBottom;
//                    } else if ((scaledWidth >= maxWidth) || (scaledHeight >= maxHeight)) {
//                        l = this.mRectCanvas.left;
//                        t = this.mRectCanvas.top;
//                        r = l + maxWidth;
//                        b = t + maxHeight;
//                    }
//                    this.mRectCanvas.set(l, t, r, b);
//
//                    mPinchedMode = 0;
//
//                    if (isFullScreen) {
//                        float mH = (mRectCanvas.bottom - mRectCanvas.top) * 1.0f / 1.6f;
//                        mCurrentScale = getHeight() * 1.0f / mH;
//                        Log.i(TAG, "mCurrentScale:" + mCurrentScale);
//
//                        this.mRectCanvas.set(mRectCanvas.left, 0, mRectCanvas.right, getHeight());
//                    }
//                } else {
//                    mCurrentScale = 1.0f;
//                }
//            }
//        }
    }
}
