package com.jimi.jimivideoplayer.log;

import android.os.Environment;
import android.util.Log;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import java.io.File;
import java.io.IOException;

import de.mindpipe.android.logging.log4j.LogConfigurator;

public class JMLogUtil {
    static {
        try {
            System.loadLibrary("avformat");
            System.loadLibrary("avfilter");
            System.loadLibrary("postproc");
            System.loadLibrary("avcodec");
            System.loadLibrary("swscale");
            System.loadLibrary("swresample");
            System.loadLibrary("avutil");
            System.loadLibrary("avdevice");
        } catch (UnsatisfiedLinkError ule) {
        }

        try {
            System.loadLibrary("JimiVideoPlayer");
        } catch (UnsatisfiedLinkError ule) {
            Log.e("JMVideo", "loadLibrary libJimiVideoPusher failed!");
        }
    }

    private static String TAG = "JMVideo";

    private static Logger gLogger = null;
    private static boolean isDebug = true;      //日志输出开关（默认开启）
    private static boolean m_bIsSave = false;   //是否保存日志到内置SD卡
    private static boolean isFirstRun = true;
    private static String mImei = null;
    private static String mPathDic = null;

    /**
     * 设置日志的tag标签，默认"JMVideo"
     *
     * @param tag 日志Tag
     * */
    public static void setTAG(String tag) {
        TAG = tag;
    }

    /**
     * 是否是DEBUG模式，在DEBUG模式下日志才会输出和保存
     *
     * @param isDebug 是否只有在DEBUG模式下才保存
     * */
    public static void setIsDebug(boolean isDebug) {
        JMLogUtil.isDebug = isDebug;
    }

    /**
     * 是否保存日志
     *
     * @param need 是否需要保持日志
     * */
    public static void save(boolean need) {
        m_bIsSave = need;
    }

    /**
     * 设置IMEI，将会以文本名字_IMEI.log形式作为日志文件名
     *
     * @param imei 设备IMEI
     * */
    public static void setIMEI(String imei) {
        mImei = imei;
        isFirstRun = true;
    }

    /**
     * 设置IMEI，将会以文本名字_IMEI形式作为日志文件名
     *
     * @param pathDic 保存日志的文件夹路径
     * */
    public static void setSavePathDic(String pathDic) {
        mPathDic = pathDic;
    }

    private static Logger getLoger(String tag) {
        if (isFirstRun) {
            JMLogUtilJni.Init();

            LogConfigurator logConfigurator = new LogConfigurator();
            File filePath = new File(getLogFilePath());
            if (!filePath.exists()) {
                filePath.mkdirs();
            }

            String fileName = getLogFilePath() + "JMVideoPlayer.log";
            if (mImei != null) {
                fileName = getLogFilePath() + "JMVideoPlayer_" + mImei + ".log";
            }

            File file = new File(fileName);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            logConfigurator.setFileName(fileName);
            logConfigurator.setRootLevel(Level.DEBUG);
            logConfigurator.setLevel("org.apache", Level.ERROR);
            logConfigurator.setMaxFileSize(1024 * 1024 * 10);   //文件的最大大小:10M
            logConfigurator.setMaxBackupSize(5);    //最多文件个数:5个
            logConfigurator.configure();
            isFirstRun = false;
        }

        if (gLogger == null) {
            gLogger = Logger.getLogger(tag);
        }

        if (gLogger != null && !tag.equals(gLogger.getName())) {
            gLogger = Logger.getLogger(tag);
        }
        return gLogger;
    }

    private static final String getLogFilePath() {
        if (mPathDic != null) {
            if (mPathDic.substring(mPathDic.length()-1) != "/") {
                mPathDic +=  File.separator;
            }
            return mPathDic;
        }
        return Environment.getExternalStorageDirectory().getAbsolutePath() + "/JMVideoPlayer" + File.separator;
    }

    private static boolean isStrEmpty(String str) {
        if (str == null || str.equals("")) {
            return true;
        }
        return false;
    }

    public static void v(String tag, String msg) {
        if (isDebug && msg != null) {
            if (isStrEmpty(tag)) {
                tag = TAG;
            }

            Log.v(tag, msg);
        }
    }

    public static void v(String msg) {
        v(TAG, msg);
    }

    public static void d(String tag, String msg) {
        if (isDebug && msg != null) {
            if (isStrEmpty(tag)) {
                tag = TAG;
            }

            if (m_bIsSave) {
                getLoger(tag).debug(msg);
            } else {
                Log.d(tag, msg);
            }
        }
    }

    public static void d(String msg) {
        d(TAG, msg);
    }

    public static void i(String tag, String msg) {
        if (isDebug && msg != null) {
            if (isStrEmpty(tag)) {
                tag = TAG;
            }

            if (m_bIsSave) {
                getLoger(tag).info(msg);
            } else {
                Log.i(tag, msg);
            }
        }
    }

    public static void i(String msg) {
        i(TAG, msg);
    }

    public static void w(String tag, String msg) {
        if (isDebug && msg != null) {
            if (isStrEmpty(tag)) {
                tag = TAG;
            }

            if (m_bIsSave) {
                getLoger(tag).warn(msg);
            } else {
                Log.w(tag, msg);
            }
        }
    }

    public static void w(String msg) {
        w(TAG, msg);
    }

    public static void e(String tag, String msg) {
        if (isDebug && msg != null) {
            if (isStrEmpty(tag)) {
                tag = TAG;
            }

            if (m_bIsSave) {
                getLoger(tag).error(msg);
            } else {
                Log.e(tag, msg);
            }
        }
    }

    public static void e(String msg) {
        e(TAG, msg);
    }

    public static void log(String msg) {
        JMLogUtil.e(TAG, msg);
    }

    public static void log(int prio, String msg) {
        if (prio == 2) {  //ANDROID_LOG_VERBOSE
            v(msg);
        } else if (prio == 3) {
            d(msg);
        } else if (prio == 4) {
            i(msg);
        } else if (prio == 5) {
            w(msg);
        } else if (prio == 6) {
            e(msg);
        } else {
            d(msg);
        }
    }

    public static void printBytes(String logHint, byte[] buffer) {
        String finalString = logHint;
        for (int i = 0; i < buffer.length; i++) {
            String hex = Integer.toHexString(buffer[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }

            if (finalString == null) {
                finalString = hex;
            } else {
                finalString += (" " + hex);
            }
        }
        JMLogUtil.d(finalString);
    }
}
