package com.jimi.jimivideoplayer;

public interface JMSwitchCameraListener {

    /**
     * 摄像机切换监听回调
     *
     * @param success 是否成功
     * @param url 切换成功之后的推流地址
     * @param code 服务器错误代码，0：成功，-1:回复数据为空，-2:回复数据非Json字符串，-3:异常数据，-4: 设备拒绝切换，
     *             其他：参考服务器代码，比如228：为设备不在线，
     *             其他状态遵循JMHttpRequestTaskListener的接口onCustomMsgHandler中的statusCode
     * @param errMsg 服务器错误提示字符串
     */
    public void onSwitchCameraHandler(boolean success, String url, long code, String errMsg);
}