package com.jimi.jimivideoplayer;

import com.jimi.jimivideoplayer.log.JMLogUtil;

import java.util.List;
import java.util.Map;

public class JMVideoStreamPlayerJni {

    public static native String GetVersionString();

    /*初始化SDK*/
    public static native boolean Initialize(boolean bAuto);

    /*释放SDK*/
    public static native boolean DeInitialize(boolean bAuto);

    /*已初始化*/
    public static native boolean IsInitialized();

    /*配置开发者信息*/
    public static native boolean ConfigKey(String sKey, String sSecret, String sToken);

    /*自定义配置Web服务器地址及端口*/
    public static native boolean ConfigWebServer(String sHosts, int port, double timeoutInterval);

    /*自定义配置网关服务器地址及端口*/
    public static native boolean ConfigGatewayServer(String sHosts, int port, double heartbeatTime);

    /*
     *----------------------------------------------------------------------------------------------------
     */

    /* 初始化内部SDK
     * @param key KEY
     * @param secret SECRET
     * @param token Token,为空时默认为"123456"
     * @param imei 设备IMEI
     * @param player JMVideoStreamPlayer
     * @param listener JMVideoStreamPlayerListener
     * */
    public static native void Init(String key, String secret, String token, String imei, String appID, JMVideoStreamPlayer player, JMVideoStreamPlayerListener listener);

    public static native void InitWithIMEI(String imei, String appID, JMVideoStreamPlayer player, JMVideoStreamPlayerListener listener);

    /*
     * 释放内部SDK
     * */
    public static native void Release();

    /*开始直播*/
    public static native void StartPlayLive();

    /*开始回放，视频文件列表，比如列表："2018-08-29-09-21-27_30268.mp4", "2018-08-29-09-25-59_35532.mp4"*/
    public static native void StartPlayback(List<String> fileNameList);

    /*开始播放，用URL进行播放*/
    public static native void StartPlay(String url);

    /*停止直播、回放、URL播放等*/
    public static native void StopPlay();

    /*正在播放*/
    public static native boolean IsPlaying();

    /*开始对讲*/
    public static native void StartTalk();

    /*停止对讲*/
    public static native void StopTalk();

    /*发送音频(对讲)数据*/
    public static native void SendTalkData(byte[] data);

    /*发送自定义消息(异步)*/
    public static native long SendAsyncRequest(String[] paraArray, JMHttpRequestTaskListener onHttpRequestTaskListener);

    /*取消自定义消息请求，一旦发送完成，则取消无效*/
    public static native void CancelAsyncRequest(long task);

    /*组装(生成)自定义消息句柄*/
    public static native long BuildSyncRequest(String[] paraArray);

    /*开始自定义消息(同步)*/
    public static native String StartSyncRequest(long task);

    /*取消自定义消息(同步)*/
    public static native void CancelSyncRequest(long task);

    /*开始录制*/
    public static native void StartRecording(String filePath);

    /*停止录制*/
    public static native void StopRecording();

    /*是否正在录制*/
    public static native boolean IsRecording();

    /*获取视频录制时长*/
    public static native long GetRecordingRuration();

    /*获取视频录制时长*/
    public static native int GetOnlineCount();

    /*开始网关服务(默认开始)*/
    public static native void StartGatewayServer();

    /*停止网关服务*/
    public static native void StopGatewayServer();

    public static native void StartWebServer();

    public static native void StopWebServer();

    /*设置硬件解码(默认开始)*/
    public static native void SetHWDecodeState(boolean enable);

    /*获取硬件解码状态*/
    public static native boolean GetHWDecodeState();

    /*设置是否静音(默认关闭)*/
    public static native void SetMute(boolean mute);

    /*获取静音状态*/
    public static native boolean GetMute();

    /*设置播放允许的最大缓冲时间*/
    public static native void SetDelayMaxTime(double delayMaxTime);

    /*获取播放允许的最大缓冲时间*/
    public static native double GetDelayMaxTime();

    /*获取视频的时间搓*/
    public static native long GetVideoTimestamp();

    public static native void SetHttpTimeoutInterval(double time);

    public static native double GetHttpTimeoutInterval();

    public static native void SetDenoiseLevel(int level);
}
