/*
 * Decompiled with CFR 0.152.
 */
package com.jimi.jimivideoplayer.log;

import android.os.Environment;
import android.util.Log;
import com.jimi.jimivideoplayer.log.JMLogUtilJni;
import de.mindpipe.android.logging.log4j.LogConfigurator;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class JMLogUtil {
    private static String TAG;
    private static Logger gLogger;
    private static boolean isDebug;
    private static boolean m_bIsSave;
    private static boolean isFirstRun;
    private static String mImei;
    private static String mPathDic;

    public static void setTAG(String tag) {
        TAG = tag;
    }

    public static void setIsDebug(boolean isDebug) {
        JMLogUtil.isDebug = isDebug;
    }

    public static void save(boolean need) {
        m_bIsSave = need;
    }

    public static void setIMEI(String imei) {
        mImei = imei;
        isFirstRun = true;
    }

    public static void setSavePathDic(String pathDic) {
        mPathDic = pathDic;
    }

    private static Logger getLoger(String tag) {
        if (isFirstRun) {
            File file;
            JMLogUtilJni.Init();
            LogConfigurator logConfigurator = new LogConfigurator();
            File filePath = new File(JMLogUtil.getLogFilePath());
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            String fileName = JMLogUtil.getLogFilePath() + "JMVideoPlayer.log";
            if (mImei != null) {
                fileName = JMLogUtil.getLogFilePath() + "JMVideoPlayer_" + mImei + ".log";
            }
            if (!(file = new File(fileName)).exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            logConfigurator.setFileName(fileName);
            logConfigurator.setRootLevel(Level.DEBUG);
            logConfigurator.setLevel("org.apache", Level.ERROR);
            logConfigurator.setMaxFileSize(0xA00000L);
            logConfigurator.setMaxBackupSize(5);
            logConfigurator.configure();
            isFirstRun = false;
        }
        if (gLogger == null) {
            gLogger = Logger.getLogger((String)tag);
        }
        if (gLogger != null && !tag.equals(gLogger.getName())) {
            gLogger = Logger.getLogger((String)tag);
        }
        return gLogger;
    }

    private static final String getLogFilePath() {
        if (mPathDic != null) {
            if (mPathDic.substring(mPathDic.length() - 1) != "/") {
                mPathDic = mPathDic + File.separator;
            }
            return mPathDic;
        }
        return Environment.getExternalStorageDirectory().getAbsolutePath() + "/JMVideoPlayer" + File.separator;
    }

    private static boolean isStrEmpty(String str) {
        return str == null || str.equals("");
    }

    public static void v(String tag, String msg) {
        if (isDebug && msg != null) {
            if (JMLogUtil.isStrEmpty(tag)) {
                tag = TAG;
            }
            Log.v((String)tag, (String)msg);
        }
    }

    public static void v(String msg) {
        JMLogUtil.v(TAG, msg);
    }

    public static void d(String tag, String msg) {
        if (isDebug && msg != null) {
            if (JMLogUtil.isStrEmpty(tag)) {
                tag = TAG;
            }
            if (m_bIsSave) {
                JMLogUtil.getLoger(tag).debug((Object)msg);
            } else {
                Log.d((String)tag, (String)msg);
            }
        }
    }

    public static void d(String msg) {
        JMLogUtil.d(TAG, msg);
    }

    public static void i(String tag, String msg) {
        if (isDebug && msg != null) {
            if (JMLogUtil.isStrEmpty(tag)) {
                tag = TAG;
            }
            if (m_bIsSave) {
                JMLogUtil.getLoger(tag).info((Object)msg);
            } else {
                Log.i((String)tag, (String)msg);
            }
        }
    }

    public static void i(String msg) {
        JMLogUtil.i(TAG, msg);
    }

    public static void w(String tag, String msg) {
        if (isDebug && msg != null) {
            if (JMLogUtil.isStrEmpty(tag)) {
                tag = TAG;
            }
            if (m_bIsSave) {
                JMLogUtil.getLoger(tag).warn((Object)msg);
            } else {
                Log.w((String)tag, (String)msg);
            }
        }
    }

    public static void w(String msg) {
        JMLogUtil.w(TAG, msg);
    }

    public static void e(String tag, String msg) {
        if (isDebug && msg != null) {
            if (JMLogUtil.isStrEmpty(tag)) {
                tag = TAG;
            }
            if (m_bIsSave) {
                JMLogUtil.getLoger(tag).error((Object)msg);
            } else {
                Log.e((String)tag, (String)msg);
            }
        }
    }

    public static void e(String msg) {
        JMLogUtil.e(TAG, msg);
    }

    public static void log(String msg) {
        JMLogUtil.e(TAG, msg);
    }

    public static void log(int prio, String msg) {
        if (prio == 2) {
            JMLogUtil.v(msg);
        } else if (prio == 3) {
            JMLogUtil.d(msg);
        } else if (prio == 4) {
            JMLogUtil.i(msg);
        } else if (prio == 5) {
            JMLogUtil.w(msg);
        } else if (prio == 6) {
            JMLogUtil.e(msg);
        } else {
            JMLogUtil.d(msg);
        }
    }

    public static void printBytes(String logHint, byte[] buffer) {
        String finalString = logHint;
        for (int i = 0; i < buffer.length; ++i) {
            String hex = Integer.toHexString(buffer[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            finalString = finalString == null ? hex : finalString + " " + hex;
        }
        JMLogUtil.d(finalString);
    }

    static {
        try {
            System.loadLibrary("avformat");
            System.loadLibrary("avfilter");
            System.loadLibrary("postproc");
            System.loadLibrary("avcodec");
            System.loadLibrary("swscale");
            System.loadLibrary("swresample");
            System.loadLibrary("avutil");
            System.loadLibrary("avdevice");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        try {
            System.loadLibrary("JimiVideoPlayer");
        }
        catch (UnsatisfiedLinkError ule) {
            Log.e((String)"JMVideo", (String)"loadLibrary libJimiVideoPusher failed!");
        }
        TAG = "JMVideo";
        gLogger = null;
        isDebug = true;
        m_bIsSave = false;
        isFirstRun = true;
        mImei = null;
        mPathDic = null;
    }
}

