/*
 * Decompiled with CFR 0.152.
 */
package com.jimi.jimivideoplayer.encoder;

import android.annotation.SuppressLint;
import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaFormat;
import com.jimi.jimivideoplayer.JMVideoStreamPlayerJni;
import com.jimi.jimivideoplayer.log.JMLogUtil;
import java.io.IOException;
import java.nio.ByteBuffer;

public class HWAACEncoder
implements Runnable {
    public static final String MIME_TYPE = "audio/mp4a-latm";
    public static final int SAMPLE_RATE = 8000;
    public static final int BIT_RATE = 128000;
    public static final int CHANNEL_CONFIG = 16;
    public static final int AUDIO_FORMAT = 2;
    public static MediaFormat audioOutputFormat = null;
    private static final int SAMPLES_PER_FRAME = 1024;
    private static final String TAG = "HWAACEncoder";
    private AudioRecord audioRecoder;
    private MediaCodec mAudioEncoder;
    private boolean isRun = false;
    private Thread thread;

    public boolean isRun() {
        return this.isRun;
    }

    public void startEncoder() {
        this.isRun = true;
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @SuppressLint(value={"NewApi"})
    public void stopEncoder() {
        if (!this.isRun) {
            return;
        }
        this.isRun = false;
        if (this.thread != null) {
            try {
                this.thread.join();
                this.thread = null;
                JMLogUtil.i("HWAACEncoder has been released");
            }
            catch (InterruptedException e) {
                JMLogUtil.e(TAG, " stopEncoder " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void initAudioCodec() {
        int minBufferSize = AudioRecord.getMinBufferSize((int)8000, (int)16, (int)2);
        JMLogUtil.d(TAG, "audio init minimum buffer size : " + minBufferSize);
        int buffer_size = 10240;
        if (buffer_size < minBufferSize) {
            buffer_size = (minBufferSize / 1024 + 1) * 1024 * 2;
        }
        MediaFormat audioFormat = new MediaFormat();
        audioFormat.setString("mime", MIME_TYPE);
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("sample-rate", 8000);
        audioFormat.setInteger("channel-count", 1);
        audioFormat.setInteger("bitrate", 128000);
        audioFormat.setInteger("max-input-size", 16384);
        try {
            this.mAudioEncoder = MediaCodec.createEncoderByType((String)MIME_TYPE);
            this.mAudioEncoder.configure(audioFormat, null, null, 1);
            this.mAudioEncoder.start();
            this.audioRecoder = new AudioRecord(1, 8000, 16, 2, buffer_size);
            this.audioRecoder.startRecording();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        long TimeUsPerFrame = 20000L;
        this.initAudioCodec();
        long lastEncodedAudioTimeStamp = 0L;
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        block0: while (this.isRun) {
            if (this.audioRecoder == null) continue;
            ByteBuffer[] inputBuffers = this.mAudioEncoder.getInputBuffers();
            int inputBufferIndex = this.mAudioEncoder.dequeueInputBuffer(20L);
            if (inputBufferIndex < 0) continue;
            ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
            inputBuffer.clear();
            long presentationTimeNs = System.nanoTime();
            int inputLength = this.audioRecoder.read(inputBuffer, 320);
            if (inputLength == -2 || inputLength == -3) {
                JMLogUtil.e(TAG, "Audio read error!!!");
            }
            this.mAudioEncoder.queueInputBuffer(inputBufferIndex, 0, inputLength, presentationTimeNs / 1000L, 0);
            ByteBuffer[] outputBuffers = this.mAudioEncoder.getOutputBuffers();
            while (this.isRun) {
                int TIMEOUT_USEC = 20;
                int encoderStatus = this.mAudioEncoder.dequeueOutputBuffer(bufferInfo, 20L);
                if (encoderStatus == -1) continue block0;
                if (encoderStatus == -3) {
                    outputBuffers = this.mAudioEncoder.getOutputBuffers();
                    continue;
                }
                if (encoderStatus == -2) {
                    audioOutputFormat = this.mAudioEncoder.getOutputFormat();
                    continue;
                }
                if (encoderStatus < 0) {
                    JMLogUtil.w(TAG, "unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus);
                    continue;
                }
                ByteBuffer encodedData = outputBuffers[encoderStatus];
                if (encodedData == null) {
                    throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                }
                if ((bufferInfo.flags & 2) != 0) {
                    bufferInfo.size = 0;
                }
                if (bufferInfo.size != 0) {
                    encodedData.position(bufferInfo.offset);
                    encodedData.limit(bufferInfo.offset + bufferInfo.size);
                    byte[] tempBytes = new byte[bufferInfo.size];
                    encodedData.get(tempBytes);
                    if (lastEncodedAudioTimeStamp == 0L) {
                        bufferInfo.presentationTimeUs = 0L;
                        lastEncodedAudioTimeStamp = 20000L;
                    } else {
                        lastEncodedAudioTimeStamp = bufferInfo.presentationTimeUs = lastEncodedAudioTimeStamp + 20000L;
                    }
                    JMVideoStreamPlayerJni.SendTalkData(tempBytes);
                }
                this.mAudioEncoder.releaseOutputBuffer(encoderStatus, false);
            }
        }
        if (this.audioRecoder != null) {
            this.audioRecoder.stop();
            this.audioRecoder.release();
            this.audioRecoder = null;
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.stop();
            this.mAudioEncoder.release();
            this.mAudioEncoder = null;
        }
    }
}

