/*
 * Decompiled with CFR 0.152.
 */
package com.jimi.jimivideoplayer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.media.AudioTrack;
import android.os.PowerManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.jimi.jimivideoplayer.JMHttpRequestTaskListener;
import com.jimi.jimivideoplayer.JMSwitchCameraListener;
import com.jimi.jimivideoplayer.JMVideoStreamPlayerJni;
import com.jimi.jimivideoplayer.JMVideoStreamPlayerListener;
import com.jimi.jimivideoplayer.bean.FrameInfo;
import com.jimi.jimivideoplayer.encoder.HWAACEncoder;
import com.jimi.jimivideoplayer.log.JMLogUtil;
import com.jimi.jimivideoplayer.opengl.GLMonitor;
import com.jimi.jimivideoplayer.util.CommonUtils;
import com.jimi.jimivideoplayer.util.MD5Util;
import com.jimi.jimivideoplayer.util.MediaCodecUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class JMVideoStreamPlayer {
    private Context mContext;
    private GLMonitor mGLMonitor = null;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mStayAwake;
    private JMVideoStreamPlayerListener mExternalListener = null;
    private HWAACEncoder mHWAACEncoder = null;
    private int mAudioSampleRate = 44100;
    private int mAudioChannels = 1;
    private int mPlayStatus = 0;
    private int mTalkStatus = 0;
    private boolean mIsSupportHWDecode = true;
    private AudioTrack mAudioTrack = null;
    private String mIMEI = null;
    private long mCameraSwitchTask = 0L;
    private JMSwitchCameraListener mSwitchCameraListener = null;
    private boolean mCameraSwitchAutoPlay = true;
    public static int mVideoWidth;
    public static int mVideoHeight;
    private JMVideoStreamPlayerListener mSelfListener = new JMVideoStreamPlayerListener(){

        @Override
        public void onStreamPlayerPlayStatus(int status, String errStr) {
            JMVideoStreamPlayer.this.mPlayStatus = status;
            if (JMVideoStreamPlayer.this.mExternalListener != null) {
                JMVideoStreamPlayer.this.mExternalListener.onStreamPlayerPlayStatus(status, errStr);
            }
        }

        @Override
        public void onStreamPlayerTalkStatus(int status, String errStr) {
            JMVideoStreamPlayer.this.mTalkStatus = status;
            if (JMVideoStreamPlayer.this.mExternalListener != null) {
                JMVideoStreamPlayer.this.mExternalListener.onStreamPlayerTalkStatus(status, errStr);
            }
        }

        @Override
        public void onStreamPlayerRecordStatus(int status, String filePath) {
            if (JMVideoStreamPlayer.this.mExternalListener != null) {
                JMVideoStreamPlayer.this.mExternalListener.onStreamPlayerRecordStatus(status, filePath);
            }
        }

        @Override
        public void onStreamPlayerReceiveFrameInfo(FrameInfo frameInfo) {
            mVideoWidth = frameInfo.videoWidth;
            mVideoHeight = frameInfo.videoHeight;
            if (JMVideoStreamPlayer.this.mExternalListener != null) {
                JMVideoStreamPlayer.this.mExternalListener.onStreamPlayerReceiveFrameInfo(frameInfo);
            }
        }

        @Override
        public void onServerReceiveData(String data, int type) {
            if (JMVideoStreamPlayer.this.mExternalListener != null) {
                JMVideoStreamPlayer.this.mExternalListener.onServerReceiveData(data, type);
            }
        }
    };

    public static String GetJarVersionString() {
        String value = "1.4.4";
        return value;
    }

    public static String GetSoVersionString() {
        return JMVideoStreamPlayerJni.GetVersionString();
    }

    public static boolean Initialize() {
        return JMVideoStreamPlayerJni.Initialize(false);
    }

    public static boolean DeInitialize() {
        return JMVideoStreamPlayerJni.DeInitialize(false);
    }

    public static boolean Config(String key, String secret, String token) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            token = "123456";
        }
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)secret)) {
            JMLogUtil.e("This has a null value, Key:" + key + " Secret:" + secret);
            return false;
        }
        return JMVideoStreamPlayerJni.ConfigKey(key, secret, token);
    }

    public static boolean ConfigWebServer(String sHosts, int port, double timeoutInterval) {
        if (TextUtils.isEmpty((CharSequence)sHosts)) {
            return false;
        }
        return JMVideoStreamPlayerJni.ConfigWebServer(sHosts, port, timeoutInterval);
    }

    public static boolean ConfigGatewayServer(String sHosts, int port, double heartbeatTime) {
        if (TextUtils.isEmpty((CharSequence)sHosts)) {
            return false;
        }
        return JMVideoStreamPlayerJni.ConfigGatewayServer(sHosts, port, heartbeatTime);
    }

    public JMVideoStreamPlayer(Context context, String imei, JMVideoStreamPlayerListener listener) {
        if (context == null) {
            return;
        }
        this.mContext = context;
        this.mExternalListener = listener;
        this.mIMEI = imei;
        JMLogUtil.i("SDK Version:" + JMVideoStreamPlayer.GetJarVersionString() + ", So Version:" + JMVideoStreamPlayer.GetSoVersionString());
        if (!JMVideoStreamPlayerJni.IsInitialized()) {
            JMLogUtil.w("JimiVideoPlayer(SDK) is not initialized");
        } else if (!TextUtils.isEmpty((CharSequence)imei)) {
            JMVideoStreamPlayerJni.InitWithIMEI(imei, this.getPhoneIMEI(context), this, this.mSelfListener);
            this.mIsSupportHWDecode = MediaCodecUtil.isSupportMediaCodecHardDecoder("video/avc");
            if (!this.mIsSupportHWDecode) {
                JMVideoStreamPlayerJni.SetHWDecodeState(false);
            }
        } else {
            JMLogUtil.e("This has a null value, IMEI:" + imei);
        }
    }

    public JMVideoStreamPlayer(Context context, String key, String secret, String imei, String token, JMVideoStreamPlayerListener listener) {
        if (context == null) {
            return;
        }
        this.mContext = context;
        this.mExternalListener = listener;
        this.mIMEI = imei;
        JMLogUtil.i("SDK Version:" + JMVideoStreamPlayer.GetJarVersionString() + ", So Version:" + JMVideoStreamPlayer.GetSoVersionString());
        if (!(TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)secret) || TextUtils.isEmpty((CharSequence)imei))) {
            if (TextUtils.isEmpty((CharSequence)token)) {
                token = "123456";
            }
            JMVideoStreamPlayerJni.Init(key, secret, token, imei, this.getPhoneIMEI(context), this, this.mSelfListener);
            this.mIsSupportHWDecode = MediaCodecUtil.isSupportMediaCodecHardDecoder("video/avc");
            if (!this.mIsSupportHWDecode) {
                JMVideoStreamPlayerJni.SetHWDecodeState(false);
            }
        } else {
            JMLogUtil.e("This has a null value, Key:" + key + " Secret:" + secret + " IMEI:" + imei);
        }
    }

    public void release() {
        this.releaseAudioRecord();
        JMVideoStreamPlayerJni.Release();
        this.stopAudioPlayer();
        JMLogUtil.w("JMVideoStreamPlayer has been released");
    }

    public void addVideoStreamPlayerListener(JMVideoStreamPlayerListener listener) {
        this.mExternalListener = listener;
    }

    @SuppressLint(value={"MissingPermission"})
    private String getPhoneIMEI(Context context) {
        SharedPreferences sp = context.getSharedPreferences("JMVideoPlayer_AppIDInfo", 0);
        String appID = sp.getString("JMVideoPlayer_AppID", "");
        if (TextUtils.isEmpty((CharSequence)appID)) {
            if (CommonUtils.isReadPhontState(context)) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                appID = telephonyManager.getDeviceId();
            }
            if (TextUtils.isEmpty((CharSequence)appID)) {
                appID = CommonUtils.getRandomImei();
            }
            appID = MD5Util.md5(appID, 12);
            SharedPreferences.Editor editor = sp.edit();
            editor.putString("JMVideoPlayer_AppID", appID);
            editor.apply();
        }
        return appID;
    }

    private void loadYUV420pData(byte[] y, byte[] u, byte[] v, int width, int height) {
        if (this.mGLMonitor != null && y.length > 0 && u.length > 0 && v.length > 0 && width > 0 && height > 0) {
            this.mGLMonitor.displayYUVData(width, height, y, u, v);
        }
    }

    private void loadAudioData(byte[] audioData, int size, int sampleRate, int channels) {
        this.mAudioSampleRate = sampleRate;
        this.mAudioChannels = channels;
        if (this.mPlayStatus == 2) {
            this.startAudioPlayer(audioData, size);
        } else if (this.mPlayStatus != 1) {
            this.stopAudioPlayer();
        }
    }

    private void startAudioRecord() {
        if (this.mHWAACEncoder != null && this.mHWAACEncoder.isRun()) {
            return;
        }
        this.mHWAACEncoder = new HWAACEncoder();
        this.mHWAACEncoder.startEncoder();
    }

    private void releaseAudioRecord() {
        if (this.mHWAACEncoder != null) {
            this.mHWAACEncoder.stopEncoder();
            this.mHWAACEncoder = null;
        }
    }

    private void startAudioPlayer(byte[] audioData, int size) {
        if (this.mAudioTrack == null) {
            int channelConfig = 4;
            int audioFormat = 2;
            int minBufSize = AudioTrack.getMinBufferSize((int)this.mAudioSampleRate, (int)channelConfig, (int)audioFormat);
            this.mAudioTrack = new AudioTrack(3, this.mAudioSampleRate, channelConfig, audioFormat, minBufSize, 1);
            this.mAudioTrack.play();
        }
        if (audioData == null || size <= 0) {
            return;
        }
        int temp = this.mAudioTrack.write(audioData, 0, size);
        if (temp < 0) {
            JMLogUtil.e("mAudioTreack write error");
        }
    }

    private void stopAudioPlayer() {
        if (this.mAudioTrack != null) {
            this.mAudioTrack.stop();
            this.mAudioTrack.release();
            this.mAudioTrack = null;
        }
    }

    public boolean setHWDecodeState(boolean isHWDecode) {
        if (!this.mIsSupportHWDecode && isHWDecode) {
            JMLogUtil.e("Not Support MediaCodec to decode video data");
            return false;
        }
        JMVideoStreamPlayerJni.SetHWDecodeState(isHWDecode);
        return true;
    }

    public boolean getHWDecodeState() {
        return JMVideoStreamPlayerJni.GetHWDecodeState();
    }

    public void setMute(boolean mute) {
        JMVideoStreamPlayerJni.SetMute(mute);
    }

    public boolean getMute() {
        return JMVideoStreamPlayerJni.GetMute();
    }

    public void setDelayMaxTime(double delayMaxTime) {
        JMVideoStreamPlayerJni.SetDelayMaxTime(delayMaxTime);
    }

    public double getDelayMaxTime() {
        return JMVideoStreamPlayerJni.GetDelayMaxTime();
    }

    public void setTimeoutInterval(double timeoutInterval) {
        JMVideoStreamPlayerJni.SetHttpTimeoutInterval(timeoutInterval);
    }

    public double getTimeoutInterval() {
        return JMVideoStreamPlayerJni.GetHttpTimeoutInterval();
    }

    public void attachGlMonitor(GLMonitor monitor) {
        this.mGLMonitor = monitor;
    }

    public void deattachMonitor() {
        this.mGLMonitor = null;
    }

    private void stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    private void updateSurfaceScreenOn() {
        if (this.mGLMonitor != null) {
            this.mGLMonitor.setKeepScreenOn(this.mStayAwake);
        }
    }

    public void startPlayLive() {
        JMVideoStreamPlayerJni.StartPlayLive();
    }

    public void startPlayback(List<String> fileNameList) {
        JMVideoStreamPlayerJni.StartPlayback(fileNameList);
    }

    public void startPlay(String url) {
        JMVideoStreamPlayerJni.StartPlay(url);
    }

    public void stopPlay() {
        JMVideoStreamPlayerJni.StopPlay();
    }

    public void startTalk() {
        if (CommonUtils.isRecordAudio(this.mContext)) {
            this.startAudioRecord();
            JMVideoStreamPlayerJni.StartTalk();
        } else if (this.mExternalListener != null) {
            this.mExternalListener.onStreamPlayerTalkStatus(14, "");
        }
    }

    public void stopTalk() {
        JMVideoStreamPlayerJni.StopTalk();
        this.releaseAudioRecord();
    }

    public void stop() {
        this.stopRecording();
        this.stopPlay();
        this.stopTalk();
        JMVideoStreamPlayerJni.StopWebServer();
        this.stopGatewayServer();
    }

    public void reStart() {
        JMVideoStreamPlayerJni.StartWebServer();
        this.startGatewayServer();
    }

    public void switchCamera(boolean isFront, boolean autoPlay, JMSwitchCameraListener listener) {
        if (this.mCameraSwitchTask > 0L) {
            this.cancelAsyncRequest(this.mCameraSwitchTask);
            this.mCameraSwitchTask = 0L;
        }
        this.mSwitchCameraListener = listener;
        this.mCameraSwitchAutoPlay = autoPlay;
        HashMap<String, String> mapPara = new HashMap<String, String>();
        mapPara.put("code", "001");
        mapPara.put("id", this.mIMEI);
        mapPara.put("cameraId", isFront ? "1" : "0");
        this.mCameraSwitchTask = this.sendAsyncRequest(mapPara, new JMHttpRequestTaskListener(){

            @Override
            public void onCustomMsgHandler(boolean success, long statusCode, String dataJsonStr) {
                if (!success && statusCode != 200L) {
                    if (JMVideoStreamPlayer.this.mSwitchCameraListener != null) {
                        JMVideoStreamPlayer.this.mSwitchCameraListener.onSwitchCameraHandler(false, null, statusCode, "");
                    }
                    return;
                }
                long code = 0L;
                String errMsg = null;
                try {
                    JSONObject jsonObject = new JSONObject(dataJsonStr);
                    if (jsonObject.has("code") && jsonObject.getInt("code") != 0) {
                        code = jsonObject.getLong("code");
                        errMsg = jsonObject.getString("msg");
                    } else if (jsonObject.has("content")) {
                        String content = jsonObject.getString("content");
                        JSONObject contentObj = new JSONObject(content);
                        int result = contentObj.getInt("ret");
                        int subCode = 0;
                        if (contentObj.has("subCode")) {
                            subCode = contentObj.getInt("subCode");
                        }
                        if (result == 0 && subCode != 0 || result == 1 && subCode == 0) {
                            code = -4L;
                            errMsg = "Error:Device reject request";
                            JMLogUtil.e("Switch cameras: Device reject request");
                        } else {
                            String url = jsonObject.getString("pullURL") + jsonObject.getString("token");
                            if (JMVideoStreamPlayer.this.mCameraSwitchAutoPlay && result == 2 && !JMVideoStreamPlayerJni.IsPlaying() && !TextUtils.isEmpty((CharSequence)url)) {
                                JMVideoStreamPlayerJni.StartPlay(url);
                            } else if (JMVideoStreamPlayer.this.mCameraSwitchAutoPlay) {
                                if (!TextUtils.isEmpty((CharSequence)url)) {
                                    JMLogUtil.d("Switch cameras: No need to replay");
                                } else {
                                    JMLogUtil.e("Switch cameras: Play url is NULL");
                                }
                            }
                            if (JMVideoStreamPlayer.this.mSwitchCameraListener != null) {
                                JMVideoStreamPlayer.this.mSwitchCameraListener.onSwitchCameraHandler(true, url, 0L, "");
                                return;
                            }
                        }
                    } else {
                        code = -3L;
                        errMsg = "Error:Abnormal data";
                        JMLogUtil.e("Switch cameras: Abnormal data");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    code = -2L;
                    errMsg = "Error:Not json data";
                    JMLogUtil.e("Switch cameras: Not json data");
                }
                if (JMVideoStreamPlayer.this.mSwitchCameraListener != null) {
                    JMVideoStreamPlayer.this.mSwitchCameraListener.onSwitchCameraHandler(false, null, code, errMsg);
                }
            }
        });
    }

    public Bitmap snapshot() {
        if (this.mGLMonitor != null) {
            return this.mGLMonitor.snapshot();
        }
        return null;
    }

    public void startRecording(String filePath) {
        if (CommonUtils.isWriteExternalStorage(this.mContext) && CommonUtils.isReadExternalStorage(this.mContext)) {
            JMVideoStreamPlayerJni.StartRecording(filePath);
        } else if (this.mExternalListener != null) {
            this.mExternalListener.onStreamPlayerRecordStatus(7, "");
        }
    }

    public void stopRecording() {
        JMVideoStreamPlayerJni.StopRecording();
    }

    public boolean isRecording() {
        return JMVideoStreamPlayerJni.IsRecording();
    }

    public long getRecordingRuration() {
        return JMVideoStreamPlayerJni.GetRecordingRuration();
    }

    public void setDenoiseLevel(int level) {
        JMVideoStreamPlayerJni.SetDenoiseLevel(level);
    }

    public int getOnlineCount() {
        return JMVideoStreamPlayerJni.GetOnlineCount();
    }

    public long sendAsyncRequest(Map<String, String> mapPara, JMHttpRequestTaskListener listener) {
        if (mapPara == null) {
            return 0L;
        }
        String[] paraArray = new String[mapPara.size() * 2];
        int i = 0;
        Iterator<String> iterator = mapPara.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            paraArray[2 * i] = key = iterator.next();
            paraArray[2 * i + 1] = mapPara.get(key);
            ++i;
        }
        return JMVideoStreamPlayerJni.SendAsyncRequest(paraArray, listener);
    }

    public void cancelAsyncRequest(long task) {
        if (task == 0L) {
            return;
        }
        JMVideoStreamPlayerJni.CancelAsyncRequest(task);
    }

    public long buildSyncRequest(Map<String, String> mapPara) {
        if (mapPara == null || mapPara.size() == 0) {
            return 0L;
        }
        String[] paraArray = new String[mapPara.size() * 2];
        int i = 0;
        Iterator<String> iterator = mapPara.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            paraArray[2 * i] = key = iterator.next();
            paraArray[2 * i + 1] = mapPara.get(key);
            ++i;
        }
        return JMVideoStreamPlayerJni.BuildSyncRequest(paraArray);
    }

    public String startSyncRequest(long task) {
        if (task == 0L) {
            return "";
        }
        return JMVideoStreamPlayerJni.StartSyncRequest(task);
    }

    public void cancelSyncRequest(long task) {
        if (task == 0L) {
            return;
        }
        JMVideoStreamPlayerJni.CancelSyncRequest(task);
    }

    public void startGatewayServer() {
        JMVideoStreamPlayerJni.StartGatewayServer();
    }

    public void stopGatewayServer() {
        JMVideoStreamPlayerJni.StopGatewayServer();
    }

    static {
        try {
            System.loadLibrary("avformat");
            System.loadLibrary("avfilter");
            System.loadLibrary("postproc");
            System.loadLibrary("avcodec");
            System.loadLibrary("swscale");
            System.loadLibrary("swresample");
            System.loadLibrary("avutil");
            System.loadLibrary("avdevice");
        }
        catch (UnsatisfiedLinkError ule) {
            JMLogUtil.i("loadLibrary share ffmpeg failed, may use a static library");
            JMLogUtil.d(ule.getMessage());
        }
        try {
            System.loadLibrary("JimiVideoPlayer");
        }
        catch (UnsatisfiedLinkError ule) {
            JMLogUtil.d(ule.getMessage());
        }
        mVideoWidth = 0;
        mVideoHeight = 0;
    }
}

