package com.jimi.jimivideoplayer;

import com.jimi.jimivideoplayer.bean.FrameInfo;

public interface JMVideoStreamPlayerListener {

    /**
     * 视频播放状态STREAM_PLAY_STATUS
     */
    int STREAM_VIDEO_STATUS_NONE = 0;
    /**正在准备播放*/
    int STREAM_VIDEO_STATUS_PREPARE = 1;
    /**正在播放*/
    int STREAM_VIDEO_STATUS_START = 2;
    /**播放结束*/
    int STREAM_VIDEO_STATUS_STOP = 3;
    /**获取URL失败*/
    int STREAM_VIDEO_STATUS_ERR_URL_GET = 4;
    /**URL无效*/
    int STREAM_VIDEO_STATUS_ERR_URL_INVALID = 5;
    /**打开URL失败*/
    int STREAM_VIDEO_STATUS_ERR_OPEN_FAIL = 6;
    /**打开URL超时*/
    int STREAM_VIDEO_STATUS_ERR_OPEN_TIMEOUT = 7;
    /**播放异常或设备停止推流(会自动停止播放器)*/
    int STREAM_VIDEO_STATUS_ERR_PLAY_ABNORMAL = 8;
    /**http请求超时*/
    int STREAM_VIDEO_STATUS_ERR_HTTP_TIMEOUT = 9;
    /**域名或IP错误*/
    int STREAM_VIDEO_STATUS_ERR_HTTP_HOST = 10;
    /**http参数错误*/
    int STREAM_VIDEO_STATUS_ERR_HTTP_PARAMETER = 11;
    /**服务器数据解析异常*/
    int STREAM_VIDEO_STATUS_ERR_SERVER_DATA = 12;
    /**设备已回复，内容是失败*/
    int STREAM_VIDEO_STATUS_ERR_DEVICE_REPLY_FAIL = 13;  //设备回复失败
    /**网络异常*/
    int STREAM_VIDEO_STATUS_ERR_NETWORK_ANOMALY = 14;

    /**
     * 视频播放状态STREAM_TALK_STATUS
     */
    int STREAM_TALK_STATUS_NONE = 0;
    /**进行对讲准备工作*/
    int STREAM_TALK_STATUS_PREPARE = 1;
    /**对讲已开始*/
    int STREAM_TALK_STATUS_START = 2;
    /**对讲已停止*/
    int STREAM_TALK_STATUS_STOP = 3;
    /**获取URL失败*/
    int STREAM_TALK_STATUS_ERR_URL_GET = 4;
    /**初始化对讲URL失败*/
    int STREAM_TALK_STATUS_ERR_INIT = 5;
    /**正在对讲不能再次开始*/
    int STREAM_TALK_STATUS_ERR_TALKING = 6;
    /**发送音频数据失败*/
    int STREAM_TALK_STATUS_ERR_SEND = 7;
    /**http请求超时*/
    int STREAM_TALK_STATUS_ERR_HTTP_TIMEOUT = 8;
    /**域名或IP错误*/
    int STREAM_TALK_STATUS_ERR_HTTP_HOST = 9;
    /**http参数错误*/
    int STREAM_TALK_STATUS_ERR_HTTP_PARAMETER = 10;
    /**服务器数据解析异常*/
    int STREAM_TALK_STATUS_ERR_SERVER_DATA = 11;
    /**设备回复"失败"，即表示设备端拒绝对讲或对讲初始化异常*/
    int STREAM_TALK_STATUS_ERR_DEVICE_REPLY_FAIL = 12;
    /**网络异常*/
    int STREAM_TALK_STATUS_ERR_NETWORK_ANOMALY = 13;
    /**无麦克风权限*/
    int STREAM_TALK_STATUS_ERR_AUTHORITY = 14;

    /**
     * 视频录制状态STREAM_TALK_STATUS
     */
    int STREAM_RECORD_STATUS_NONE = 0;
    /**开始录制*/
    int STREAM_RECORD_STATUS_START = 1;
    /**录制完成*/
    int STREAM_RECORD_STATUS_COMPLETE = 2;
    /**正在录制*/
    int STREAM_RECORD_STATUS_ERR_RECORDING = 3;
    /**录制失败*/
    int STREAM_RECORD_STATUS_ERR_FAIL = 4;
    /**保存失败*/
    int STREAM_RECORD_STATUS_ERR_SAVE = 5;
    /**无效路径*/
    int STREAM_RECORD_STATUS_ERR_PATH = 6;
    /**无存储权限*/
    int STREAM_RECORD_STATUS_ERR_AUTHORITY = 7;

    /**
     * 设备端透传的命令字(即回调didServerReceiveData中可能包含的字段：code的值)
     */
    int STREAM_RECEIVE_CMD_PLAYBACK_FILE_END = 0x108;  // 回放文件结尾
    int STREAM_RECEIVE_CMD_PLAYBACK_ALL_END = 0x109;   // 回放所有文件结束


    /**
     * 实时视频(直播或回放)的播放状态
     *
     * @param status 播放状态
     * @param errStr 只有当status为STREAM_VIDEO_STATUS_ERR_URL_GET时返回的是服务器的错误提示，其他情况均为空
     */
    void onStreamPlayerPlayStatus(int status, String errStr);

    /**
     * 实时视频对讲状态
     *
     * @param status 对讲状态
     * @param errStr 只有当status为STREAM_TALK_STATUS_ERR_URL_GET时返回的是服务器的错误提示，其他情况均为空
     */
    void onStreamPlayerTalkStatus(int status, String errStr);

    /**
     * 实时视频录制状态
     *
     * @param status   录制状态
     * @param filePath 视频保存的路径
     */
    void onStreamPlayerRecordStatus(int status, String filePath);

    /**
    * 音视频流信息(每秒更新一次，若视频宽高变化则会立即更新)
    * @param frameInfo  音视频帧信息对象
    * */
    void onStreamPlayerReceiveFrameInfo(FrameInfo frameInfo);

    /**
     * 网关透传设备发送的消息(即设备端发送的信息)
     *
     * @param data 具体数据内容(一般为jason数据)
     * @param type 编码类型(暂时可忽略，内部默认已经编码为UTF-8, 0x01：ASCⅡ编码 0x02 ：UTF16-BE编码)
     * //@See 123 部分code命令字可查看枚举：STREAM_RECEIVE_CMD
     */
    void onServerReceiveData(String data, int type);
}
