package com.jimi.jimivideoplayer.util;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;

import com.jimi.jimivideoplayer.log.JMLogUtil;

public class MediaCodecUtil {

    /**
     * "video/x-vnd.on2.vp8" - VP8 video
     * "video/x-vnd.on2.vp9" - VP9 video
     * "video/avc" - H.264/AVC video
     * "video/hevc" - H.265/HEVC video
     * "video/mp4v-es" - MPEG4 video
     * "video/3gpp" - H.263 video
     * "audio/3gpp" - AMR narrowband audio
     * "audio/amr-wb" - AMR wideband audio
     * "audio/mpeg" - MPEG1/2 audio layer III
     * "audio/mp4a-latm" - AAC audio (note, this is raw AAC packets, not packaged in LATM!)
     * "audio/vorbis" - vorbis audio
     * "audio/g711-alaw" - G.711 alaw audio
     * "audio/g711-mlaw" - G.711 ulaw audio
     * @param  decoderType 编码类型
     * @return 是否支持硬解码
     */
    static public boolean isSupportMediaCodecHardDecoder(String decoderType){
        if (isEmulator()) {
            return false;
        }

        boolean isHardcode = false;
        MediaCodecList mediaCodecList = new MediaCodecList(1);
        MediaCodecInfo[] infos = mediaCodecList.getCodecInfos();
        for(MediaCodecInfo info : infos){
            String[] types = info.getSupportedTypes();
            for (int i = 0; i < types.length; i++) {
                if(decoderType.equals(types[i])){
                    isHardcode = true;
                    break;
                }
            }

            if(isHardcode)
                break;
        }

        if (isHardcode) {
            JMLogUtil.i("Support MediaCodec to decode video data: " + decoderType);
        } else {
            JMLogUtil.e("Not Support MediaCodec to decode video data: " + decoderType);
        }
        return isHardcode;
    }

    static public boolean isSupportAvcCodec() {
        if (Build.VERSION.SDK_INT >= 18) {
            for (int j = MediaCodecList.getCodecCount() - 1; j >= 0; j--) {
                MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt(j);

                String[] types = codecInfo.getSupportedTypes();
                for (int i = 0; i < types.length; i++) {
                    if (types[i].equalsIgnoreCase("video/avc")) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * 简单验证是否是模拟器
     *
     * @return 是否是模拟器
     */
    public static boolean isEmulator() {
        String serial = Build.SERIAL;
        if (serial.equalsIgnoreCase("unknown") ||
                serial.equalsIgnoreCase("android") ||
                serial.contains("EMULATOR")) {
            return true;
        }
        return false;
    }
}
