/*
 * Decompiled with CFR 0.152.
 */
package com.jimi.jimivideoplayer.util;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import com.jimi.jimivideoplayer.log.JMLogUtil;

public class MediaCodecUtil {
    public static boolean isSupportMediaCodecHardDecoder(String decoderType) {
        MediaCodecInfo[] infos;
        if (MediaCodecUtil.isEmulator()) {
            return false;
        }
        boolean isHardcode = false;
        MediaCodecList mediaCodecList = new MediaCodecList(1);
        for (MediaCodecInfo info : infos = mediaCodecList.getCodecInfos()) {
            String[] types = info.getSupportedTypes();
            for (int i = 0; i < types.length; ++i) {
                if (!decoderType.equals(types[i])) continue;
                isHardcode = true;
                break;
            }
            if (isHardcode) break;
        }
        if (isHardcode) {
            JMLogUtil.i("Support MediaCodec to decode video data: " + decoderType);
        } else {
            JMLogUtil.e("Not Support MediaCodec to decode video data: " + decoderType);
        }
        return isHardcode;
    }

    public static boolean isSupportAvcCodec() {
        if (Build.VERSION.SDK_INT >= 18) {
            for (int j = MediaCodecList.getCodecCount() - 1; j >= 0; --j) {
                MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)j);
                String[] types = codecInfo.getSupportedTypes();
                for (int i = 0; i < types.length; ++i) {
                    if (!types[i].equalsIgnoreCase("video/avc")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isEmulator() {
        String serial = Build.SERIAL;
        return serial.equalsIgnoreCase("unknown") || serial.equalsIgnoreCase("android") || serial.contains("EMULATOR");
    }
}

