/*
 * Decompiled with CFR 0.152.
 */
package com.jimi.jimivideoplayer.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.PermissionChecker;
import android.telephony.TelephonyManager;
import com.jimi.jimivideoplayer.log.JMLogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.UUID;

public class CommonUtils {
    private static Thread mPingThread = null;
    private static boolean bIsRungPing = false;
    private static Process mPingProcess = null;

    public static String getRandomImei() {
        UUID uuid = UUID.randomUUID();
        String str_uuid = uuid.toString().replace("-", "");
        return str_uuid;
    }

    private static boolean isExistContextCompat() {
        try {
            Class.forName("android.support.v4.content.ContextCompat");
        }
        catch (ClassNotFoundException e) {
            JMLogUtil.e("Error: Not exist android.support.v4.content.ContextCompat");
            return false;
        }
        return true;
    }

    public static boolean isReadPhontState(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (!CommonUtils.isExistContextCompat()) {
                return true;
            }
            if (context != null) {
                return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0;
            }
            return false;
        }
        return PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0;
    }

    public static boolean isReadExternalStorage(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (!CommonUtils.isExistContextCompat()) {
                return true;
            }
            if (context != null) {
                return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
            }
            return false;
        }
        return PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
    }

    public static boolean isWriteExternalStorage(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (!CommonUtils.isExistContextCompat()) {
                return true;
            }
            if (context != null) {
                return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
            }
            return false;
        }
        return PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    public static boolean isRecordAudio(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (!CommonUtils.isExistContextCompat()) {
                return true;
            }
            if (context != null) {
                return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.RECORD_AUDIO") == 0;
            }
            return false;
        }
        return PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.RECORD_AUDIO") == 0;
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper().getThread().getId() == Thread.currentThread().getId();
    }

    public static String getPlaybackFilePath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "TimeLine" + File.separator;
    }

    public static void pingStart() {
        if (mPingThread == null) {
            bIsRungPing = true;
            mPingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (bIsRungPing) {
                        CommonUtils.ping("live.jimivideo.com");
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    JMLogUtil.i("Ping server live.jimivideo.com thread exit");
                }
            });
            mPingThread.start();
        }
    }

    private static void ping(String str) {
        block8: {
            try {
                if (mPingProcess != null) break block8;
                mPingProcess = Runtime.getRuntime().exec("ping -c 1 -w 1 " + str);
                InputStream input = mPingProcess.getInputStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(input));
                StringBuffer buffer = new StringBuffer();
                String line = "";
                while (bIsRungPing && (line = in.readLine()) != null) {
                    buffer.append(line);
                }
                String resultStr = null;
                String[] splitStr1 = buffer.toString().split("--- " + str + " ping statistics ---");
                if (splitStr1.length == 1 || splitStr1[0].contains("icmp_seq=")) {
                    resultStr = splitStr1[0];
                    JMLogUtil.i(resultStr);
                } else {
                    resultStr = splitStr1[0] + splitStr1[1];
                    JMLogUtil.i(resultStr);
                }
                try {
                    mPingProcess.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    mPingProcess.destroy();
                }
                mPingProcess = null;
                if (resultStr == null || resultStr.isEmpty()) {
                    JMLogUtil.w("TEST server failed: " + str);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void pingStop() {
        bIsRungPing = false;
        if (mPingThread != null) {
            mPingThread.interrupt();
            try {
                mPingThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            mPingThread = null;
        }
    }

    public static void pingOnce(String hosts) {
        if (!bIsRungPing) {
            bIsRungPing = true;
            if (hosts == null || hosts.isEmpty()) {
                CommonUtils.ping("live.jimivideo.com");
            } else {
                CommonUtils.ping(hosts);
            }
            bIsRungPing = false;
        }
    }

    public static String getNetworkType(Object contextObj) {
        NetworkInfo networkInfo;
        if (contextObj == null) {
            return "None";
        }
        Context context = (Context)contextObj;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm != null && (networkInfo = cm.getActiveNetworkInfo()) != null) {
            if (networkInfo.getType() == 1) {
                return "WiFi";
            }
            if (networkInfo.getType() == 0) {
                int nSubType = networkInfo.getSubtype();
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (nSubType == 13 && !telephonyManager.isNetworkRoaming()) {
                    return "4G";
                }
                if (nSubType == 3 || nSubType == 8 || nSubType == 5 && !telephonyManager.isNetworkRoaming()) {
                    return "3G";
                }
                if (nSubType == 1 || nSubType == 2 || nSubType == 4 && !telephonyManager.isNetworkRoaming()) {
                    return "2G";
                }
                return "4G/3G";
            }
            return "None";
        }
        return "None";
    }
}

