package com.jimi.jimivideoplayer.bean;

/*
 * COPYRIGHT. ShenZhen JiMi Technology Co., Ltd. 2019.
 * ALL RIGHTS RESERVED.
 *
 * No part of this publication may be reproduced, stored in a retrieval system, or transmitted,
 * on any form or by any means, electronic, mechanical, photocopying, recording,
 * or otherwise, without the prior written permission of ShenZhen JiMi Network Technology Co., Ltd.
 *
 * @ProjectName JimiVideoPlayerDemo_Android
 * @Description: 保存流信息
 * @Date 2019/1/10 11:05
 * @author HuangJiaLin
 * @version 2.0
 */
public class FrameInfo {
    public int videoWidth;//视频宽度
    public int videoHeight;//视频高度
    public int videoBps;//视频码率(B/s)
    public int audioBps;//音频码率(B/s)
    public long timestamp;//视频时间戳，实时视频已经播放的时长
    public int totalFrameCount;//每秒帧数
    public int onlineCount;//每秒帧数

    public FrameInfo(){

    }

    public int getVideoWidth() {
        return videoWidth;
    }

    public void setVideoWidth(int videoWidth) {
        this.videoWidth = videoWidth;
    }

    public int getVideoHeight() {
        return videoHeight;
    }

    public void setVideoHeight(int videoHeight) {
        this.videoHeight = videoHeight;
    }

    public int getVideoBps() {
        return videoBps;
    }

    public void setVideoBps(int videoBps) {
        this.videoBps = videoBps;
    }

    public int getAudioBps() {
        return audioBps;
    }

    public void setAudioBps(int audioBps) {
        this.audioBps = audioBps;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getTotalFrameCount() {
        return totalFrameCount;
    }

    public void setTotalFrameCount(int totalFrameCount) {
        this.totalFrameCount = totalFrameCount;
    }

    public int getOnlineCount() {
        return onlineCount;
    }

    public void setOnlineCount(int onlineCount) {
        this.onlineCount = onlineCount;
    }

    @Override
    public String toString() {
        return "FrameInfo{" +
                "videoWidth=" + videoWidth +
                ", videoHeight=" + videoHeight +
                ", videoBps=" + videoBps +
                ", audioBps=" + audioBps +
                ", timestamp=" + timestamp +
                ", totalFrameCount=" + totalFrameCount +
                ", onlineCount=" + onlineCount +
                '}';
    }
}
