/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import a.a.a.a.a;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import java.util.Arrays;
import java.util.List;
import org.webrtc.ContextUtils;
import org.webrtc.Logging;
import org.webrtc.voiceengine.WebRtcAudioEffects;

public final class WebRtcAudioUtils {
    public static final String TAG = "WebRtcAudioUtils";
    public static final String[] BLACKLISTED_OPEN_SL_ES_MODELS = new String[0];
    public static final String[] BLACKLISTED_AEC_MODELS = new String[0];
    public static final String[] BLACKLISTED_NS_MODELS = new String[0];
    public static final int DEFAULT_SAMPLE_RATE_HZ = 16000;
    public static int defaultSampleRateHz = 16000;
    public static boolean isDefaultSampleRateOverridden;
    public static boolean useWebRtcBasedAcousticEchoCanceler;
    public static boolean useWebRtcBasedNoiseSuppressor;

    public static synchronized void setWebRtcBasedAcousticEchoCanceler(boolean bl) {
        useWebRtcBasedAcousticEchoCanceler = bl;
    }

    public static synchronized void setWebRtcBasedNoiseSuppressor(boolean bl) {
        useWebRtcBasedNoiseSuppressor = bl;
    }

    public static synchronized void setWebRtcBasedAutomaticGainControl(boolean bl) {
        Logging.w(TAG, "setWebRtcBasedAutomaticGainControl() is deprecated");
    }

    public static synchronized boolean useWebRtcBasedAcousticEchoCanceler() {
        if (useWebRtcBasedAcousticEchoCanceler) {
            Logging.w(TAG, "Overriding default behavior; now using WebRTC AEC!");
        }
        return useWebRtcBasedAcousticEchoCanceler;
    }

    public static synchronized boolean useWebRtcBasedNoiseSuppressor() {
        if (useWebRtcBasedNoiseSuppressor) {
            Logging.w(TAG, "Overriding default behavior; now using WebRTC NS!");
        }
        return useWebRtcBasedNoiseSuppressor;
    }

    public static synchronized boolean useWebRtcBasedAutomaticGainControl() {
        return true;
    }

    public static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.canUseAcousticEchoCanceler();
    }

    public static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.canUseNoiseSuppressor();
    }

    public static boolean isAutomaticGainControlSupported() {
        return false;
    }

    public static synchronized void setDefaultSampleRateHz(int n3) {
        isDefaultSampleRateOverridden = true;
        defaultSampleRateHz = n3;
    }

    public static synchronized boolean isDefaultSampleRateOverridden() {
        return isDefaultSampleRateOverridden;
    }

    public static synchronized int getDefaultSampleRateHz() {
        return defaultSampleRateHz;
    }

    public static List<String> getBlackListedModelsForAecUsage() {
        return Arrays.asList(BLACKLISTED_AEC_MODELS);
    }

    public static List<String> getBlackListedModelsForNsUsage() {
        return Arrays.asList(BLACKLISTED_NS_MODELS);
    }

    public static String getThreadInfo() {
        return a.a("@[name=").append(Thread.currentThread().getName()).append(", id=").append(Thread.currentThread().getId()).append("]").toString();
    }

    public static boolean runningOnEmulator() {
        return Build.HARDWARE.equals("goldfish") && Build.BRAND.startsWith("generic_");
    }

    public static boolean deviceIsBlacklistedForOpenSLESUsage() {
        return Arrays.asList(BLACKLISTED_OPEN_SL_ES_MODELS).contains(Build.MODEL);
    }

    public static void logDeviceInfo(String string2) {
        Logging.d(string2, a.a("Android SDK: ").append(Build.VERSION.SDK_INT).append(", Release: ").append(Build.VERSION.RELEASE).append(", Brand: ").append(Build.BRAND).append(", Device: ").append(Build.DEVICE).append(", Id: ").append(Build.ID).append(", Hardware: ").append(Build.HARDWARE).append(", Manufacturer: ").append(Build.MANUFACTURER).append(", Model: ").append(Build.MODEL).append(", Product: ").append(Build.PRODUCT).toString());
    }

    public static void logAudioState(String string2) {
        String string3 = string2;
        WebRtcAudioUtils.logDeviceInfo(string3);
        AudioManager audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        WebRtcAudioUtils.logAudioStateBasic(string2, audioManager);
        WebRtcAudioUtils.logAudioStateVolume(string2, audioManager);
        WebRtcAudioUtils.logAudioDeviceInfo(string3, audioManager);
    }

    public static void logAudioStateBasic(String string2, AudioManager audioManager) {
        Logging.d(string2, a.a("Audio State: audio mode: ").append(WebRtcAudioUtils.modeToString(audioManager.getMode())).append(", has mic: ").append(WebRtcAudioUtils.hasMicrophone()).append(", mic muted: ").append(audioManager.isMicrophoneMute()).append(", music active: ").append(audioManager.isMusicActive()).append(", speakerphone: ").append(audioManager.isSpeakerphoneOn()).append(", BT SCO: ").append(audioManager.isBluetoothScoOn()).toString());
    }

    public static boolean isVolumeFixed(AudioManager audioManager) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return audioManager.isVolumeFixed();
    }

    public static void logAudioStateVolume(String string2, AudioManager audioManager) {
        int[] nArray = new int[6];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 3;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 1;
        Logging.d(string2, "Audio State: ");
        int n3 = WebRtcAudioUtils.isVolumeFixed(audioManager);
        Logging.d(string2, "  fixed volume=" + (n3 != 0));
        if (n3 == 0) {
            n3 = nArray2.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                StringBuilder stringBuilder;
                String string3 = string2;
                int n4 = nArray2[i3];
                StringBuilder stringBuilder2 = stringBuilder;
                new StringBuilder().append(a.a("  ").append(WebRtcAudioUtils.streamTypeToString(n4)).append(": ").toString());
                stringBuilder2.append("volume=").append(audioManager.getStreamVolume(n4));
                stringBuilder2.append(", max=").append(audioManager.getStreamMaxVolume(n4));
                WebRtcAudioUtils.logIsStreamMute(string3, audioManager, n4, stringBuilder2);
                Logging.d(string3, stringBuilder2.toString());
            }
        }
    }

    public static void logIsStreamMute(String string2, AudioManager audioManager, int n3, StringBuilder stringBuilder) {
        if (Build.VERSION.SDK_INT >= 23) {
            stringBuilder.append(", muted=").append(audioManager.isStreamMute(n3));
        }
    }

    public static void logAudioDeviceInfo(String string2, AudioManager audioDeviceInfoArray) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if ((audioDeviceInfoArray = audioDeviceInfoArray.getDevices(3)).length == 0) {
            return;
        }
        Logging.d(string2, "Audio Devices: ");
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            new StringBuilder().append("  ").append(WebRtcAudioUtils.deviceTypeToString(audioDeviceInfo.getType()));
            String string3 = audioDeviceInfo.isSource() ? "(in): " : "(out): ";
            stringBuilder2.append(string3);
            if (audioDeviceInfo.getChannelCounts().length > 0) {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append("channels=").append(Arrays.toString(audioDeviceInfo.getChannelCounts()));
                stringBuilder3.append(", ");
            }
            if (audioDeviceInfo.getEncodings().length > 0) {
                StringBuilder stringBuilder4 = stringBuilder2;
                stringBuilder4.append("encodings=").append(Arrays.toString(audioDeviceInfo.getEncodings()));
                stringBuilder4.append(", ");
            }
            if (audioDeviceInfo.getSampleRates().length > 0) {
                StringBuilder stringBuilder5 = stringBuilder2;
                stringBuilder5.append("sample rates=").append(Arrays.toString(audioDeviceInfo.getSampleRates()));
                stringBuilder5.append(", ");
            }
            StringBuilder stringBuilder6 = stringBuilder2;
            stringBuilder6.append("id=").append(audioDeviceInfo.getId());
            Logging.d(string2, stringBuilder6.toString());
        }
    }

    public static String modeToString(int n3) {
        switch (n3) {
            default: {
                return "MODE_INVALID";
            }
            case 3: {
                return "MODE_IN_COMMUNICATION";
            }
            case 2: {
                return "MODE_IN_CALL";
            }
            case 1: {
                return "MODE_RINGTONE";
            }
            case 0: 
        }
        return "MODE_NORMAL";
    }

    public static String streamTypeToString(int n3) {
        switch (n3) {
            default: {
                return "STREAM_INVALID";
            }
            case 5: {
                return "STREAM_NOTIFICATION";
            }
            case 4: {
                return "STREAM_ALARM";
            }
            case 3: {
                return "STREAM_MUSIC";
            }
            case 2: {
                return "STREAM_RING";
            }
            case 1: {
                return "STREAM_SYSTEM";
            }
            case 0: 
        }
        return "STREAM_VOICE_CALL";
    }

    public static String deviceTypeToString(int n3) {
        switch (n3) {
            default: {
                return "TYPE_UNKNOWN";
            }
            case 22: {
                return "TYPE_USB_HEADSET";
            }
            case 21: {
                return "TYPE_BUS";
            }
            case 20: {
                return "TYPE_IP";
            }
            case 19: {
                return "TYPE_AUX_LINE";
            }
            case 18: {
                return "TYPE_TELEPHONY";
            }
            case 17: {
                return "TYPE_TV_TUNER";
            }
            case 16: {
                return "TYPE_FM_TUNER";
            }
            case 15: {
                return "TYPE_BUILTIN_MIC";
            }
            case 14: {
                return "TYPE_FM";
            }
            case 13: {
                return "TYPE_DOCK";
            }
            case 12: {
                return "TYPE_USB_ACCESSORY";
            }
            case 11: {
                return "TYPE_USB_DEVICE";
            }
            case 10: {
                return "TYPE_HDMI_ARC";
            }
            case 9: {
                return "TYPE_HDMI";
            }
            case 8: {
                return "TYPE_BLUETOOTH_A2DP";
            }
            case 7: {
                return "TYPE_BLUETOOTH_SCO";
            }
            case 6: {
                return "TYPE_LINE_DIGITAL";
            }
            case 5: {
                return "TYPE_LINE_ANALOG";
            }
            case 4: {
                return "TYPE_WIRED_HEADPHONES";
            }
            case 3: {
                return "TYPE_WIRED_HEADSET";
            }
            case 2: {
                return "TYPE_BUILTIN_SPEAKER";
            }
            case 1: {
                return "TYPE_BUILTIN_EARPIECE";
            }
            case 0: 
        }
        return "TYPE_UNKNOWN";
    }

    public static boolean hasMicrophone() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.microphone");
    }
}

