/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import a.a.a.a.a;
import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.webrtc.ContextUtils;
import org.webrtc.Logging;
import org.webrtc.ThreadUtils;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioTrack {
    public static final boolean DEBUG = false;
    public static final String TAG = "WebRtcAudioTrack";
    public static final int BITS_PER_SAMPLE = 16;
    public static final int CALLBACK_BUFFER_SIZE_MS = 10;
    public static final int BUFFERS_PER_SECOND = 100;
    public static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    public static final int DEFAULT_USAGE;
    public static int usageAttribute;
    public static volatile boolean speakerMute;
    @Nullable
    public static WebRtcAudioTrackErrorCallback errorCallbackOld;
    @Nullable
    public static ErrorCallback errorCallback;
    public static WebRtcAudioTrackCallback mWebRtcAudioTrackCallback;
    public final long nativeAudioTrack;
    public final AudioManager audioManager;
    public final ThreadUtils.ThreadChecker threadChecker;
    public ByteBuffer byteBuffer;
    @Nullable
    public AudioTrack audioTrack;
    @Nullable
    public AudioTrackThread audioThread;
    public byte[] emptyBytes;

    public static synchronized void setAudioTrackUsageAttribute(int n3) {
        Logging.w(TAG, a.a("Default usage attribute is changed from: ").append(DEFAULT_USAGE).append(" to ").append(n3).toString());
        usageAttribute = n3;
    }

    public static int getDefaultUsageAttribute() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 0;
    }

    @Deprecated
    public static void setErrorCallback(WebRtcAudioTrackErrorCallback webRtcAudioTrackErrorCallback) {
        Logging.d(TAG, "Set error callback (deprecated");
        errorCallbackOld = webRtcAudioTrackErrorCallback;
    }

    public static void setErrorCallback(ErrorCallback errorCallback) {
        Logging.d(TAG, "Set extended error callback");
        WebRtcAudioTrack.errorCallback = errorCallback;
    }

    public WebRtcAudioTrack(long l3) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        WebRtcAudioTrack webRtcAudioTrack2 = this;
        webRtcAudioTrack2.threadChecker = new ThreadUtils.ThreadChecker();
        webRtcAudioTrack2.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        webRtcAudioTrack.nativeAudioTrack = l3;
        webRtcAudioTrack.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initPlayout(int n3, int n4) {
        block6: {
            AudioTrack audioTrack;
            WebRtcAudioTrack webRtcAudioTrack = webRtcAudioTrackCallback;
            ((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).threadChecker.checkIsOnValidThread();
            Logging.d(TAG, "initPlayout(sampleRate=" + n3 + ", channels=" + n4 + ")");
            int n5 = n4 * 2;
            webRtcAudioTrack.byteBuffer = ByteBuffer.allocateDirect(n3 / 100 * n5);
            Logging.d(TAG, a.a("byteBuffer.capacity: ").append(((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).byteBuffer.capacity()).toString());
            webRtcAudioTrack.emptyBytes = new byte[webRtcAudioTrack.byteBuffer.capacity()];
            webRtcAudioTrack.nativeCacheDirectBufferAddress(webRtcAudioTrack.byteBuffer, ((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).nativeAudioTrack);
            n5 = ((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).channelCountToConfiguration(n4);
            int n6 = AudioTrack.getMinBufferSize((int)n3, (int)n5, (int)2);
            Logging.d(TAG, "AudioTrack.getMinBufferSize: " + n6);
            if (n6 < ((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).byteBuffer.capacity()) {
                ((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).reportWebRtcAudioTrackInitError("AudioTrack.getMinBufferSize returns an invalid value.");
                return false;
            }
            if (((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).audioTrack != null) {
                ((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).reportWebRtcAudioTrackInitError("Conflict with existing AudioTrack.");
                return false;
            }
            try {
                ((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).audioTrack = Build.VERSION.SDK_INT >= 21 ? WebRtcAudioTrack.createAudioTrackOnLollipopOrHigher(n3, n5, n6) : WebRtcAudioTrack.createAudioTrackOnLowerThanLollipop(n3, n5, n6);
                audioTrack = ((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).audioTrack;
                if (audioTrack == null) break block6;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = illegalArgumentException.getMessage();
                WebRtcAudioTrack webRtcAudioTrack2 = webRtcAudioTrackCallback;
                webRtcAudioTrack2.reportWebRtcAudioTrackInitError(string2);
                webRtcAudioTrack2.releaseAudioResources();
                return false;
            }
            if (audioTrack.getState() == 1) {
                WebRtcAudioTrack webRtcAudioTrack3 = webRtcAudioTrackCallback;
                webRtcAudioTrack3.logMainParameters();
                webRtcAudioTrack3.logMainParametersExtended();
                WebRtcAudioTrackCallback webRtcAudioTrackCallback = mWebRtcAudioTrackCallback;
                if (webRtcAudioTrackCallback != null) {
                    webRtcAudioTrackCallback.onWebRtcAudioTrackInit(2, n3, n4, 16, 100, n6);
                }
                return true;
            }
        }
        WebRtcAudioTrack webRtcAudioTrack = webRtcAudioTrackCallback;
        webRtcAudioTrack.reportWebRtcAudioTrackInitError("Initialization of audio track failed.");
        webRtcAudioTrack.releaseAudioResources();
        return false;
    }

    private boolean startPlayout() {
        block4: {
            WebRtcAudioTrack webRtcAudioTrack = this;
            webRtcAudioTrack.threadChecker.checkIsOnValidThread();
            Logging.d(TAG, "startPlayout");
            WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioTrack != null);
            WebRtcAudioTrack.assertTrue(this.audioThread == null);
            try {
                this.audioTrack.play();
                if (mWebRtcAudioTrackCallback == null) break block4;
            }
            catch (IllegalStateException illegalStateException) {
                WebRtcAudioTrack webRtcAudioTrack2 = this;
                webRtcAudioTrack2.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_EXCEPTION, a.a("AudioTrack.play failed: ").append(illegalStateException.getMessage()).toString());
                webRtcAudioTrack2.releaseAudioResources();
                return false;
            }
            mWebRtcAudioTrackCallback.onWebRtcAudioTrackStart();
        }
        if (this.audioTrack.getPlayState() != 3) {
            WebRtcAudioTrack webRtcAudioTrack = this;
            webRtcAudioTrack.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_STATE_MISMATCH, a.a("AudioTrack.play failed - incorrect state :").append(this.audioTrack.getPlayState()).toString());
            webRtcAudioTrack.releaseAudioResources();
            return false;
        }
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopPlayout() {
        WebRtcAudioTrack webRtcAudioTrack = webRtcAudioTrackCallback;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "stopPlayout");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioThread != null);
        WebRtcAudioTrack webRtcAudioTrack2 = webRtcAudioTrackCallback;
        webRtcAudioTrack2.logUnderrunCount();
        webRtcAudioTrack2.audioThread.stopThread();
        Logging.d(TAG, "Stopping the AudioTrackThread...");
        webRtcAudioTrack2.audioThread.interrupt();
        if (!ThreadUtils.joinUninterruptibly(webRtcAudioTrack2.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioTrackThread timed out.");
            WebRtcAudioUtils.logAudioState(TAG);
        }
        Logging.d(TAG, "AudioTrackThread has now been stopped.");
        ((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).audioThread = null;
        ((WebRtcAudioTrack)((Object)webRtcAudioTrackCallback)).releaseAudioResources();
        WebRtcAudioTrackCallback webRtcAudioTrackCallback = mWebRtcAudioTrackCallback;
        if (webRtcAudioTrackCallback != null) {
            webRtcAudioTrackCallback.onWebRtcAudioTrackStop();
        }
        return true;
    }

    private int getStreamMaxVolume() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamMaxVolume");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioManager != null);
        return this.audioManager.getStreamMaxVolume(0);
    }

    private boolean setStreamVolume(int n3) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "setStreamVolume(" + n3 + ")");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioManager != null);
        if (this.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, n3, 0);
        return true;
    }

    private boolean isVolumeFixed() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    private int getStreamVolume() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamVolume");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioManager != null);
        return this.audioManager.getStreamVolume(0);
    }

    private void logMainParameters() {
        Logging.d(TAG, a.a("AudioTrack: session ID: ").append(this.audioTrack.getAudioSessionId()).append(", channels: ").append(this.audioTrack.getChannelCount()).append(", sample rate: ").append(this.audioTrack.getSampleRate()).append(", max gain: ").append(AudioTrack.getMaxVolume()).toString());
    }

    @TargetApi(value=21)
    public static AudioTrack createAudioTrackOnLollipopOrHigher(int n3, int n4, int n5) {
        Logging.d(TAG, "createAudioTrackOnLollipopOrHigher");
        int n6 = AudioTrack.getNativeOutputSampleRate((int)0);
        Logging.d(TAG, "nativeOutputSampleRate: " + n6);
        if (n3 != n6) {
            Logging.w(TAG, "Unable to use fast mode since requested sample rate is not native");
        }
        if (usageAttribute != DEFAULT_USAGE) {
            Logging.w(TAG, a.a("A non default usage attribute is used: ").append(usageAttribute).toString());
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(usageAttribute).setContentType(1).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(n3).setChannelMask(n4).build(), n5, 1, 0);
    }

    public static AudioTrack createAudioTrackOnLowerThanLollipop(int n3, int n4, int n5) {
        return new AudioTrack(0, n3, n4, 2, n5, 1);
    }

    private void logBufferSizeInFrames() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, a.a("AudioTrack: buffer size in frames: ").append(this.audioTrack.getBufferSizeInFrames()).toString());
        }
    }

    private void logBufferCapacityInFrames() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, a.a("AudioTrack: buffer capacity in frames: ").append(this.audioTrack.getBufferCapacityInFrames()).toString());
        }
    }

    private void logMainParametersExtended() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.logBufferSizeInFrames();
        webRtcAudioTrack.logBufferCapacityInFrames();
    }

    private void logUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, a.a("underrun count: ").append(this.audioTrack.getUnderrunCount()).toString());
        }
    }

    public static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n3) {
        return n3 == 1 ? 4 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    public static void setSpeakerMute(boolean bl) {
        Logging.w(TAG, "setSpeakerMute(" + bl + ")");
        speakerMute = bl;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        AudioTrack audioTrack = this.audioTrack;
        if (audioTrack != null) {
            audioTrack.release();
            this.audioTrack = null;
        }
    }

    private void reportWebRtcAudioTrackInitError(String string2) {
        Logging.e(TAG, "Init playout error: " + string2);
        WebRtcAudioUtils.logAudioState(TAG);
        Object object = errorCallbackOld;
        if (object != null) {
            object.onWebRtcAudioTrackInitError(string2);
        }
        if ((object = errorCallback) != null) {
            object.onWebRtcAudioTrackInitError(string2);
        }
    }

    private void reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode audioTrackStartErrorCode, String string2) {
        Logging.e(TAG, "Start playout error: " + (Object)((Object)audioTrackStartErrorCode) + ". " + string2);
        WebRtcAudioUtils.logAudioState(TAG);
        Object object = errorCallbackOld;
        if (object != null) {
            object.onWebRtcAudioTrackStartError(string2);
        }
        if ((object = errorCallback) != null) {
            object.onWebRtcAudioTrackStartError(audioTrackStartErrorCode, string2);
        }
    }

    private void reportWebRtcAudioTrackError(String string2) {
        Logging.e(TAG, "Run-time playback error: " + string2);
        WebRtcAudioUtils.logAudioState(TAG);
        Object object = errorCallbackOld;
        if (object != null) {
            object.onWebRtcAudioTrackError(string2);
        }
        if ((object = errorCallback) != null) {
            object.onWebRtcAudioTrackError(string2);
        }
    }

    public static void setWebRtcAudioTrackCallback(WebRtcAudioTrackCallback webRtcAudioTrackCallback) {
        Logging.d(TAG, "Set track callback");
        mWebRtcAudioTrackCallback = webRtcAudioTrackCallback;
    }

    static {
        usageAttribute = DEFAULT_USAGE = WebRtcAudioTrack.getDefaultUsageAttribute();
    }

    public static interface WebRtcAudioTrackCallback {
        public void onWebRtcAudioTrackInit(int var1, int var2, int var3, int var4, int var5, int var6);

        public void onWebRtcAudioTrackStart();

        public void onWebRtcAudioTracking(ByteBuffer var1, int var2, boolean var3);

        public void onWebRtcAudioTrackStop();
    }

    public class AudioTrackThread
    extends Thread {
        public volatile boolean keepAlive;

        public AudioTrackThread(String string2) {
            super(string2);
            this.keepAlive = true;
        }

        private int writeBytes(AudioTrack audioTrack, ByteBuffer byteBuffer, int n3) {
            if (Build.VERSION.SDK_INT >= 21) {
                return audioTrack.write(byteBuffer, n3, 0);
            }
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), n3);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            int n3 = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                AudioTrackThread audioTrackThread = this;
                WebRtcAudioTrack webRtcAudioTrack = audioTrackThread.WebRtcAudioTrack.this;
                webRtcAudioTrack.nativeGetPlayoutData(n3, webRtcAudioTrack.nativeAudioTrack);
                WebRtcAudioTrack.assertTrue(n3 <= audioTrackThread.WebRtcAudioTrack.this.byteBuffer.remaining());
                if (speakerMute) {
                    AudioTrackThread audioTrackThread2 = this;
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.clear();
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                AudioTrackThread audioTrackThread3 = this;
                int n4 = audioTrackThread3.writeBytes(audioTrackThread3.WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n3);
                if (n4 != n3) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.write played invalid number of bytes: " + n4);
                    if (n4 < 0) {
                        this.keepAlive = false;
                        WebRtcAudioTrack.this.reportWebRtcAudioTrackError("AudioTrack.write failed: " + n4);
                    }
                } else if (mWebRtcAudioTrackCallback != null) {
                    mWebRtcAudioTrackCallback.onWebRtcAudioTracking(WebRtcAudioTrack.this.byteBuffer, n4, speakerMute);
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            if (WebRtcAudioTrack.this.audioTrack != null) {
                Logging.d(WebRtcAudioTrack.TAG, "Calling AudioTrack.stop...");
                try {
                    WebRtcAudioTrack.this.audioTrack.stop();
                    Logging.d(WebRtcAudioTrack.TAG, "AudioTrack.stop is done.");
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(WebRtcAudioTrack.TAG, a.a("AudioTrack.stop failed: ").append(illegalStateException.getMessage()).toString());
                }
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioTrack.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface ErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(AudioTrackStartErrorCode var1, String var2);

        public void onWebRtcAudioTrackError(String var1);
    }

    @Deprecated
    public static interface WebRtcAudioTrackErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(String var1);

        public void onWebRtcAudioTrackError(String var1);
    }

    public static enum AudioTrackStartErrorCode {
        AUDIO_TRACK_START_EXCEPTION,
        AUDIO_TRACK_START_STATE_MISMATCH;

    }
}

