/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import a.a.a.a.a;
import android.media.AudioRecord;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.webrtc.Logging;
import org.webrtc.ThreadUtils;
import org.webrtc.voiceengine.WebRtcAudioEffects;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioRecord {
    public static final boolean DEBUG = false;
    public static final String TAG = "WebRtcAudioRecord";
    public static final int BITS_PER_SAMPLE = 16;
    public static final int CALLBACK_BUFFER_SIZE_MS = 10;
    public static final int BUFFERS_PER_SECOND = 100;
    public static final int BUFFER_SIZE_FACTOR = 2;
    public static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    public static final int DEFAULT_AUDIO_SOURCE;
    public static int audioSource;
    public static volatile boolean microphoneMute;
    @Nullable
    public static WebRtcAudioRecordErrorCallback errorCallback;
    @Nullable
    public static WebRtcAudioRecordSamplesReadyCallback audioSamplesReadyCallback;
    public static WebRtcAudioRecordCallback mWebRtcAudioRecordCallback;
    public final long nativeAudioRecord;
    @Nullable
    public WebRtcAudioEffects effects;
    public ByteBuffer byteBuffer;
    @Nullable
    public AudioRecord audioRecord;
    @Nullable
    public AudioRecordThread audioThread;
    public byte[] emptyBytes;

    public static void setErrorCallback(WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = webRtcAudioRecordErrorCallback;
    }

    public static void setOnAudioSamplesReady(WebRtcAudioRecordSamplesReadyCallback webRtcAudioRecordSamplesReadyCallback) {
        audioSamplesReadyCallback = webRtcAudioRecordSamplesReadyCallback;
    }

    public WebRtcAudioRecord(long l3) {
        WebRtcAudioRecord webRtcAudioRecord = this;
        Logging.d(TAG, a.a("ctor").append(WebRtcAudioUtils.getThreadInfo()).toString());
        webRtcAudioRecord.nativeAudioRecord = l3;
        webRtcAudioRecord.effects = WebRtcAudioEffects.create();
    }

    private boolean enableBuiltInAEC(boolean bl) {
        Logging.d(TAG, "enableBuiltInAEC(" + bl + ')');
        WebRtcAudioEffects webRtcAudioEffects = ((WebRtcAudioRecord)((Object)webRtcAudioEffects)).effects;
        if (webRtcAudioEffects == null) {
            Logging.e(TAG, "Built-in AEC is not supported on this platform");
            return false;
        }
        return webRtcAudioEffects.setAEC(bl);
    }

    private boolean enableBuiltInNS(boolean bl) {
        Logging.d(TAG, "enableBuiltInNS(" + bl + ')');
        WebRtcAudioEffects webRtcAudioEffects = ((WebRtcAudioRecord)((Object)webRtcAudioEffects)).effects;
        if (webRtcAudioEffects == null) {
            Logging.e(TAG, "Built-in NS is not supported on this platform");
            return false;
        }
        return webRtcAudioEffects.setNS(bl);
    }

    private int initRecording(int n3, int n4) {
        Logging.d(TAG, "initRecording(sampleRate=" + n3 + ", channels=" + n4 + ")");
        if (((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).audioRecord != null) {
            ((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        WebRtcAudioRecord webRtcAudioRecord = webRtcAudioRecordCallback;
        int n5 = n3 / 100;
        webRtcAudioRecord.byteBuffer = ByteBuffer.allocateDirect(n4 * 2 * n5);
        Logging.d(TAG, a.a("byteBuffer.capacity: ").append(((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).byteBuffer.capacity()).toString());
        webRtcAudioRecord.emptyBytes = new byte[webRtcAudioRecord.byteBuffer.capacity()];
        webRtcAudioRecord.nativeCacheDirectBufferAddress(webRtcAudioRecord.byteBuffer, ((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).nativeAudioRecord);
        int n6 = ((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).channelCountToConfiguration(n4);
        int n7 = AudioRecord.getMinBufferSize((int)n3, (int)n6, (int)2);
        if (n7 != -1 && n7 != -2) {
            Object object;
            Logging.d(TAG, "AudioRecord.getMinBufferSize: " + n7);
            n7 = Math.max(n7 * 2, ((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).byteBuffer.capacity());
            Logging.d(TAG, "bufferSizeInBytes: " + n7);
            try {
                ((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).audioRecord = new AudioRecord(audioSource, n3, n6, 2, n7);
                object = ((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).audioRecord;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WebRtcAudioRecord webRtcAudioRecord2 = webRtcAudioRecordCallback;
                webRtcAudioRecord2.reportWebRtcAudioRecordInitError(a.a("AudioRecord ctor error: ").append(illegalArgumentException.getMessage()).toString());
                webRtcAudioRecord2.releaseAudioResources();
                return -1;
            }
            if (object != null && object.getState() == 1) {
                object = ((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).effects;
                if (object != null) {
                    ((WebRtcAudioEffects)object).enable(((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).audioRecord.getAudioSessionId());
                }
                WebRtcAudioRecord webRtcAudioRecord3 = webRtcAudioRecordCallback;
                webRtcAudioRecord3.logMainParameters();
                webRtcAudioRecord3.logMainParametersExtended();
                WebRtcAudioRecordCallback webRtcAudioRecordCallback = mWebRtcAudioRecordCallback;
                if (webRtcAudioRecordCallback != null) {
                    webRtcAudioRecordCallback.onWebRtcAudioRecordInit(audioSource, 2, n3, n4, 16, 100, n7);
                }
                return n5;
            }
            WebRtcAudioRecord webRtcAudioRecord4 = webRtcAudioRecordCallback;
            webRtcAudioRecord4.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance");
            webRtcAudioRecord4.releaseAudioResources();
            return -1;
        }
        ((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + n7);
        return -1;
    }

    private boolean startRecording() {
        block4: {
            Logging.d(TAG, "startRecording");
            WebRtcAudioRecord.assertTrue(this.audioRecord != null);
            WebRtcAudioRecord.assertTrue(this.audioThread == null);
            try {
                this.audioRecord.startRecording();
                if (mWebRtcAudioRecordCallback == null) break block4;
            }
            catch (IllegalStateException illegalStateException) {
                this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, a.a("AudioRecord.startRecording failed: ").append(illegalStateException.getMessage()).toString());
                return false;
            }
            mWebRtcAudioRecordCallback.onWebRtcAudioRecordStart();
        }
        if (this.audioRecord.getRecordingState() != 3) {
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, a.a("AudioRecord.startRecording failed - incorrect state :").append(this.audioRecord.getRecordingState()).toString());
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        WebRtcAudioRecord.assertTrue(((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).audioThread != null);
        WebRtcAudioRecord webRtcAudioRecord = webRtcAudioRecordCallback;
        webRtcAudioRecord.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(webRtcAudioRecord.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
            WebRtcAudioUtils.logAudioState(TAG);
        }
        ((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).audioThread = null;
        WebRtcAudioEffects webRtcAudioEffects = ((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).effects;
        if (webRtcAudioEffects != null) {
            webRtcAudioEffects.release();
        }
        ((WebRtcAudioRecord)((Object)webRtcAudioRecordCallback)).releaseAudioResources();
        WebRtcAudioRecordCallback webRtcAudioRecordCallback = mWebRtcAudioRecordCallback;
        if (webRtcAudioRecordCallback != null) {
            webRtcAudioRecordCallback.onWebRtcAudioRecordStop();
        }
        return true;
    }

    private void logMainParameters() {
        Logging.d(TAG, a.a("AudioRecord: session ID: ").append(this.audioRecord.getAudioSessionId()).append(", channels: ").append(this.audioRecord.getChannelCount()).append(", sample rate: ").append(this.audioRecord.getSampleRate()).toString());
    }

    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, a.a("AudioRecord: buffer size in frames: ").append(this.audioRecord.getBufferSizeInFrames()).toString());
        }
    }

    public static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n3) {
        return n3 == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    public static synchronized void setAudioSource(int n3) {
        Logging.w(TAG, a.a("Audio source is changed from: ").append(audioSource).append(" to ").append(n3).toString());
        audioSource = n3;
    }

    public static int getDefaultAudioSource() {
        return 7;
    }

    public static void setMicrophoneMute(boolean bl) {
        Logging.w(TAG, "setMicrophoneMute(" + bl + ")");
        microphoneMute = bl;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.release();
            this.audioRecord = null;
        }
    }

    private void reportWebRtcAudioRecordInitError(String string2) {
        Logging.e(TAG, "Init recording error: " + string2);
        WebRtcAudioUtils.logAudioState(TAG);
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordInitError(string2);
        }
    }

    private void reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode audioRecordStartErrorCode, String string2) {
        Logging.e(TAG, "Start recording error: " + (Object)((Object)audioRecordStartErrorCode) + ". " + string2);
        WebRtcAudioUtils.logAudioState(TAG);
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordStartError(audioRecordStartErrorCode, string2);
        }
    }

    private void reportWebRtcAudioRecordError(String string2) {
        Logging.e(TAG, "Run-time recording error: " + string2);
        WebRtcAudioUtils.logAudioState(TAG);
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordError(string2);
        }
    }

    public static void setWebRtcAudioRecordCallback(WebRtcAudioRecordCallback webRtcAudioRecordCallback) {
        Logging.d(TAG, "Set record callback");
        mWebRtcAudioRecordCallback = webRtcAudioRecordCallback;
    }

    static {
        audioSource = DEFAULT_AUDIO_SOURCE = WebRtcAudioRecord.getDefaultAudioSource();
    }

    public static interface WebRtcAudioRecordCallback {
        public void onWebRtcAudioRecordInit(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public void onWebRtcAudioRecordStart();

        public void onWebRtcAudioRecording(ByteBuffer var1, int var2, boolean var3);

        public void onWebRtcAudioRecordStop();
    }

    public class AudioRecordThread
    extends Thread {
        public volatile boolean keepAlive;

        public AudioRecordThread(String string2) {
            super(string2);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            block8: {
                Process.setThreadPriority((int)-19);
                Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
                WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
                System.nanoTime();
                while (this.keepAlive) {
                    int n3 = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                    if (n3 == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                        if (microphoneMute) {
                            AudioRecordThread audioRecordThread = this;
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.clear();
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                        }
                        if (this.keepAlive) {
                            WebRtcAudioRecord webRtcAudioRecord = WebRtcAudioRecord.this;
                            webRtcAudioRecord.nativeDataIsRecorded(n3, webRtcAudioRecord.nativeAudioRecord);
                            if (mWebRtcAudioRecordCallback != null) {
                                mWebRtcAudioRecordCallback.onWebRtcAudioRecording(WebRtcAudioRecord.this.byteBuffer, n3, microphoneMute);
                            }
                        }
                        if (audioSamplesReadyCallback == null) continue;
                        byte[] byArray = Arrays.copyOf(WebRtcAudioRecord.this.byteBuffer.array(), WebRtcAudioRecord.this.byteBuffer.capacity());
                        audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new AudioSamples(WebRtcAudioRecord.this.audioRecord, byArray, null));
                        continue;
                    }
                    String string2 = "AudioRecord.read failed: " + n3;
                    Logging.e(WebRtcAudioRecord.TAG, string2);
                    if (n3 != -3) continue;
                    this.keepAlive = false;
                    WebRtcAudioRecord.this.reportWebRtcAudioRecordError(string2);
                }
                if (WebRtcAudioRecord.this.audioRecord == null) break block8;
                try {
                    WebRtcAudioRecord.this.audioRecord.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(WebRtcAudioRecord.TAG, a.a("AudioRecord.stop failed: ").append(illegalStateException.getMessage()).toString());
                }
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface WebRtcAudioRecordSamplesReadyCallback {
        public void onWebRtcAudioRecordSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        public final int audioFormat;
        public final int channelCount;
        public final int sampleRate;
        public final byte[] data;

        public AudioSamples(AudioRecord audioRecord, byte[] byArray) {
            this.audioFormat = audioRecord.getAudioFormat();
            this.channelCount = audioRecord.getChannelCount();
            this.sampleRate = audioRecord.getSampleRate();
            this.data = byArray;
        }

        public /* synthetic */ AudioSamples(AudioRecord audioRecord, byte[] byArray, 1 var3_3) {
            this(audioRecord, byArray);
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface WebRtcAudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    public static enum AudioRecordStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }
}

