/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import a.a.a.a.a;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.Timer;
import java.util.TimerTask;
import org.webrtc.ContextUtils;
import org.webrtc.Logging;
import org.webrtc.voiceengine.WebRtcAudioEffects;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioManager {
    public static final boolean DEBUG = false;
    public static final String TAG = "WebRtcAudioManager";
    public static final boolean blacklistDeviceForAAudioUsage = true;
    public static boolean useStereoOutput;
    public static boolean useStereoInput;
    public static boolean blacklistDeviceForOpenSLESUsage;
    public static boolean blacklistDeviceForOpenSLESUsageIsOverridden;
    public static final int BITS_PER_SAMPLE = 16;
    public static final int DEFAULT_FRAME_PER_BUFFER = 256;
    public final long nativeAudioManager;
    public final AudioManager audioManager;
    public boolean initialized;
    public int nativeSampleRate;
    public int nativeChannels;
    public boolean hardwareAEC;
    public boolean hardwareAGC;
    public boolean hardwareNS;
    public boolean lowLatencyOutput;
    public boolean lowLatencyInput;
    public boolean proAudio;
    public boolean aAudio;
    public int sampleRate;
    public int outputChannels;
    public int inputChannels;
    public int outputBufferSize;
    public int inputBufferSize;
    public final VolumeLogger volumeLogger;

    public static synchronized void setBlacklistDeviceForOpenSLESUsage(boolean bl) {
        blacklistDeviceForOpenSLESUsageIsOverridden = true;
        blacklistDeviceForOpenSLESUsage = bl;
    }

    public static synchronized void setStereoOutput(boolean bl) {
        Logging.w(TAG, "Overriding default output behavior: setStereoOutput(" + bl + ')');
        useStereoOutput = bl;
    }

    public static synchronized void setStereoInput(boolean bl) {
        Logging.w(TAG, "Overriding default input behavior: setStereoInput(" + bl + ')');
        useStereoInput = bl;
    }

    public static synchronized boolean getStereoOutput() {
        return useStereoOutput;
    }

    public static synchronized boolean getStereoInput() {
        return useStereoInput;
    }

    public WebRtcAudioManager(long l3) {
        WebRtcAudioManager webRtcAudioManager = this;
        Logging.d(TAG, a.a("ctor").append(WebRtcAudioUtils.getThreadInfo()).toString());
        webRtcAudioManager.nativeAudioManager = l3;
        webRtcAudioManager.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        webRtcAudioManager.volumeLogger = new VolumeLogger(this.audioManager);
        webRtcAudioManager.storeAudioParameters();
        webRtcAudioManager.nativeCacheAudioParameters(webRtcAudioManager.sampleRate, this.outputChannels, this.inputChannels, this.hardwareAEC, this.hardwareAGC, this.hardwareNS, this.lowLatencyOutput, this.lowLatencyInput, this.proAudio, this.aAudio, this.outputBufferSize, this.inputBufferSize, l3);
        WebRtcAudioUtils.logAudioState(TAG);
    }

    private boolean init() {
        Logging.d(TAG, a.a("init").append(WebRtcAudioUtils.getThreadInfo()).toString());
        if (this.initialized) {
            return true;
        }
        Logging.d(TAG, a.a("audio mode is: ").append(WebRtcAudioUtils.modeToString(this.audioManager.getMode())).toString());
        this.initialized = true;
        this.volumeLogger.start();
        return true;
    }

    private void dispose() {
        Logging.d(TAG, a.a("dispose").append(WebRtcAudioUtils.getThreadInfo()).toString());
        if (!this.initialized) {
            return;
        }
        this.volumeLogger.stop();
    }

    private boolean isCommunicationModeEnabled() {
        return this.audioManager.getMode() == 3;
    }

    private boolean isDeviceBlacklistedForOpenSLESUsage() {
        boolean bl = blacklistDeviceForOpenSLESUsageIsOverridden ? blacklistDeviceForOpenSLESUsage : WebRtcAudioUtils.deviceIsBlacklistedForOpenSLESUsage();
        if (bl) {
            Logging.d(TAG, Build.MODEL + " is blacklisted for OpenSL ES usage!");
        }
        return bl;
    }

    private void storeAudioParameters() {
        int n3 = WebRtcAudioManager.getStereoOutput() ? 2 : 1;
        this.outputChannels = n3;
        n3 = WebRtcAudioManager.getStereoInput() ? 2 : 1;
        WebRtcAudioManager webRtcAudioManager = this;
        webRtcAudioManager.inputChannels = n3;
        webRtcAudioManager.sampleRate = webRtcAudioManager.getNativeOutputSampleRate();
        webRtcAudioManager.hardwareAEC = WebRtcAudioManager.isAcousticEchoCancelerSupported();
        webRtcAudioManager.hardwareAGC = false;
        webRtcAudioManager.hardwareNS = WebRtcAudioManager.isNoiseSuppressorSupported();
        webRtcAudioManager.lowLatencyOutput = webRtcAudioManager.isLowLatencyOutputSupported();
        webRtcAudioManager.lowLatencyInput = webRtcAudioManager.isLowLatencyInputSupported();
        webRtcAudioManager.proAudio = webRtcAudioManager.isProAudioSupported();
        webRtcAudioManager.aAudio = webRtcAudioManager.isAAudioSupported();
        n3 = webRtcAudioManager.lowLatencyOutput ? this.getLowLatencyOutputFramesPerBuffer() : WebRtcAudioManager.getMinOutputFrameSize(this.sampleRate, this.outputChannels);
        this.outputBufferSize = n3;
        n3 = this.lowLatencyInput ? this.getLowLatencyInputFramesPerBuffer() : WebRtcAudioManager.getMinInputFrameSize(this.sampleRate, this.inputChannels);
        this.inputBufferSize = n3;
    }

    private boolean hasEarpiece() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private boolean isLowLatencyOutputSupported() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    private boolean isProAudioSupported() {
        return Build.VERSION.SDK_INT >= 23 && ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.pro");
    }

    private boolean isAAudioSupported() {
        Logging.w(TAG, "AAudio support is currently disabled on all devices!");
        return false;
    }

    private int getNativeOutputSampleRate() {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Logging.d(TAG, "Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        if (WebRtcAudioUtils.isDefaultSampleRateOverridden()) {
            Logging.d(TAG, a.a("Default sample rate is overriden to ").append(WebRtcAudioUtils.getDefaultSampleRateHz()).append(" Hz").toString());
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        int n3 = this.getSampleRateForApiLevel();
        Logging.d(TAG, "Sample rate is set to " + n3 + " Hz");
        return n3;
    }

    private int getSampleRateForApiLevel() {
        if (Build.VERSION.SDK_INT < 17) {
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        String string2 = ((WebRtcAudioManager)((Object)string2)).audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return string2 == null ? WebRtcAudioUtils.getDefaultSampleRateHz() : Integer.parseInt(string2);
    }

    private int getLowLatencyOutputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(((WebRtcAudioManager)((Object)string2)).isLowLatencyOutputSupported());
        if (Build.VERSION.SDK_INT < 17) {
            return 256;
        }
        String string2 = ((WebRtcAudioManager)((Object)string2)).audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return string2 == null ? 256 : Integer.parseInt(string2);
    }

    public static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.canUseAcousticEchoCanceler();
    }

    public static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.canUseNoiseSuppressor();
    }

    public static int getMinOutputFrameSize(int n3, int n4) {
        int n5 = n4;
        n4 = n5 * 2;
        int n6 = n5 == 1 ? 4 : 12;
        return AudioTrack.getMinBufferSize((int)n3, (int)n6, (int)2) / n4;
    }

    private int getLowLatencyInputFramesPerBuffer() {
        WebRtcAudioManager webRtcAudioManager = this;
        WebRtcAudioManager.assertTrue(webRtcAudioManager.isLowLatencyInputSupported());
        return webRtcAudioManager.getLowLatencyOutputFramesPerBuffer();
    }

    public static int getMinInputFrameSize(int n3, int n4) {
        int n5 = n4;
        n4 = n5 * 2;
        int n6 = n5 == 1 ? 16 : 12;
        return AudioRecord.getMinBufferSize((int)n3, (int)n6, (int)2) / n4;
    }

    public static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private native void nativeCacheAudioParameters(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, int var12, long var13);

    public boolean isLowLatencyInputSupported() {
        return Build.VERSION.SDK_INT >= 21 && this.isLowLatencyOutputSupported();
    }

    public static class VolumeLogger {
        public static final String THREAD_NAME = "WebRtcVolumeLevelLoggerThread";
        public static final int TIMER_PERIOD_IN_SECONDS = 30;
        public final AudioManager audioManager;
        @Nullable
        public Timer timer;

        public VolumeLogger(AudioManager audioManager) {
            this.audioManager = audioManager;
        }

        private void stop() {
            Timer timer = this.timer;
            if (timer != null) {
                timer.cancel();
                this.timer = null;
            }
        }

        public void start() {
            this.timer = new Timer(THREAD_NAME);
            VolumeLogger volumeLogger = this;
            this.timer.schedule((TimerTask)volumeLogger.new LogVolumeTask(volumeLogger.audioManager.getStreamMaxVolume(2), this.audioManager.getStreamMaxVolume(0)), 0L, 30000L);
        }

        public class LogVolumeTask
        extends TimerTask {
            public final int maxRingVolume;
            public final int maxVoiceCallVolume;

            public LogVolumeTask(int n3, int n4) {
                this.maxRingVolume = n3;
                this.maxVoiceCallVolume = n4;
            }

            @Override
            public void run() {
                int n3 = VolumeLogger.this.audioManager.getMode();
                if (n3 == 1) {
                    Logging.d(WebRtcAudioManager.TAG, a.a("STREAM_RING stream volume: ").append(VolumeLogger.this.audioManager.getStreamVolume(2)).append(" (max=").append(this.maxRingVolume).append(")").toString());
                } else if (n3 == 3) {
                    Logging.d(WebRtcAudioManager.TAG, a.a("VOICE_CALL stream volume: ").append(VolumeLogger.this.audioManager.getStreamVolume(0)).append(" (max=").append(this.maxVoiceCallVolume).append(")").toString());
                }
            }
        }
    }
}

