/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import a.a.a.a.a;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.UUID;
import org.webrtc.Logging;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioEffects {
    public static final boolean DEBUG = false;
    public static final String TAG = "WebRtcAudioEffects";
    public static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    public static final UUID AOSP_NOISE_SUPPRESSOR = UUID.fromString("c06c8400-8e06-11e0-9cb6-0002a5d5c51b");
    @Nullable
    public static AudioEffect.Descriptor[] cachedEffects;
    @Nullable
    public AcousticEchoCanceler aec;
    @Nullable
    public NoiseSuppressor ns;
    public boolean shouldEnableAec;
    public boolean shouldEnableNs;

    public static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.isAcousticEchoCancelerEffectAvailable();
    }

    public static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.isNoiseSuppressorEffectAvailable();
    }

    public static boolean isAcousticEchoCancelerBlacklisted() {
        boolean bl = WebRtcAudioUtils.getBlackListedModelsForAecUsage().contains(Build.MODEL);
        if (bl) {
            Logging.w(TAG, Build.MODEL + " is blacklisted for HW AEC usage!");
        }
        return bl;
    }

    public static boolean isNoiseSuppressorBlacklisted() {
        boolean bl = WebRtcAudioUtils.getBlackListedModelsForNsUsage().contains(Build.MODEL);
        if (bl) {
            Logging.w(TAG, Build.MODEL + " is blacklisted for HW NS usage!");
        }
        return bl;
    }

    public static boolean isAcousticEchoCancelerExcludedByUUID() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        for (AudioEffect.Descriptor descriptor : WebRtcAudioEffects.getAvailableEffects()) {
            if (!descriptor.type.equals(AudioEffect.EFFECT_TYPE_AEC) || !descriptor.uuid.equals(AOSP_ACOUSTIC_ECHO_CANCELER)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoiseSuppressorExcludedByUUID() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        for (AudioEffect.Descriptor descriptor : WebRtcAudioEffects.getAvailableEffects()) {
            if (!descriptor.type.equals(AudioEffect.EFFECT_TYPE_NS) || !descriptor.uuid.equals(AOSP_NOISE_SUPPRESSOR)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAcousticEchoCancelerEffectAvailable() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AEC);
    }

    public static boolean isNoiseSuppressorEffectAvailable() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_NS);
    }

    public static boolean canUseAcousticEchoCanceler() {
        boolean bl = WebRtcAudioEffects.isAcousticEchoCancelerSupported() && !WebRtcAudioUtils.useWebRtcBasedAcousticEchoCanceler() && !WebRtcAudioEffects.isAcousticEchoCancelerBlacklisted() && !WebRtcAudioEffects.isAcousticEchoCancelerExcludedByUUID();
        Logging.d(TAG, "canUseAcousticEchoCanceler: " + bl);
        return bl;
    }

    public static boolean canUseNoiseSuppressor() {
        boolean bl = WebRtcAudioEffects.isNoiseSuppressorSupported() && !WebRtcAudioUtils.useWebRtcBasedNoiseSuppressor() && !WebRtcAudioEffects.isNoiseSuppressorBlacklisted() && !WebRtcAudioEffects.isNoiseSuppressorExcludedByUUID();
        Logging.d(TAG, "canUseNoiseSuppressor: " + bl);
        return bl;
    }

    public static WebRtcAudioEffects create() {
        return new WebRtcAudioEffects();
    }

    public WebRtcAudioEffects() {
        Logging.d(TAG, a.a("ctor").append(WebRtcAudioUtils.getThreadInfo()).toString());
    }

    private boolean effectTypeIsVoIP(UUID uUID) {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return AudioEffect.EFFECT_TYPE_AEC.equals(uUID) && WebRtcAudioEffects.isAcousticEchoCancelerSupported() || AudioEffect.EFFECT_TYPE_NS.equals(uUID) && WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    public static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    @Nullable
    public static AudioEffect.Descriptor[] getAvailableEffects() {
        AudioEffect.Descriptor[] descriptorArray = cachedEffects;
        if (cachedEffects != null) {
            return descriptorArray;
        }
        cachedEffects = AudioEffect.queryEffects();
        return cachedEffects;
    }

    public static boolean isEffectTypeAvailable(UUID uUID) {
        AudioEffect.Descriptor[] descriptorArray = WebRtcAudioEffects.getAvailableEffects();
        if (descriptorArray == null) {
            return false;
        }
        int n3 = descriptorArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            if (!descriptorArray[i3].type.equals(uUID)) continue;
            return true;
        }
        return false;
    }

    public boolean setAEC(boolean bl) {
        Logging.d(TAG, "setAEC(" + bl + ")");
        if (!WebRtcAudioEffects.canUseAcousticEchoCanceler()) {
            Logging.w(TAG, "Platform AEC is not supported");
            this.shouldEnableAec = false;
            return false;
        }
        if (this.aec != null && bl != this.shouldEnableAec) {
            Logging.e(TAG, "Platform AEC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAec = bl;
        return true;
    }

    public boolean setNS(boolean bl) {
        Logging.d(TAG, "setNS(" + bl + ")");
        if (!WebRtcAudioEffects.canUseNoiseSuppressor()) {
            Logging.w(TAG, "Platform NS is not supported");
            this.shouldEnableNs = false;
            return false;
        }
        if (this.ns != null && bl != this.shouldEnableNs) {
            Logging.e(TAG, "Platform NS state can't be modified while recording");
            return false;
        }
        this.shouldEnableNs = bl;
        return true;
    }

    public void enable(int n3) {
        StringBuilder stringBuilder;
        CharSequence charSequence;
        Logging.d(TAG, "enable(audioSession=" + n3 + ")");
        WebRtcAudioEffects.assertTrue(((WebRtcAudioEffects)((Object)stringBuilder2)).aec == null);
        WebRtcAudioEffects.assertTrue(((WebRtcAudioEffects)((Object)stringBuilder2)).ns == null);
        if (WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            ((WebRtcAudioEffects)((Object)stringBuilder2)).aec = AcousticEchoCanceler.create((int)n3);
            Object object = ((WebRtcAudioEffects)((Object)stringBuilder2)).aec;
            if (object != null) {
                boolean bl = object.getEnabled();
                boolean bl2 = ((WebRtcAudioEffects)((Object)stringBuilder2)).shouldEnableAec && WebRtcAudioEffects.canUseAcousticEchoCanceler();
                if (((WebRtcAudioEffects)((Object)stringBuilder2)).aec.setEnabled(bl2) != 0) {
                    Logging.e(TAG, "Failed to set the AcousticEchoCanceler state");
                }
                object = TAG;
                charSequence = a.a("AcousticEchoCanceler: was ");
                String string2 = bl ? "enabled" : "disabled";
                stringBuilder = charSequence.append(string2).append(", enable: ").append(bl2).append(", is now: ");
                charSequence = ((WebRtcAudioEffects)((Object)stringBuilder2)).aec.getEnabled() ? "enabled" : "disabled";
                Logging.d((String)object, stringBuilder.append((String)charSequence).toString());
            } else {
                Logging.e(TAG, "Failed to create the AcousticEchoCanceler instance");
            }
        }
        if (WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            ((WebRtcAudioEffects)((Object)stringBuilder2)).ns = NoiseSuppressor.create((int)n3);
            NoiseSuppressor noiseSuppressor = ((WebRtcAudioEffects)((Object)stringBuilder2)).ns;
            if (noiseSuppressor != null) {
                boolean bl = noiseSuppressor.getEnabled();
                boolean bl3 = ((WebRtcAudioEffects)((Object)stringBuilder2)).shouldEnableNs && WebRtcAudioEffects.canUseNoiseSuppressor();
                if (((WebRtcAudioEffects)((Object)stringBuilder2)).ns.setEnabled(bl3) != 0) {
                    Logging.e(TAG, "Failed to set the NoiseSuppressor state");
                }
                String string3 = TAG;
                stringBuilder = a.a("NoiseSuppressor: was ");
                charSequence = bl ? "enabled" : "disabled";
                WebRtcAudioEffects webRtcAudioEffects = stringBuilder2;
                StringBuilder stringBuilder2 = stringBuilder.append((String)charSequence).append(", enable: ").append(bl3).append(", is now: ");
                String string4 = webRtcAudioEffects.ns.getEnabled() ? "enabled" : "disabled";
                Logging.d(string3, stringBuilder2.append(string4).toString());
            } else {
                Logging.e(TAG, "Failed to create the NoiseSuppressor instance");
            }
        }
    }

    public void release() {
        Logging.d(TAG, "release");
        AcousticEchoCanceler acousticEchoCanceler = this.aec;
        if (acousticEchoCanceler != null) {
            acousticEchoCanceler.release();
            this.aec = null;
        }
        if ((acousticEchoCanceler = this.ns) != null) {
            acousticEchoCanceler.release();
            this.ns = null;
        }
    }
}

