/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audio;

import a.a.a.a.a;
import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.Logging;
import org.webrtc.ThreadUtils;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.audio.VolumeLogger;
import org.webrtc.audio.WebRtcAudioUtils;

public class WebRtcAudioTrack {
    public static final String TAG = "WebRtcAudioTrackExternal";
    public static final int BITS_PER_SAMPLE = 16;
    public static final int CALLBACK_BUFFER_SIZE_MS = 10;
    public static final int BUFFERS_PER_SECOND = 100;
    public static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    public static final int DEFAULT_USAGE = WebRtcAudioTrack.getDefaultUsageAttribute();
    public long nativeAudioTrack;
    public final Context context;
    public final AudioManager audioManager;
    public final ThreadUtils.ThreadChecker threadChecker;
    public ByteBuffer byteBuffer;
    @Nullable
    public AudioTrack audioTrack;
    @Nullable
    public AudioTrackThread audioThread;
    public final VolumeLogger volumeLogger;
    public volatile boolean isSleeping;
    public volatile boolean firstAfterSleep;
    public volatile boolean firstAfterWakerup;
    public volatile boolean speakerMute;
    public byte[] emptyBytes;
    @Nullable
    public final JavaAudioDeviceModule.AudioTrackErrorCallback errorCallback;
    public int oldSampleRate;
    public int oldChannels;

    public static int getDefaultUsageAttribute() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 0;
    }

    @CalledByNative
    public WebRtcAudioTrack(Context context, AudioManager audioManager) {
        this(context, audioManager, null);
    }

    public WebRtcAudioTrack(Context context, AudioManager audioManager, @Nullable JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        WebRtcAudioTrack webRtcAudioTrack2 = this;
        webRtcAudioTrack2.threadChecker = new ThreadUtils.ThreadChecker();
        webRtcAudioTrack2.isSleeping = false;
        webRtcAudioTrack2.firstAfterSleep = true;
        webRtcAudioTrack2.firstAfterWakerup = true;
        webRtcAudioTrack2.oldSampleRate = 0;
        webRtcAudioTrack2.oldChannels = 0;
        webRtcAudioTrack2.threadChecker.detachThread();
        this.context = context;
        this.audioManager = audioManager;
        webRtcAudioTrack.errorCallback = audioTrackErrorCallback;
        webRtcAudioTrack.volumeLogger = new VolumeLogger(audioManager);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNative
    private boolean initPlayout(int n3, int n4) {
        block5: {
            AudioTrack audioTrack;
            int n5 = n4;
            WebRtcAudioTrack webRtcAudioTrack = this;
            this.oldSampleRate = n3;
            this.oldChannels = n4;
            Logging.d(TAG, "(sampleRate=11111111111111111");
            this.threadChecker.checkIsOnValidThread();
            Logging.d(TAG, "(sampleRate=" + n3 + ", channels=" + n4 + ")");
            webRtcAudioTrack.byteBuffer = ByteBuffer.allocateDirect(n3 / 100 * (n4 *= 2));
            Logging.d(TAG, a.a("byteBuffer.capacity: ").append(this.byteBuffer.capacity()).toString());
            webRtcAudioTrack.emptyBytes = new byte[webRtcAudioTrack.byteBuffer.capacity()];
            WebRtcAudioTrack.nativeCacheDirectBufferAddress(webRtcAudioTrack.nativeAudioTrack, this.byteBuffer);
            n4 = this.channelCountToConfiguration(n5);
            int n6 = AudioTrack.getMinBufferSize((int)n3, (int)n4, (int)2);
            Logging.d(TAG, "AudioTrack.getMinBufferSize: " + n6);
            if (n6 < this.byteBuffer.capacity()) {
                this.reportWebRtcAudioTrackInitError("AudioTrack.getMinBufferSize returns an invalid value.");
                return false;
            }
            if (this.audioTrack != null) {
                this.reportWebRtcAudioTrackInitError("Conflict with existing AudioTrack.");
                return false;
            }
            try {
                this.audioTrack = Build.VERSION.SDK_INT >= 21 ? WebRtcAudioTrack.createAudioTrackOnLollipopOrHigher(n3, n4, n6) : WebRtcAudioTrack.createAudioTrackOnLowerThanLollipop(n3, n4, n6);
                audioTrack = this.audioTrack;
                if (audioTrack == null) break block5;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = illegalArgumentException.getMessage();
                WebRtcAudioTrack webRtcAudioTrack2 = this;
                webRtcAudioTrack2.reportWebRtcAudioTrackInitError(string2);
                webRtcAudioTrack2.releaseAudioResources();
                return false;
            }
            if (audioTrack.getState() == 1) {
                WebRtcAudioTrack webRtcAudioTrack3 = this;
                webRtcAudioTrack3.logMainParameters();
                webRtcAudioTrack3.logMainParametersExtended();
                return true;
            }
        }
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.reportWebRtcAudioTrackInitError("Initialization of audio track failed.");
        webRtcAudioTrack.releaseAudioResources();
        return false;
    }

    @CalledByNative
    private int getStreamMaxVolume() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamMaxVolume");
        return webRtcAudioTrack.audioManager.getStreamMaxVolume(0);
    }

    @CalledByNative
    private boolean setStreamVolume(int n3) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "setStreamVolume(" + n3 + ")");
        if (webRtcAudioTrack.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, n3, 0);
        return true;
    }

    private boolean isVolumeFixed() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    @CalledByNative
    private int getStreamVolume() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamVolume");
        return webRtcAudioTrack.audioManager.getStreamVolume(0);
    }

    private void logMainParameters() {
        Logging.d(TAG, a.a("AudioTrack: session ID: ").append(this.audioTrack.getAudioSessionId()).append(", channels: ").append(this.audioTrack.getChannelCount()).append(", sample rate: ").append(this.audioTrack.getSampleRate()).append(", max gain: ").append(AudioTrack.getMaxVolume()).toString());
    }

    @TargetApi(value=21)
    public static AudioTrack createAudioTrackOnLollipopOrHigher(int n3, int n4, int n5) {
        Logging.d(TAG, "createAudioTrackOnLollipopOrHigher");
        int n6 = AudioTrack.getNativeOutputSampleRate((int)0);
        Logging.d(TAG, "nativeOutputSampleRate: " + n6);
        if (n3 != n6) {
            Logging.w(TAG, "Unable to use fast mode since requested sample rate is not native");
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(DEFAULT_USAGE).setContentType(1).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(n3).setChannelMask(n4).build(), n5, 1, 0);
    }

    public static AudioTrack createAudioTrackOnLowerThanLollipop(int n3, int n4, int n5) {
        return new AudioTrack(0, n3, n4, 2, n5, 1);
    }

    private void logBufferSizeInFrames() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, a.a("AudioTrack: buffer size in frames: ").append(this.audioTrack.getBufferSizeInFrames()).toString());
        }
    }

    private void logBufferCapacityInFrames() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, a.a("AudioTrack: buffer capacity in frames: ").append(this.audioTrack.getBufferCapacityInFrames()).toString());
        }
    }

    private void logMainParametersExtended() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.logBufferSizeInFrames();
        webRtcAudioTrack.logBufferCapacityInFrames();
    }

    private void logUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, a.a("underrun count: ").append(this.audioTrack.getUnderrunCount()).toString());
        }
    }

    public static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n3) {
        return n3 == 1 ? 4 : 12;
    }

    public static native void nativeCacheDirectBufferAddress(long var0, ByteBuffer var2);

    public static native void nativeGetPlayoutData(long var0, int var2);

    private void releaseAudioResources() {
        Logging.d(TAG, "11111111111111");
        AudioTrack audioTrack = this.audioTrack;
        if (audioTrack != null) {
            audioTrack.release();
            this.audioTrack = null;
        }
    }

    private void reportWebRtcAudioTrackInitError(String string2) {
        WebRtcAudioTrack webRtcAudioTrack = object;
        Logging.e(TAG, "Init playout error: " + string2);
        Object object = webRtcAudioTrack.context;
        AudioManager audioManager = webRtcAudioTrack.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        object = webRtcAudioTrack.errorCallback;
        if (object != null) {
            object.onWebRtcAudioTrackInitError(string2);
        }
    }

    private void reportWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode audioTrackStartErrorCode, String string2) {
        WebRtcAudioTrack webRtcAudioTrack = object;
        Logging.e(TAG, "Start playout error: " + (Object)((Object)audioTrackStartErrorCode) + ". " + string2);
        Object object = webRtcAudioTrack.context;
        AudioManager audioManager = webRtcAudioTrack.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        object = webRtcAudioTrack.errorCallback;
        if (object != null) {
            object.onWebRtcAudioTrackStartError(audioTrackStartErrorCode, string2);
        }
    }

    private void reportWebRtcAudioTrackError(String string2) {
        WebRtcAudioTrack webRtcAudioTrack = object;
        Logging.e(TAG, "Run-time playback error: " + string2);
        Object object = webRtcAudioTrack.context;
        AudioManager audioManager = webRtcAudioTrack.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        object = webRtcAudioTrack.errorCallback;
        if (object != null) {
            object.onWebRtcAudioTrackError(string2);
        }
    }

    @CalledByNative
    public void setNativeAudioTrack(long l3) {
        this.nativeAudioTrack = l3;
    }

    @CalledByNative
    public boolean startPlayout() {
        block3: {
            WebRtcAudioTrack webRtcAudioTrack;
            Logging.d(TAG, a.a("isSleeping1=").append(this.isSleeping).toString());
            if (this.isSleeping) {
                WebRtcAudioTrack webRtcAudioTrack2 = this;
                Logging.d(TAG, a.a("restart initPlayout(sampleRate=").append(this.oldSampleRate).append(", channels=").append(this.oldChannels).append(")").toString());
                webRtcAudioTrack2.releaseAudioResources();
                Logging.d(TAG, "restart initPlayout(sampleRate=  testtttttt");
                webRtcAudioTrack2.initPlayout(webRtcAudioTrack2.oldSampleRate, this.oldChannels);
                Logging.d(TAG, a.a("(sampleRate=").append(this.oldSampleRate).append(", channels=").append(this.oldChannels).append(")").toString());
            }
            WebRtcAudioTrack webRtcAudioTrack3 = this;
            webRtcAudioTrack3.threadChecker.checkIsOnValidThread();
            webRtcAudioTrack3.volumeLogger.start();
            Logging.d(TAG, "startPlayout123456");
            WebRtcAudioTrack.assertTrue(webRtcAudioTrack3.audioTrack != null);
            WebRtcAudioTrack.assertTrue(this.audioThread == null);
            try {
                WebRtcAudioTrack webRtcAudioTrack4 = this;
                webRtcAudioTrack4.audioTrack.play();
                if (webRtcAudioTrack4.audioTrack.getPlayState() == 3) break block3;
                webRtcAudioTrack = this;
            }
            catch (IllegalStateException illegalStateException) {
                WebRtcAudioTrack webRtcAudioTrack5 = this;
                webRtcAudioTrack5.reportWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode.AUDIO_TRACK_START_EXCEPTION, a.a("AudioTrack.play failed: ").append(illegalStateException.getMessage()).toString());
                webRtcAudioTrack5.releaseAudioResources();
                return false;
            }
            webRtcAudioTrack.reportWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode.AUDIO_TRACK_START_STATE_MISMATCH, a.a("AudioTrack.play failed - incorrect state :").append(this.audioTrack.getPlayState()).toString());
            webRtcAudioTrack.releaseAudioResources();
            return false;
        }
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    @CalledByNative
    public boolean stopPlayout() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        Logging.d(TAG, "stopPlayout1234567");
        webRtcAudioTrack.volumeLogger.stop();
        Logging.d(TAG, "stopPlayout");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioThread != null);
        WebRtcAudioTrack webRtcAudioTrack2 = this;
        webRtcAudioTrack2.logUnderrunCount();
        webRtcAudioTrack2.audioThread.stopThread();
        Logging.d(TAG, "Stopping the AudioTrackThread...");
        webRtcAudioTrack2.audioThread.interrupt();
        if (!ThreadUtils.joinUninterruptibly(webRtcAudioTrack2.audioThread, 2000L)) {
            WebRtcAudioTrack webRtcAudioTrack3 = this;
            Logging.e(TAG, "Join of AudioTrackThread timed out.");
            Context context = webRtcAudioTrack3.context;
            AudioManager audioManager = webRtcAudioTrack3.audioManager;
            WebRtcAudioUtils.logAudioState(TAG, context, audioManager);
        }
        Logging.d(TAG, "AudioTrackThread has now been stopped.");
        this.audioThread = null;
        this.releaseAudioResources();
        return true;
    }

    public void setSpeakerMute(boolean bl) {
        Logging.w(TAG, "setSpeakerMute(" + bl + ")");
        this.speakerMute = bl;
    }

    public class AudioTrackThread
    extends Thread {
        public volatile boolean keepAlive;

        public AudioTrackThread(String string2) {
            super(string2);
            this.keepAlive = true;
        }

        private int writeBytes(AudioTrack audioTrack, ByteBuffer byteBuffer, int n3) {
            if (Build.VERSION.SDK_INT >= 21) {
                return audioTrack.write(byteBuffer, n3, 0);
            }
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), n3);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            int n3 = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                if (WebRtcAudioTrack.this.isSleeping) {
                    if (WebRtcAudioTrack.this.firstAfterSleep) {
                        WebRtcAudioTrack.this.audioTrack.pause();
                        WebRtcAudioTrack.this.firstAfterSleep = false;
                    }
                    try {
                        Thread.currentThread();
                    }
                    catch (Exception exception) {}
                    Thread.sleep(100L);
                    continue;
                }
                if (!WebRtcAudioTrack.this.isSleeping && WebRtcAudioTrack.this.firstAfterWakerup) {
                    WebRtcAudioTrack.this.audioTrack.play();
                    WebRtcAudioTrack.this.firstAfterWakerup = false;
                }
                AudioTrackThread audioTrackThread = this;
                WebRtcAudioTrack.nativeGetPlayoutData(audioTrackThread.WebRtcAudioTrack.this.nativeAudioTrack, n3);
                WebRtcAudioTrack.assertTrue(n3 <= audioTrackThread.WebRtcAudioTrack.this.byteBuffer.remaining());
                if (WebRtcAudioTrack.this.speakerMute) {
                    AudioTrackThread audioTrackThread2 = this;
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.clear();
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                AudioTrackThread audioTrackThread3 = this;
                WebRtcAudioTrack webRtcAudioTrack = audioTrackThread3.WebRtcAudioTrack.this;
                int n4 = audioTrackThread3.writeBytes(webRtcAudioTrack.audioTrack, webRtcAudioTrack.byteBuffer, n3);
                if (n4 != n3) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.write played invalid number of bytes: " + n4);
                    if (n4 < 0) {
                        this.keepAlive = false;
                        WebRtcAudioTrack.this.reportWebRtcAudioTrackError("AudioTrack.write failed: " + n4);
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            if (WebRtcAudioTrack.this.audioTrack != null) {
                Logging.d(WebRtcAudioTrack.TAG, "Calling AudioTrack.stop...");
                try {
                    WebRtcAudioTrack.this.audioTrack.stop();
                    Logging.d(WebRtcAudioTrack.TAG, "AudioTrack.stop is done.");
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(WebRtcAudioTrack.TAG, a.a("AudioTrack.stop failed: ").append(illegalStateException.getMessage()).toString());
                }
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioTrack.TAG, "stopThread");
            this.keepAlive = false;
        }
    }
}

