/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audio;

import a.a.a.a.a;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.webrtc.CalledByNative;
import org.webrtc.Logging;
import org.webrtc.ThreadUtils;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.audio.WebRtcAudioEffects;
import org.webrtc.audio.WebRtcAudioUtils;

public class WebRtcAudioRecord {
    public static final String TAG = "WebRtcAudioRecordExternal";
    public static final int CALLBACK_BUFFER_SIZE_MS = 10;
    public static final int BUFFERS_PER_SECOND = 100;
    public static final int BUFFER_SIZE_FACTOR = 2;
    public static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    public static final int DEFAULT_AUDIO_SOURCE = 7;
    public static final int DEFAULT_AUDIO_FORMAT = 2;
    public final Context context;
    public final AudioManager audioManager;
    public final int audioSource;
    public final int audioFormat;
    public long nativeAudioRecord;
    public final WebRtcAudioEffects effects;
    @Nullable
    public ByteBuffer byteBuffer;
    @Nullable
    public AudioRecord audioRecord;
    @Nullable
    public AudioRecordThread audioThread;
    public volatile boolean microphoneMute;
    public byte[] emptyBytes;
    @Nullable
    public final JavaAudioDeviceModule.AudioRecordErrorCallback errorCallback;
    @Nullable
    public final JavaAudioDeviceModule.SamplesReadyCallback audioSamplesReadyCallback;
    public final boolean isAcousticEchoCancelerSupported;
    public final boolean isNoiseSuppressorSupported;

    @CalledByNative
    public WebRtcAudioRecord(Context context, AudioManager audioManager) {
        boolean bl = WebRtcAudioEffects.isAcousticEchoCancelerSupported();
        boolean bl2 = WebRtcAudioEffects.isNoiseSuppressorSupported();
        this(context, audioManager, 7, 2, null, null, bl, bl2);
    }

    public WebRtcAudioRecord(Context context, AudioManager audioManager, int n3, int n4, @Nullable JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback, @Nullable JavaAudioDeviceModule.SamplesReadyCallback samplesReadyCallback, boolean bl, boolean bl2) {
        this.effects = new WebRtcAudioEffects();
        if (bl && !WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            throw new IllegalArgumentException("HW AEC not supported");
        }
        if (bl2 && !WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            throw new IllegalArgumentException("HW NS not supported");
        }
        this.context = context;
        this.audioManager = audioManager;
        this.audioSource = n3;
        this.audioFormat = n4;
        this.errorCallback = audioRecordErrorCallback;
        this.audioSamplesReadyCallback = samplesReadyCallback;
        this.isAcousticEchoCancelerSupported = bl;
        this.isNoiseSuppressorSupported = bl2;
    }

    @CalledByNative
    private boolean enableBuiltInAEC(boolean bl) {
        Logging.d(TAG, "enableBuiltInAEC(" + bl + ")");
        return this.effects.setAEC(bl);
    }

    @CalledByNative
    private boolean enableBuiltInNS(boolean bl) {
        Logging.d(TAG, "enableBuiltInNS(" + bl + ")");
        return this.effects.setNS(bl);
    }

    @CalledByNative
    private int initRecording(int n3, int n4) {
        Logging.d(TAG, "initRecording(sampleRate=" + n3 + ", channels=" + n4 + ")");
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        WebRtcAudioRecord webRtcAudioRecord = this;
        int n5 = n3 / 100;
        webRtcAudioRecord.byteBuffer = ByteBuffer.allocateDirect(WebRtcAudioRecord.getBytesPerSample(webRtcAudioRecord.audioFormat) * n4 * n5);
        if (!webRtcAudioRecord.byteBuffer.hasArray()) {
            this.reportWebRtcAudioRecordInitError("ByteBuffer does not have backing array.");
            return -1;
        }
        WebRtcAudioRecord webRtcAudioRecord2 = this;
        Logging.d(TAG, a.a("byteBuffer.capacity: ").append(this.byteBuffer.capacity()).toString());
        webRtcAudioRecord2.emptyBytes = new byte[webRtcAudioRecord2.byteBuffer.capacity()];
        webRtcAudioRecord2.nativeCacheDirectBufferAddress(webRtcAudioRecord2.nativeAudioRecord, this.byteBuffer);
        n4 = this.channelCountToConfiguration(n4);
        int n6 = AudioRecord.getMinBufferSize((int)n3, (int)n4, (int)this.audioFormat);
        if (n6 != -1 && n6 != -2) {
            AudioRecord audioRecord;
            Logging.d(TAG, "AudioRecord.getMinBufferSize: " + n6);
            n6 = Math.max(n6 * 2, this.byteBuffer.capacity());
            Logging.d(TAG, "bufferSizeInBytes: " + n6);
            try {
                audioRecord = this.audioRecord = new AudioRecord(this.audioSource, n3, n4, this.audioFormat, n6);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WebRtcAudioRecord webRtcAudioRecord3 = this;
                webRtcAudioRecord3.reportWebRtcAudioRecordInitError(a.a("AudioRecord ctor error: ").append(illegalArgumentException.getMessage()).toString());
                webRtcAudioRecord3.releaseAudioResources();
                return -1;
            }
            if (audioRecord != null && audioRecord.getState() == 1) {
                WebRtcAudioRecord webRtcAudioRecord4 = this;
                webRtcAudioRecord4.effects.enable(this.audioRecord.getAudioSessionId());
                webRtcAudioRecord4.logMainParameters();
                webRtcAudioRecord4.logMainParametersExtended();
                return n5;
            }
            WebRtcAudioRecord webRtcAudioRecord5 = this;
            webRtcAudioRecord5.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance");
            webRtcAudioRecord5.releaseAudioResources();
            return -1;
        }
        this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + n6);
        return -1;
    }

    @CalledByNative
    private boolean startRecording() {
        block2: {
            Logging.d(TAG, "startRecording");
            WebRtcAudioRecord.assertTrue(this.audioRecord != null);
            WebRtcAudioRecord.assertTrue(this.audioThread == null);
            try {
                WebRtcAudioRecord webRtcAudioRecord = this;
                webRtcAudioRecord.audioRecord.startRecording();
                if (webRtcAudioRecord.audioRecord.getRecordingState() == 3) break block2;
            }
            catch (IllegalStateException illegalStateException) {
                this.reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, a.a("AudioRecord.startRecording failed: ").append(illegalStateException.getMessage()).toString());
                return false;
            }
            this.reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, a.a("AudioRecord.startRecording failed - incorrect state :").append(this.audioRecord.getRecordingState()).toString());
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    @CalledByNative
    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        WebRtcAudioRecord.assertTrue(this.audioThread != null);
        WebRtcAudioRecord webRtcAudioRecord = this;
        webRtcAudioRecord.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(webRtcAudioRecord.audioThread, 2000L)) {
            WebRtcAudioRecord webRtcAudioRecord2 = this;
            Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
            Context context = webRtcAudioRecord2.context;
            AudioManager audioManager = webRtcAudioRecord2.audioManager;
            WebRtcAudioUtils.logAudioState(TAG, context, audioManager);
        }
        WebRtcAudioRecord webRtcAudioRecord3 = this;
        webRtcAudioRecord3.audioThread = null;
        webRtcAudioRecord3.effects.release();
        webRtcAudioRecord3.releaseAudioResources();
        return true;
    }

    private void logMainParameters() {
        Logging.d(TAG, a.a("AudioRecord: session ID: ").append(this.audioRecord.getAudioSessionId()).append(", channels: ").append(this.audioRecord.getChannelCount()).append(", sample rate: ").append(this.audioRecord.getSampleRate()).toString());
    }

    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, a.a("AudioRecord: buffer size in frames: ").append(this.audioRecord.getBufferSizeInFrames()).toString());
        }
    }

    public static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n3) {
        return n3 == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(long var1, ByteBuffer var3);

    private native void nativeDataIsRecorded(long var1, int var3);

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.release();
            this.audioRecord = null;
        }
    }

    private void reportWebRtcAudioRecordInitError(String string2) {
        WebRtcAudioRecord webRtcAudioRecord = object;
        Logging.e(TAG, "Init recording error: " + string2);
        Object object = webRtcAudioRecord.context;
        AudioManager audioManager = webRtcAudioRecord.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        object = webRtcAudioRecord.errorCallback;
        if (object != null) {
            object.onWebRtcAudioRecordInitError(string2);
        }
    }

    private void reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode audioRecordStartErrorCode, String string2) {
        WebRtcAudioRecord webRtcAudioRecord = object;
        Logging.e(TAG, "Start recording error: " + (Object)((Object)audioRecordStartErrorCode) + ". " + string2);
        Object object = webRtcAudioRecord.context;
        AudioManager audioManager = webRtcAudioRecord.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        object = webRtcAudioRecord.errorCallback;
        if (object != null) {
            object.onWebRtcAudioRecordStartError(audioRecordStartErrorCode, string2);
        }
    }

    private void reportWebRtcAudioRecordError(String string2) {
        WebRtcAudioRecord webRtcAudioRecord = object;
        Logging.e(TAG, "Run-time recording error: " + string2);
        Object object = webRtcAudioRecord.context;
        AudioManager audioManager = webRtcAudioRecord.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        object = webRtcAudioRecord.errorCallback;
        if (object != null) {
            object.onWebRtcAudioRecordError(string2);
        }
    }

    public static int getBytesPerSample(int n3) {
        if (n3 != 13) {
            switch (n3) {
                default: {
                    throw new IllegalArgumentException("Bad audio format " + n3);
                }
                case 4: {
                    return 4;
                }
                case 3: {
                    return 1;
                }
                case 1: 
                case 2: 
            }
        }
        return 2;
    }

    @CalledByNative
    public void setNativeAudioRecord(long l3) {
        this.nativeAudioRecord = l3;
    }

    @CalledByNative
    public boolean isAcousticEchoCancelerSupported() {
        return this.isAcousticEchoCancelerSupported;
    }

    @CalledByNative
    public boolean isNoiseSuppressorSupported() {
        return this.isNoiseSuppressorSupported;
    }

    public void setMicrophoneMute(boolean bl) {
        Logging.w(TAG, "setMicrophoneMute(" + bl + ")");
        this.microphoneMute = bl;
    }

    public class AudioRecordThread
    extends Thread {
        public volatile boolean keepAlive;

        public AudioRecordThread(String string2) {
            super(string2);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            block7: {
                Process.setThreadPriority((int)-19);
                Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
                WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
                System.nanoTime();
                while (this.keepAlive) {
                    int n3 = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                    if (n3 == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                        if (WebRtcAudioRecord.this.microphoneMute) {
                            AudioRecordThread audioRecordThread = this;
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.clear();
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                        }
                        if (this.keepAlive) {
                            WebRtcAudioRecord webRtcAudioRecord = WebRtcAudioRecord.this;
                            webRtcAudioRecord.nativeDataIsRecorded(webRtcAudioRecord.nativeAudioRecord, n3);
                        }
                        if (WebRtcAudioRecord.this.audioSamplesReadyCallback == null) continue;
                        AudioRecordThread audioRecordThread = this;
                        AudioRecordThread audioRecordThread2 = this;
                        n3 = audioRecordThread2.WebRtcAudioRecord.this.byteBuffer.capacity();
                        byte[] byArray = Arrays.copyOfRange(audioRecordThread.WebRtcAudioRecord.this.byteBuffer.array(), WebRtcAudioRecord.this.byteBuffer.arrayOffset(), audioRecordThread2.WebRtcAudioRecord.this.byteBuffer.arrayOffset() + n3);
                        audioRecordThread.WebRtcAudioRecord.this.audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new JavaAudioDeviceModule.AudioSamples(WebRtcAudioRecord.this.audioRecord.getAudioFormat(), WebRtcAudioRecord.this.audioRecord.getChannelCount(), WebRtcAudioRecord.this.audioRecord.getSampleRate(), byArray));
                        continue;
                    }
                    String string2 = "AudioRecord.read failed: " + n3;
                    Logging.e(WebRtcAudioRecord.TAG, string2);
                    if (n3 != -3) continue;
                    this.keepAlive = false;
                    WebRtcAudioRecord.this.reportWebRtcAudioRecordError(string2);
                }
                if (WebRtcAudioRecord.this.audioRecord == null) break block7;
                try {
                    WebRtcAudioRecord.this.audioRecord.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(WebRtcAudioRecord.TAG, a.a("AudioRecord.stop failed: ").append(illegalStateException.getMessage()).toString());
                }
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }
}

