/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import org.webrtc.CalledByNative;
import org.webrtc.Logging;
import org.webrtc.audio.WebRtcAudioUtils;

public class WebRtcAudioManager {
    public static final String TAG = "WebRtcAudioManagerExternal";
    public static final int DEFAULT_SAMPLE_RATE_HZ = 16000;
    public static final int BITS_PER_SAMPLE = 16;
    public static final int DEFAULT_FRAME_PER_BUFFER = 256;

    @CalledByNative
    public static AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    @CalledByNative
    public static int getOutputBufferSize(Context context, AudioManager audioManager, int n3, int n4) {
        return WebRtcAudioManager.isLowLatencyOutputSupported(context) ? WebRtcAudioManager.getLowLatencyFramesPerBuffer(audioManager) : WebRtcAudioManager.getMinOutputFrameSize(n3, n4);
    }

    @CalledByNative
    public static int getInputBufferSize(Context context, AudioManager audioManager, int n3, int n4) {
        return WebRtcAudioManager.isLowLatencyInputSupported(context) ? WebRtcAudioManager.getLowLatencyFramesPerBuffer(audioManager) : WebRtcAudioManager.getMinInputFrameSize(n3, n4);
    }

    public static boolean isLowLatencyOutputSupported(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    public static boolean isLowLatencyInputSupported(Context context) {
        return Build.VERSION.SDK_INT >= 21 && WebRtcAudioManager.isLowLatencyOutputSupported(context);
    }

    @CalledByNative
    public static int getSampleRate(AudioManager audioManager) {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Logging.d(TAG, "Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        int n3 = WebRtcAudioManager.getSampleRateForApiLevel(audioManager);
        Logging.d(TAG, "Sample rate is set to " + n3 + " Hz");
        return n3;
    }

    public static int getSampleRateForApiLevel(AudioManager object) {
        if (Build.VERSION.SDK_INT < 17) {
            return 16000;
        }
        return (object = object.getProperty("android.media.property.OUTPUT_SAMPLE_RATE")) == null ? 16000 : Integer.parseInt((String)object);
    }

    public static int getLowLatencyFramesPerBuffer(AudioManager object) {
        if (Build.VERSION.SDK_INT < 17) {
            return 256;
        }
        return (object = object.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) == null ? 256 : Integer.parseInt((String)object);
    }

    public static int getMinOutputFrameSize(int n3, int n4) {
        int n5 = n4;
        n4 = n5 * 2;
        int n6 = n5 == 1 ? 4 : 12;
        return AudioTrack.getMinBufferSize((int)n3, (int)n6, (int)2) / n4;
    }

    public static int getMinInputFrameSize(int n3, int n4) {
        int n5 = n4;
        n4 = n5 * 2;
        int n6 = n5 == 1 ? 16 : 12;
        return AudioRecord.getMinBufferSize((int)n3, (int)n6, (int)2) / n4;
    }
}

